unit Flowparm;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Buttons, AdPort, TComIni;

type
  TFlowControlForm = class(TForm)
    HardwareFlowGroup: TRadioGroup;
    SoftwareFlowGroup: TGroupBox;
    ReceiveFlowBox: TCheckBox;
    TransmitFlowBox: TCheckBox;
    Label1: TLabel;
    Label2: TLabel;
    XonCharEdit: TEdit;
    XoffCharEdit: TEdit;
    OkBtn: TBitBtn;
    CancelBtn: TBitBtn;
    HelpBtn: TBitBtn;
    procedure OkBtnClick(Sender: TObject);

  public
    constructor Create(AOwner : TComponent); override;
  end;

implementation

{$R *.DFM}

constructor TFlowControlForm.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);

  {set default values}
  if (hwfUseRTS in HdwFlow) or (hwfRequireCTS in HdwFlow) then
    HardwareFlowGroup.ItemIndex := 2
  else if (hwfUseDTR in HdwFlow) or (hwfRequireDSR in HdwFlow) then
    HardwareFlowGroup.ItemIndex := 1
  else
    HardwareFlowGroup.ItemIndex := 0;

  case SfwFlow of
    swfReceive : ReceiveFlowBox.Checked  := True;
    swfTransmit: TransmitFlowBox.Checked := True;
    swfBoth    :
      begin
        ReceiveFlowBox.Checked  := True;
        TransmitFlowBox.Checked := True;
      end;
  end;

  XonCharEdit.Text  := IntToStr(Ord(XonChar));
  XoffCharEdit.Text := IntToStr(ord(XoffChar));
end;

procedure TFlowControlForm.OkBtnClick(Sender: TObject);
var
  E    : Integer;
  Temp : Byte;

begin
  case HardwareFlowGroup.ItemIndex of
    0: HdwFlow := [];
    1: HdwFlow := [hwfUseDTR, hwfRequireDSR];
    2: HdwFlow := [hwfUseRTS, hwfRequireCTS];
  end;

  if TransmitFlowBox.Checked and ReceiveFlowBox.Checked then
    SfwFlow := swfBoth
  else if TransmitFlowBox.Checked then
    SfwFlow := swfTransmit
  else if ReceiveFlowBox.Checked then
    SfwFlow := swfReceive;

  Val(XonCharEdit.Text, Temp, E);
  if (E = 0) then
    XonChar := Char(Temp);
  Val(XoffCharEdit.Text, Temp, E);
  if (E = 0) then
    XoffChar := Char(Temp);
end;

end.

