{$G+,X+,F+}

{Conditional defines that may affect this unit}
{$I AWDEFINE.INC}

{*********************************************************}
{*                   MODINFO.PAS 1.00                    *}
{*        Copyright (c) TurboPower Software 1995         *}
{*                 All rights reserved.                  *}
{*********************************************************}

unit Modinfo;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, TagFrm, BaudFrm, AdMisc, AdModDB;

type
  TModemForm = class(TForm)
    GroupBox1: TGroupBox;
    Label1: TLabel;
    ModemNameEdit: TEdit;
    GroupBox2: TGroupBox;
    GroupBox3: TGroupBox;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    InitializeEdit: TEdit;
    DialEdit: TEdit;
    DialSuffixEdit: TEdit;
    CancelDialEdit: TEdit;
    HangupEdit: TEdit;
    ConfigureEdit: TEdit;
    AnswerEdit: TEdit;
    Label9: TLabel;
    OkayEdit: TEdit;
    Label10: TLabel;
    ConnectEdit: TEdit;
    Label11: TLabel;
    BusyEdit: TEdit;
    Label12: TLabel;
    VoiceEdit: TEdit;
    Label13: TLabel;
    NoCarrierEdit: TEdit;
    Label14: TLabel;
    NoDialtoneEdit: TEdit;
    Label15: TLabel;
    ErrorEdit: TEdit;
    RingEdit: TEdit;
    Label16: TLabel;
    CorrectionBtn: TButton;
    CompressBtn: TButton;
    BaudBtn: TButton;
    OkBtn: TBitBtn;
    CancelBtn: TBitBtn;
    HelpBtn: TBitBtn;
    procedure CorrectionBtnClick(Sender: TObject);
    procedure CompressBtnClick(Sender: TObject);
    procedure BaudBtnClick(Sender: TObject);
    procedure OkBtnClick(Sender: TObject);
  public
    EditData : PModemInfo;
    Database : TModemDBase;
    InitName : TModemName;

    constructor Create(AOwner : TComponent; var Data : TModemInfo; DB : TModemDBase);
  end;

var
  ModemForm: TModemForm;

implementation

{$R *.DFM}

constructor TModemForm.Create(AOwner : TComponent; var Data : TModemInfo; DB : TModemDBase);
begin
  inherited Create(AOwner);

  EditData := @Data;
  Database := DB;
  InitName := EditData^.Name;

  {set initial control values}
  with EditData^ do begin
    ModemNameEdit.Text  := Name;
    InitializeEdit.Text := InitCmd;
    DialEdit.Text       := DialCmd;
    DialSuffixEdit.Text := DialTerm;
    CancelDialEdit.Text := DialCancel;
    HangupEdit.Text     := HangupCmd;
    ConfigureEdit.Text  := ConfigCmd;
    AnswerEdit.Text     := AnswerCmd;
    OkayEdit.Text       := OkMsg;
    ConnectEdit.Text    := ConnectMsg;
    BusyEdit.Text       := BusyMsg;
    VoiceEdit.Text      := VoiceMsg;
    NoCarrierEdit.Text  := NoCarrierMsg;
    NoDialToneEdit.Text := NoDialToneMsg;
    ErrorEdit.Text      := ErrorMsg;
    RingEdit.Text       := RingMsg;
  end;
end;

procedure TModemForm.CorrectionBtnClick(Sender: TObject);
begin
  {get error correction tags}
  TagForm := TTagForm.Create(Self, EditData^.Errors, EditData^.NumErrors);
  TagForm.Caption := 'Error Correction';
  TagForm.ShowModal;
  TagForm.Free;
end;

procedure TModemForm.CompressBtnClick(Sender: TObject);
begin
  {get data compression tags}
  TagForm := TTagForm.Create(Self, EditData^.Compression, EditData^.NumComps);
  TagForm.Caption := 'Data Compression';
  TagForm.ShowModal;
  TagForm.Free;
end;

procedure TModemForm.BaudBtnClick(Sender: TObject);
begin
  {get default link rate information}
  BaudForm := TBaudForm.Create(Self, EditData^);
  BaudForm.ShowModal;
  BaudForm.Free;
end;

procedure TModemForm.OkBtnClick(Sender: TObject);
var
  MName : TModemName;

begin
  with EditData^ do begin
    {validate the modem name--has one been entered?}
    MName := TrimTrail(ModemNameEdit.Text);
    if (MName = '') then begin
      ModalResult := mrNone;
      ModemNameEdit.SetFocus;
      raise Exception.Create('You must enter a modem name');
    end;

    {the modem name must be unique}
    if (UpperCase(MName) <> UpperCase(InitName)) and (Database.Modems.IndexOf(MName) <> -1) then begin
      ModalResult := mrNone;
      ModemNameEdit.SetFocus;
      raise Exception.Create('A modem with that name already exists');
    end;

    {save data}
    Name          := TrimTrail(ModemNameEdit.Text);
    InitCmd       := TrimTrail(InitializeEdit.Text);
    DialCmd       := TrimTrail(DialEdit.Text);
    DialTerm      := TrimTrail(DialSuffixEdit.Text);
    DialCancel    := TrimTrail(CancelDialEdit.Text);
    HangupCmd     := TrimTrail(HangupEdit.Text);
    ConfigCmd     := TrimTrail(ConfigureEdit.Text);
    AnswerCmd     := TrimTrail(AnswerEdit.Text);
    OkMsg         := TrimTrail(OkayEdit.Text);
    ConnectMsg    := TrimTrail(ConnectEdit.Text);
    BusyMsg       := TrimTrail(BusyEdit.Text);
    VoiceMsg      := TrimTrail(VoiceEdit.Text);
    NoCarrierMsg  := TrimTrail(NoCarrierEdit.Text);
    NoDialToneMsg := TrimTrail(NoDialToneEdit.Text);
    ErrorMsg      := TrimTrail(ErrorEdit.Text);
    RingMsg       := TrimTrail(RingEdit.Text);
  end;

  ModalResult := mrOK;
end;

end.
