unit Qmodem;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, AdModDB, TComIni;

type
  TQuickModemForm = class(TForm)
    ModemList: TListBox;
    OkBtn: TBitBtn;
    CancelBtn: TBitBtn;
    HelpBtn: TBitBtn;
    procedure ModemListDblClick(Sender: TObject);
    procedure OkBtnClick(Sender: TObject);

  public
    ModemDB : TModemDBase;

    constructor Create(AOwner : TComponent; DB : TModemDBase);
  end;

implementation

{$R *.DFM}

constructor TQuickModemForm.Create(AOwner : TComponent; DB : TModemDBase);
begin
  inherited Create(AOwner);

  ModemDB         := DB;
  ModemList.Items := ModemDB.Modems;
end;

procedure TQuickModemForm.ModemListDblClick(Sender: TObject);
begin
  OkBtnClick(Sender);
  ModalResult := mrOK;
end;

procedure TQuickModemForm.OkBtnClick(Sender: TObject);
var
  Modem : String;

begin
  if (ModemList.ItemIndex <> -1) then begin
    Modem := ModemList.Items[ModemList.ItemIndex];
    ModemDB.GetModem(Modem, ModemInfo);
  end else
    ModalResult := mrCancel;
end;

end.

