unit Main;

{
  This is a test program for the TBmpListBox and TBmpComboBox
  components. See BMPLBOX.PAS for details and documentation.

  You mmust install the components in BMPLBOX.PAS before running
  this sample program.

  The "Color" button shows you how the TransparentColor property
  works. When you click on it, the property switches between blue
  and red. This shows you that the selected color becomes transparent
  when the listbox or combobox item is displayed.

  The "Margin" button demonstrates that the gap between the text
  and the bitmap can be dynamically adjusted. This margin also
  applies to the left of the bitmap.

  Also, observe how the glyph index is passed to AddObject. The HiWord
  of the pseudo TObject reference is used to pass the glyph index and
  you can use the LoWord for your own needs. You can associate any glyph
  from the bitmap strip to any item in the list.

  Since you have access to Items.Objects[i], you can change this value
  dynamically.

  Have fun!

  -Patrick Philippot (MainSoft sarl)
}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, Menus, Bmplbox;

type
  TMainForm = class(TForm)
    BmpListBox1: TBmpListBox;
    Button1: TButton;
    Button2: TButton;
    BmpComboBox1: TBmpComboBox;
    Button3: TButton;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.FormCreate(Sender: TObject);
begin
  BmpListBox1.Items.AddObject('String 1', TObject(Makelong(0, 0)));
  BmpListBox1.Items.AddObject('String 2', TObject(Makelong(0, 1)));
  BmpListBox1.Items.AddObject('String 3', TObject(Makelong(0, 2)));
  BmpListBox1.Items.AddObject('String 4', TObject(Makelong(0, 3)));
  BmpListBox1.Items.AddObject('String 5', TObject(Makelong(0, 4)));
  BmpComboBox1.Items.AddObject('String 1', TObject(Makelong(0, 0)));
  BmpComboBox1.Items.AddObject('String 2', TObject(Makelong(0, 1)));
  BmpComboBox1.Items.AddObject('String 3', TObject(Makelong(0, 2)));
  BmpComboBox1.Items.AddObject('String 4', TObject(Makelong(0, 3)));
  BmpComboBox1.Items.AddObject('String 5', TObject(Makelong(0, 4)));

end;

procedure TMainForm.Button1Click(Sender: TObject);
begin
  if BmpListBox1.TransparentColor = clRed then begin
    BmpListBox1.TransparentColor := clBlue;
    BmpComboBox1.TransparentColor := clBlue;
  end else begin
    BmpListBox1.TransparentColor := clRed;
    BmpComboBox1.TransparentColor := clRed;
  end;
end;

procedure TMainForm.Button2Click(Sender: TObject);
begin
  if BmpListBox1.LeftMargin = 4 then begin
    BmpListBox1.LeftMargin := 8;
    BmpComboBox1.LeftMargin := 8;
  end else begin
    BmpListBox1.LeftMargin := 4;
    BmpComboBox1.LeftMargin := 4;
  end;
end;

procedure TMainForm.Button3Click(Sender: TObject);
begin
  Application.Terminate;
end;

end.
