{$S-,R-,V-,I-,B-,F-,W-,A-,G+,X+}
{$C DEMANDLOAD,DISCARDABLE}

library VBDTool;
{$R DTOOL.RES}
{$D Micro System Solutions - MS VB3.0 dTool}

uses

	WsDos,
    WinDos,
	wintypes,
	winprocs,

	vbapi_,
	strings;

{//---------------------------------------------------------------------------
// Resource ID's
//---------------------------------------------------------------------------
// Toolbox bitmap resource IDs.
//---------------------------------------------------------------------------}
const
	UpTool	= 8000;
	DnTool	= 8001;
	MonoTool= 8003;
	EGATool	= 8006;
	DemoVersion = 4001;

{//---------------------------------------------------------------------------
// Standard Error Values
//---------------------------------------------------------------------------}
const
	ERR_None	      =	0;
	ERR_InvPropVal	  =	380; 	{/ Error$(380) = "Invalid property value"}
	shutdown:	boolean = false;

{//---------------------------------------------------------------------------
// control data and structs
//---------------------------------------------------------------------------}
type
	pdTool = ^tdTool;
	tdTool = record
		usPathLen:	integer;
		hszPathString:	Hsz;
		hszDiskType:    Hsz;
		hszDrive:		Hsz;
		hszVolume:		Hsz;
		ulSize:         longInt;
		hszDate:        Hsz;
		hszTime:        Hsz;
		ulBytesPerCluster:  longint;
		ulDiskCapacity:     longInt;
		ulFreeSpace:        longInt;
		usClustersAvail:    longint;
		usTotalClusters:    Longint;
		usBytesPerSector:   longint;
		usSectorsPerCluster:     longint;
		usAction:		Integer;
	end;

const
	bDevTimeInit:	boolean = false;
	cVbxUsers:		integer = 0;

	fLicensed:            boolean = false;

var
	lLicID:     longInt;
	szBf:   array[0..48] of char;
	dToolRec:	pdTool;
	hModDll:	tHandle;
	tBmap:		HBitMap;
	bmWidth:	integer;
	bmHeight:	integer;
	strBuf:		array[0..24] of char;
	DBuff:      TSearchRec;

const
	PathLenName:	array[0..12] of Char = 'Status'#0;
	Prop_PathLen: tPROPINFO  = (
		npszName: 	tOffset(@PathLenName);
		fl:		  	DT_Short or PF_fGetData or PF_fSetData or PF_fSaveData;
		offsetData: 0; infoData: 0; dataDefault: 0; npszEnumList: 0; enumMax: 0);

	PathStrName:	array[0..12] of Char = 'Path String'#0;
	Prop_PathStr: tPROPINFO  = (
		npszName: 	tOffset(@PathStrName);
		fl:		  	DT_HSZ or PF_fGetData or PF_fSetData or PF_fSaveData;
		offsetData: 0; infoData: 0; dataDefault: 0; npszEnumList: 0; enumMax: 0);

	DriveName:	array[0..12] of Char = 'Drive'#0;
	Prop_DriveLtr: tPROPINFO  = (
		npszName: 	tOffset(@DriveName);
		fl:		  	DT_Hsz or PF_fGetData or PF_fSetData or PF_fSaveData;
		offsetData: 0; infoData: 0; dataDefault: 0; npszEnumList: 0; enumMax: 0);

	DiskTypeName:	array[0..12] of Char = 'DiskType'#0;
	Prop_DiskType: tPROPINFO  = (
		npszName: 	tOffset(@DiskTypeName);
		fl:		  	DT_Hsz or PF_fGetData or PF_fSetData or PF_fSaveData;
		offsetData: 0; infoData: 0; dataDefault: 0; npszEnumList: 0; enumMax: 0);

	VolumeName:	array[0..12] of Char = 'Volume'#0;
	Prop_Volume: tPROPINFO  = (
		npszName: 	tOffset(@VolumeName);
		fl:		  	DT_HSZ or PF_fGetData or PF_fSetData or PF_fSaveData;
		offsetData: 0; infoData: 0; dataDefault: 0; npszEnumList: 0; enumMax: 0);

	SizeName:	array[0..12] of Char = 'Size'#0;
	Prop_FileSize:  tPROPINFO  = (
		npszName: 	tOffset(@SizeName);
		fl:		  	DT_Long or PF_fGetData or PF_fSetData or PF_fSaveData;
		offsetData: 0; infoData: 0; dataDefault: 0; npszEnumList: 0; enumMax: 0);

	DateName:	array[0..12] of Char = 'Date'#0;
	Prop_Date: tPROPINFO  = (
		npszName: 	tOffset(@DateName);
		fl:		  	DT_Hsz or PF_fGetData or PF_fSetData or PF_fSaveData;
		offsetData: 0; infoData: 0; dataDefault: 0; npszEnumList: 0; enumMax: 0);

	TimeName:	array[0..12] of Char = 'Time'#0;
	Prop_Time: tPROPINFO  = (
		npszName: 	tOffset(@TimeName);
		fl:		  	DT_Hsz or PF_fGetData or PF_fSetData or PF_fSaveData;
		offsetData: 0; infoData: 0; dataDefault: 0; npszEnumList: 0; enumMax: 0);

	BPCName:	array[0..16] of Char = 'BytesPerCluster'#0;
	Prop_BPC: tPROPINFO  = (
		npszName: 	tOffset(@BPCName);
		fl:		  	DT_Long or PF_fGetData or PF_fSetData or PF_fSaveData;
		offsetData: 0; infoData: 0; dataDefault: 0; npszEnumList: 0; enumMax: 0);

	DCName:	array[0..13] of Char = 'DiskCapacity'#0;
	Prop_DC: tPROPINFO  = (
		npszName: 	tOffset(@DCName);
		fl:		  	DT_Long or PF_fGetData or PF_fSetData or PF_fSaveData;
		offsetData: 0; infoData: 0; dataDefault: 0; npszEnumList: 0; enumMax: 0);

	FSName:	array[0..12] of Char = 'FreeSpace'#0;
	Prop_FS: tPROPINFO  = (
		npszName: 	tOffset(@FSName);
		fl:		  	DT_Long or PF_fGetData or PF_fSetData or PF_fSaveData;
		offsetData: 0; infoData: 0; dataDefault: 0; npszEnumList: 0; enumMax: 0);

	CAName:	array[0..18] of Char = 'ClustersAvailable'#0;
	Prop_CA: tPROPINFO  = (
		npszName: 	tOffset(@CAName);
		fl:		  	DT_Long or PF_fGetData or PF_fSetData or PF_fSaveData;
		offsetData: 0; infoData: 0; dataDefault: 0; npszEnumList: 0; enumMax: 0);

	TCName:	array[0..14] of Char = 'TotalClusters'#0;
	Prop_TC: tPROPINFO  = (
		npszName: 	tOffset(@TCName);
		fl:		  	DT_Long or PF_fGetData or PF_fSetData or PF_fSaveData;
		offsetData: 0; infoData: 0; dataDefault: 0; npszEnumList: 0; enumMax: 0);

	BPSName:	array[0..15] of Char = 'BytesPerSector'#0;
	Prop_BPS: tPROPINFO  = (
		npszName: 	tOffset(@BPSName);
		fl:		  	DT_Long or PF_fGetData or PF_fSetData or PF_fSaveData;
		offsetData: 0; infoData: 0; dataDefault: 0; npszEnumList: 0; enumMax: 0);

	SPCName:	array[0..18] of Char = 'SectorsPerCluster'#0;
	Prop_SPC: tPROPINFO  = (
		npszName: 	tOffset(@SPCName);
		fl:		  	DT_Long or PF_fGetData or PF_fSetData or PF_fSaveData;
		offsetData: 0; infoData: 0; dataDefault: 0; npszEnumList: 0; enumMax: 0);

	ActionName:	array[0..12] of Char = 'Action'#0;
	Property_Action: tPROPINFO  = (
		npszName: 	tOffset(@ActionName);
		fl:		  	DT_SHORT or PF_fSetMsg or PF_fNoShow;
		offsetData: 0; infoData: 0; dataDefault: 0; npszEnumList: 0; enumMax: 0);

type
	iPropIndex = (
		IPROP_NAME,
		IPROP_Tag,
		IPROP_LEFT,
		IPROP_Top,
		iProp_PathLen,
		iProp_PathStr,
		iProp_Drive,
		iProp_DiskType,
		iProp_Volume,
		iProp_Size,
		iProp_Date,
		iProp_Time,
		iProp_BPC,
		iProp_DC,
        iProp_FS,
        iProp_CA,
	    iProp_TC,
        iProp_BPS,
        iProp_SPC,
		iProp_Action,
		IPROP_Last);

const
	PropertyList : array[IPROPIndex]of ofsPPROPINFO = (
	pPROPInfo_STD_CTLNAME,
	PPROPINFO_STD_TAG,
	PPROPINFO_STD_LEFT,
	PPROPINFO_STD_Top,
	tOffset(@Prop_PathLen),		{Integer Value}
	tOffset(@Prop_PathStr),		{String Value}
	tOffset(@Prop_DriveLtr),		{Disk Drive letter}
	tOffset(@Prop_DiskType),		{Disk Drive letter}
	tOffset(@Prop_Volume),		{Volume Name}
	tOffset(@Prop_FileSize),		{Volume Name}
	tOffset(@Prop_Date),		{Volume Name}
	tOffset(@Prop_Time),		{Volume Name}
	tOffset(@Prop_BPC),
	tOffset(@Prop_DC),
	tOffset(@Prop_FS),
	tOffset(@Prop_CA),
	tOffset(@Prop_TC),
	tOffset(@Prop_BPS),
	tOffset(@Prop_SPC),
	tOffset(@Property_Action),		{ Action }
	0);								{Last}

{//---------------------------------------------------------------------------
// Event Procedure Parameter Profiles go here
//---------------------------------------------------------------------------}


procedure PaintControl(Wnd: HWnd);
var
	hdcMem:	Hdc;
	ps:		tPaintStruct;
begin
	BeginPaint(Wnd, ps);
	hdcMem := CreateCompatibleDC(ps.hDc);
	if (hdcMem = 0) then exit;
	SelectObject(hdcMem, tBmap);
	{ Display the bitmap in the sizing rectangle}
	BitBlt(ps.hdc, 0, 0, bmWidth, bmHeight, hdcMem, 0, 0, SRCCopy);
	DeleteDC(hdcMem);
	EndPaint(Wnd, ps);
end;

function IntToStr(I: Longint): String;
{ Convert any integer type to a string }
var
   S: string[11];
begin
	 Str(I, S);
	 IntToStr := S;
end;

function DiskInfo(DriveLtr: char): longInt;
var
   drvNr:   byte;
begin
	 drvNr := ord(upCase(DriveLtr)) - ord('A')+1;
	 dToolRec^.ulDiskCapacity := 0;
	 with dToolRec^ do begin
		 if GetDiskInfo(drvNr, word(usClustersAvail), word(usTotalClusters),
				 word(usBytesPerSector), word(usSectorsPerCluster)) then begin
			ulBytesPerCluster := longInt(usSectorsPerCluster) * usBytesPerSector;
			ulDiskCapacity := LongInt(usTotalClusters) * ulBytesPerCluster;
			ulFreeSpace := LongInt(usClustersAvail) * ulBytesPerCluster;
		 end;
	 end;
	 DiskInfo := dToolRec^.ulDiskCapacity;
end;

function DiskType(DriveLtr: char): string;
const
  DiskClassName:    array[DiskClass] of string[12] = (
                               'Floppy360', 'Floppy720', 'Floppy12', 'Floppy144',
                               'OtherFloppy', 'Bernoulli', 'HardDisk', 'RamDisk',
                               'SubstDrive', 'UnknownDisk', 'InvalidDrive',
                               'NovellDrive', 'CDRomDisk');

  {This enumerated type defines the nine classes of disks that can be identified by
  [GetDiskClass], as well as several types used as error indications}

var
   SubstDriveLtr:   char;
   ThisDiskType:         diskClass;
begin
	 ThisDiskType := GetDiskClass(DriveLtr, SubstDriveLtr);
	 DiskType := IntToStr(ord(ThisDiskType)) + ' ' + DiskClassName[ThisDiskType];
end;

function CtlProc(Control: HCtl; Wnd: HWnd;
			Msg, WParam: Word; LParam: LongInt):LongInt; export;
const
	Gen_StrLen = 1;
	ReadVolume = 2;
	lpPath:      array[0..12] of char = 'A:\*.*'#0;
var
	stDType:     string;
    arDType:      array[0..12] of char;
    lpDType:     lpStr;

    stDate:     string[12];
    arDate:      array[0..12] of char;
    lpDate:     lpStr;

    stTime:     string[12];
	arTime:      array[0..12] of char;
    lpTime:     lpStr;

	DT:         TDateTime;
    lpPathLen:     lpStr;
	lpDrv:		lpStr;
	lpVolName:	lpStr;
	VolName:	array[0..11] of char;
	status:		word;
begin
	case Msg of
		WM_SIZE:	SetWindowPos(Wnd, 0, 0, 0, bmWidth, bmHeight, SWP_NOMOVE or SWP_NOZORDER);
		WM_PAINT:	PaintControl(Wnd);
		VBM_CREATED:	if (VBGetMode = MODE_RUN) then begin
							CtlProc := 0;
							exit;
						end;
		VBM_SETPROPERTY:	begin
			dToolRec := VBDerefControl(Control);
			case wParam of
				ord(IPROP_Action): begin
					case lParam of
						Gen_StrLen:	begin
							lpPathLen := VBDerefHsz(dToolRec^.hszPathString);
							dToolRec^.usPathLen := StrLen(lpPathLen);
						end;
						ReadVolume:	begin
							lpDrv := VBDerefHsz(dToolRec^.hszDrive);
							lpVolName := @VolName;
							status  := GetVolumeLabel(lpVolName, lpDrv^);
							if status = 0 then begin
								dToolRec := VBDerefControl(Control);
								if (dToolRec^.hszVolume <> nil) then begin
									VBDestroyHsz(dToolRec^.hszVolume);
								end;
								if (dToolRec^.hszDate <> nil) then begin
									VBDestroyHsz(dToolRec^.hszDate);
								end;
								if (dToolRec^.hszTime <> nil) then begin
									VBDestroyHsz(dToolRec^.hszTime);
								end;
								if (dToolRec^.hszDiskType <> nil) then begin
									VBDestroyHsz(dToolRec^.hszDiskType);
								end;

								dToolRec := VBDerefControl(Control);

								stDType := DiskType(lpDrv^);
								strPCopy(arDType, stDType);
								lpDType := @arDType;
								dToolRec^.hszDiskType := VBCreateHsz(pHandle(seg(Control^)), lpDType);

								dToolRec^.hszVolume := VBCreateHsz(pHandle(seg(Control^)), lpVolName);
								lpPath[0] := lpDrv^;
								FindFirst(lpPath, faVolumeId, dBuff);
								dToolRec := VBDerefControl(Control);

								UnPackTime(DBuff.Time, DT);
								stDate := intToStr(DT.month) + '/' + intToStr(DT.day) + '/' + intToStr(DT.year);
								strPCopy(arDate, stDate);
								lpDate := @arDate;
								dToolRec^.hszDate := VBCreateHsz(pHandle(seg(Control^)), lpDate);

								stTime := intToStr(DT.hour) + ':' + intToStr(DT.min) + ':' + intToStr(DT.sec);
								strPCopy(arTime, stTime);
								lpTime := @arTime;
								dToolRec^.hszTime := VBCreateHsz(pHandle(seg(Control^)), lpTime);

								dToolRec^.hszPathString := VBCreateHsz(pHandle(seg(Control^)), lpPath);


								dToolRec^.ulSize := DiskInfo(lpDrv^);

								CtlProc := 0;
								exit;
							end else begin
								dToolRec^.usPathLen := Status;
								CtlProc := 0;
								exit;
							end;
						end;
					end;
					dToolRec^.usAction := lParam;
					CtlProc := 0;
					exit;
				end;
			end;
		end;
	end;

	{Default processing:}
	CtlProc := VBDefControlProc(Control, Wnd, Msg, WParam, LParam);
end;

{//---------------------------------------------------------------------------
// Model struct
//---------------------------------------------------------------------------
// Define the control model (using the event and property structures).
//---------------------------------------------------------------------------}
const
ModelDefCtlName: 	array[0..8] of Char = 'DiskTool'#0; 		{ default control name prefix}
ModelClassName:		array[0..15] of Char = 'ThunderDiskTool'#0;{ Visual Basic class name}
ModelParentClassName:	array[0..8] of Char = #0;	{ Parent window class if subclassed}
ModelFmtTool: TMODEL = (
	usVersion:		VB_VERSION;					{ VB version used by control}
	fl:             {Model_fInvisAtRun or }Model_fInitMsg or Model_fLoadMsg;	{ Bitfield structure}
	ctlproc:		TFarProc(@CtlProc);			{ The control proc.}
	fsClassStyle:	cs_VRedraw or cs_HRedraw;	{ window class style}
	flWndStyle:		WS_Child or WS_Border;	 	{ default window style}
	cbCtlExtra:		sizeof(tdTool);			{ # bytes alloc'd for HCTL structure}
	idBmpPalette:	UpTool;						{ BITMAP id for tool palette}
	DefCtlName: 	tOffset(@ModelDefCtlName); 	{ default control name prefix}
	ClassName:		tOffset(@ModelClassName);	{ Visual Basic class name}
	ParentClassName:	0{tOffset(@ModelParentClassName)};		{ Parent window class if subclassed}
	proplist:		ofs(PropertyList);				{ Property list}
	eventlist:		0{ofs(EventList)}; 				{ Event list}
	nDefProp: 		0{ord(IPROP_Circ1_BackColor)};	{ index of default property}
	nDefEvent:		0{ord(Event_Circ1_ClickIn)};	{ index of default event}
	nValueProp:		0{ord(IPROP_Circ1_Shape)}		{ default value }
);

function LicenseProc(Wnd: HWnd; iMsg: word; WParam: Word; LParam: LongInt):boolean; export;
var
   Rect:    tRect;
   rectDesk:      tRect;
   xSize, ySize:  integer;
   xDeskSize, yDeskSize:  integer;
   x, y:      integer;
begin
     case iMsg of
          WM_INITDIALOG: begin
              GetWindowRect(Wnd, Rect);
              GetWindowRect(GetDeskTopWindow, rectDesk);
              xSize := rect.right - rect.left;
              ySize := rect.bottom - rect.top;
              xDeskSize := rectDesk.right - rectDesk.left;
              yDeskSize := rectDesk.bottom - rectDesk.top;
              x := (xDeskSize - xSize) div 2;
              y := (yDeskSize - ySize) div 2;
              MoveWindow(Wnd, x, y, xSize, ySize, FALSE);
          end;

          WM_COMMAND:
               case wParam of
	            IDOK:      EndDialog(Wnd, 0);
               end;
     end;
     LicenseProc := true;
end;

{//---------------------------------------------------------------------------
// Register custom control.
//	This routine is called by VB when the custom control DLL is
//	loaded for use.
//---------------------------------------------------------------------------}
function VBINITCC(usVersion: Word; fRunTime: Boolean): Boolean; export;
var
     demoText: string;
     demoCaption: string;
	bmp:	tBitMap;
    ParentHWnd:     HWnd;
begin
     inc(cVBXUsers);
     tBMap := 0;
     tBmap := LoadBitMap(hInstance, MakeIntResource(UpTool));
     if (tBMap = 0) then begin
        VBINITCC := false;
	exit;
     end;
     GetObject(tBMap, sizeOf(bmp), @bmp);
     bmWidth := bmp.bmWidth;
     bmHeight := bmp.bmHeight;
     bDevTimeInit := true;
     VBINITCC := VBRegisterModel(hInstance, ModelFmtTool);
end;

procedure VBTERMCC; export;
begin
     if shutdown then exit;
     if cVBXUsers >= 0 then
        dec(cVBXUsers);
     if (tBMap <> 0) and (cVBXUsers = 0) and (bDevTimeInit) then begin
        DeleteObject(tBMap);
	shutdown := true;
     end;
end;

exports
       VBINITCC index 1,
       CtlProc index 2,
       VBTERMCC index 3;

begin
	Prop_PathLen.OffsetData := Ofs(tdTool(ptr(0,0)^).usPathLen);
	Prop_PathStr.OffsetData := Ofs(tdTool(ptr(0,0)^).hszPathString);
	Prop_DriveLtr.OffsetData := Ofs(tdTool(ptr(0,0)^).hszDrive);
	Prop_DiskType.OffsetData := Ofs(tdTool(ptr(0,0)^).hszDiskType);
	Prop_Volume.OffsetData := Ofs(tdTool(ptr(0,0)^).hszVolume);
	Prop_FileSize.OffsetData := Ofs(tdTool(ptr(0,0)^).ulSize);
	Prop_Date.OffsetData := Ofs(tdTool(ptr(0,0)^).hszDate);
	Prop_Time.OffsetData := Ofs(tdTool(ptr(0,0)^).hszTime);
	Prop_BPC.OffsetData := Ofs(tdTool(ptr(0,0)^).ulBytesPerCluster);
	Prop_DC.OffsetData := Ofs(tdTool(ptr(0,0)^).ulDiskCapacity);
	Prop_FS.OffsetData := Ofs(tdTool(ptr(0,0)^).ulFreeSpace);
	Prop_CA.OffsetData := Ofs(tdTool(ptr(0,0)^).usClustersAvail);
	Prop_TC.OffsetData := Ofs(tdTool(ptr(0,0)^).usTotalClusters);
	Prop_BPS.OffsetData := Ofs(tdTool(ptr(0,0)^).usBytesPerSector);
	Prop_SPC.OffsetData := Ofs(tdTool(ptr(0,0)^).usSectorsPerCluster);
	Property_Action.OffsetData := Ofs(tdTool(ptr(0,0)^).usAction);
end.
