unit Bwinproc;
{
    Sample SendKeys for Delphi 1.x

    Written by Jochen Weichel.
    Date 2.96
}

interface


procedure SendKeys(const AStr: string);


implementation

uses
    WinTypes, WinProcs, Forms;


{ --- Begin SendKeys -------------------------------------------------------------------------- }

{ Misc. functions required by SendKeys }
procedure Keybd_Event; far; external 'USER';
procedure PostVirtualKeyEvent(VirtKey: byte; IsUp: boolean);
var
    AXReg: word;
    BXReg: word;
begin
    BXReg := MapVirtualKey(VirtKey, 0); { Map virtual keycode to scancode }
    if IsUp then
        AXReg := VirtKey or ($80 shl 8) { Set push- or release-button flag }
    else
        AXReg := VirtKey;

    asm
        mov bx, BXReg;  { Place parameters into registers, not on stack. }
        mov ax, AXReg;
    end;
    Keybd_Event; { Generate key event }
end;

procedure SendKeys(const AStr: string);
var
    runner : integer;
    curchar: char;
    IsShift: boolean;
begin
    runner := 1;
    while runner <= length(AStr) do
    begin
        curchar := AStr[runner];

        IsShift := ('A' <= curchar) and (curchar <= 'Z');
        curchar := upcase(curchar);

        if IsShift then
            PostVirtualKeyEvent(VK_SHIFT, false);

        PostVirtualKeyEvent(ord(curchar), false);
        PostVirtualKeyEvent(ord(curchar), true);

        if IsShift then
            PostVirtualKeyEvent(VK_SHIFT, true);

        Application.ProcessMessages;
        inc(runner);
    end
end;


{ Referenc : Microsoft System Journal 7/8 1992;
             Jeffrey Richter
  Comment  : Only the simple implementation done. The problem in this implementation
             is the missing result from PostVirtualKeyEvent. So you can't be sure if your
             key event reaches destination or not.
             The other way described in the mentioned reference uses a JournalHook. This way
             is more complicated and requires the usage of a dll.
             There is one other drawback of SendKeys coming from the nature of windows.
             It always requires, that the window receiving the send key's has the focus.
}
{ --- End SendKeys ---------------------------------------------------------------------------- }

end.
