unit Ineval;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, InFix, StdCtrls;

type
  TfrmCalculator = class(TForm)
    edtExpression: TEdit;
    btn3: TButton;
    lblResult: TLabel;
    btn1: TButton;
    btn4: TButton;
    btn7: TButton;
    btn2: TButton;
    btn5: TButton;
    btn8: TButton;
    btn9: TButton;
    btn6: TButton;
    btn0: TButton;
    btnDecimal: TButton;
    btnEquals: TButton;
    btnDivide: TButton;
    btnMultiply: TButton;
    btnMinus: TButton;
    btnPlus: TButton;
    lblProductDescription: TLabel;
    lblProductName: TLabel;
    btnExampleA: TButton;
    btnClear: TButton;
    btnExampleB: TButton;
    btnLeftBracket: TButton;
    btnRightBracket: TButton;
    procedure btnExampleAClick(Sender: TObject);
    procedure btn1Click(Sender: TObject);
    procedure btnEqualsClick(Sender: TObject);
    procedure btnClearClick(Sender: TObject);
    procedure btnExampleBClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmCalculator: TfrmCalculator;

procedure addChar(Sender: TObject);
procedure EvaluateExp(Const MyExpr : string);

implementation

{$R *.DFM}

procedure addChar(Sender: TObject);
var
	btn : TButton;
begin
	btn := TButton(Sender);
	frmCalculator.edtExpression.Text := frmCalculator.edtExpression.Text + btn.Caption;
end;

procedure EvaluateExp(Const MyExpr : string);
var
	MyErr	: Byte;
  MyAddr : String[20];
  MyResult : Real;
begin
	MyErr := 0;
  MyResult := 0.0;
  InFix.RawCalculate(MyExpr, MyResult, MyErr);
  frmCalculator.lblResult.Caption := '= ' + FloatToStr(MyResult);
end;

procedure TfrmCalculator.btn1Click(Sender: TObject);
begin
	addChar(Sender);
end;

procedure TfrmCalculator.btnEqualsClick(Sender: TObject);
begin
	EvaluateExp(edtExpression.Text);
end;

procedure TfrmCalculator.btnClearClick(Sender: TObject);
begin
	frmCalculator.edtExpression.Clear;
	frmCalculator.lblResult.Caption := '';
end;

procedure TfrmCalculator.btnExampleAClick(Sender: TObject);
begin
	frmCalculator.edtExpression.Text := '((10*10)-50)/10';
	EvaluateExp(frmCalculator.edtExpression.Text);
end;

procedure TfrmCalculator.btnExampleBClick(Sender: TObject);
begin
	frmCalculator.edtExpression.Text := '(10*10)/3';
	EvaluateExp(frmCalculator.edtExpression.Text);
end;

end.
