unit Dateset1;

{Takes a selection of files and changes the dates and time to NOW,
 TE Smith RR#1 Millarville, Alberta, CANADA
 CIS 71232,3643, Phone 403 931 3550,
 October 15, 1995

 This program requires ExtFile, it is found in the enclosed
 extfile.zip, please install EXTFILE before compiling this program.

 Credit for the very useful EXTFILE goes to:
   Enrico Lodolo
   via F.Bolognese 27/3
   40129 Bologna
   Italy

   CompuServe: 100275,1255
   Internet: ldlc18k1@bo.nettuno.it
}
interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, FileCtrl, Buttons, ExtCtrls, About, ExtFile;

type
  TDateSetform = class(TForm)
    Memo1: TMemo;
    LogGroupBox: TGroupBox;
    FileSelectionBox: TGroupBox;
    FilesDirectoryListBox: TDirectoryListBox;
    FilesDriveComboBox: TDriveComboBox;
    ExtFileListBox: TExtFileListBox;
    SaveDialog1: TSaveDialog;
    Button1: TButton;
    InfoButton: TButton;
    SaveLogButton: TButton;
    ClearAllButton: TButton;
    SelectAllButton: TButton;
    ChangeDateButton: TButton;
    procedure ChangeDateButtonClick(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure SelectAllButtonClick(Sender: TObject);
    procedure ClearAllButtonClick(Sender: TObject);
    procedure SaveLogButtonClick(Sender: TObject);
    procedure InfoButtonClick(Sender: TObject);

  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  DateSetform: TDateSetform;
  RunNumber : integer;
implementation

{$R *.DFM}

procedure TDateSetform.FormCreate(Sender: TObject);
begin
  {show welcome message}
  Memo1.lines.add (' Welcome to the File Date Set Tool');
  Memo1.lines.add
  (' This tool will Set the Date of the selected File(s) to the Current Date & Time');
  Memo1.Lines.add (' Program started on DATE: '+ DateToStr(Date) +
  ', at TIME: ' + TimetoStr(Time) );
  Memo1.Lines.Add('');
  RunNumber := 0;
end;

procedure TDateSetform.ChangeDateButtonClick(Sender: TObject);
VAR
 SubjectFileHandle : word;
 i : integer;

BEGIN
  RunNumber := RunNumber + 1;
 WITH ExtFileListBox DO
  BEGIN
    Memo1.Lines.add (' ****** This is run number ' + IntToStr(RunNumber) +
      ' ******');
   FOR i := 0 TO Items.Count - 1 DO
     IF Selected[i]
     THEN
     BEGIN
      SubjectFileHandle := FileOpen(Items[i], fmOutput);{open subject file}
      FileSetDate(SubjectFileHandle, DateTimeToFileDate(Date + Time));{set file date}

      {write new date and time to memo}
      Memo1.Lines.add (  ' File: '+ Items[i] +
        ' is now dated: ' +
        DateToStr(FileDateToDateTime(FileGetDate(SubjectFileHandle)))+
        ', and Time is: ' +
        TimeToStr(FileDateToDateTime(FileGetDate(SubjectFileHandle)))  );

      FileClose(SubjectFileHandle); {close subject file}
     END;
  END;
  Memo1.Lines.add ('');

  {update display}
  ExtFileListBox.update;
  FilesDriveComboBox.refresh;
  FilesDirectoryListBox.Refresh;
  ExtFileListBox.Refresh;
END;

procedure TDateSetform.ExitButtonClick(Sender: TObject);
begin
  Close;
end;

procedure TDateSetform.SelectAllButtonClick(Sender: TObject);
VAR
 i : integer;
BEGIN
  WITH ExtFileListBox DO
    BEGIN
      FOR i := 0 TO Items.Count - 1 DO
         Selected[i] := True;
    END;
END;

procedure TDateSetform.ClearAllButtonClick(Sender: TObject);
VAR
 i : integer;
BEGIN
  WITH ExtFileListBox DO
    BEGIN
       FOR i := 0 TO Items.Count - 1 DO
         Selected[i] := False;
    END;
END;

procedure TDateSetform.SaveLogButtonClick(Sender: TObject);
begin
   WITH SaveDialog1 DO
     IF Execute THEN
     BEGIN
       Memo1.Lines.SaveToFile(FileName);
       Caption :=
          'File Date Set;   Active Log File: ' + ExtractFileName(FileName);
       Memo1.Lines.add (' Log File: ' +  ExtractFileName(FileName));

       {update display}
       ExtFileListBox.update;
       FilesDriveComboBox.refresh;
       FilesDirectoryListBox.Refresh;
       ExtFileListBox.Refresh;
     END;
end;

procedure TDateSetform.InfoButtonClick(Sender: TObject);
begin
   aboutbox.showmodal;
end;

end.

