{------------------------------------------------------------------------------
*
* module:			dB3Tabl1.PAS
* description:	demo from for TUZTable component
* OVL-level:
* neccessary:		DELPHI 1.0, DBTABLUZ MUST be installed to your DCL
* target OS:		WIN16
*
*------------------------------------------------------------------------------
* last upd.!	by	  	! reason
*------------------------------------------------------------------------------
* 04/05/95	! 	UZ		! design
*------------------------------------------------------------------------------
*
* contents:
* 	name						meaning/description
* -----------------------------------------------------------------------------
*
*		Form1 TForm				demo form
*
*------------------------------------------------------------------------------}
{$define  __DB3TABL1_PAS}										{ register ourself }
unit dB3Tabl1;

{---------------------------------------------------------------------------
*	Defines
*---------------------------------------------------------------------------}

{===========================================================================
* 									INTERFACE
*===========================================================================}
interface

{---------------------------------------------------------------------------
*	USES
*---------------------------------------------------------------------------}
uses
	SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
	Forms, Dialogs, Buttons, ExtCtrls, Grids, DBGrids, DB, DBTables, DBTablUZ;

{---------------------------------------------------------------------------
*	TYPES/CLASSSES
*---------------------------------------------------------------------------}
type
	TForm1 = class(TForm)
	  UZTable1: TUZTable;
	  DataSource1: TDataSource;
	  DBGrid1: TDBGrid;
	  Panel1: TPanel;
	  BtnGenerateIndex: TSpeedButton;
	  BtnActivateIndex: TSpeedButton;
	  BtnDeActivateIndex: TSpeedButton;
	  BtnExit: TSpeedButton;
	  UZTable1TESTA: TStringField;
	  UZTable1TESTN: TFloatField;
	  procedure BtnGenerateIndexClick(Sender: TObject);
	  procedure BtnActivateIndexClick(Sender: TObject);
	  procedure BtnDeActivateIndexClick(Sender: TObject);
	  procedure BtnExitClick(Sender: TObject);
	  procedure FormCreate(Sender: TObject);

	  {---------------------------------------------------------------------------
	  *	NON DELPHI
	  *---------------------------------------------------------------------------}
	  procedure RefreshButtons;

	{---------------------------------------------------------------------------
	*	PRIVATEs:
	*---------------------------------------------------------------------------}
	private

	{---------------------------------------------------------------------------
	*	PROTECTED members:
	*---------------------------------------------------------------------------}
	protected

	{---------------------------------------------------------------------------
	*	PUBLICs:
	*---------------------------------------------------------------------------}
	public

	{---------------------------------------------------------------------------
	*	PUBLISHEDs:
	*---------------------------------------------------------------------------}
	published

end;

{---------------------------------------------------------------------------
*	Consts
*---------------------------------------------------------------------------}
const
	sIndexFile: string	='DBIII.NDX';							{ index filename }
	sIndexFlds: string   ='TESTA';								{ indexed fields }

{---------------------------------------------------------------------------
*	Vars/Globals
*---------------------------------------------------------------------------}
var
	Form1: TForm1;

{---------------------------------------------------------------------------
*	Prototyping/Forward-Declarations
*---------------------------------------------------------------------------}

{===========================================================================
* 									IMPLEMENTATION
*===========================================================================}
implementation

{---------------------------------------------------------------------------
*	Include of Form
*---------------------------------------------------------------------------}
{$R *.DFM}

{-----------------------------------------------------------------------------
*
* BtnGenerateIndexClick:	generates the dBASEIII+ index file on table
*									dbIII.DBF
*
*-----------------------------------------------------------------------------
* Input:
* 	name				type						meaning
*
* Output:
*
*-----------------------------------------------------------------------------}
procedure TForm1.BtnGenerateIndexClick(Sender: TObject);
begin
	UZTable1.IndexName := '';										{ close eventually open index }
	UZTable1.AddIndex(sIndexFile,sIndexFlds,[]);				{ generate indexfile }
	RefreshButtons;													{ set buttons to proper state }
end;
{-------------------------- EOP BtnGenerateIndexClick ------------------------}

{-----------------------------------------------------------------------------
*
* BtnActivateIndexClick: activates the index
*
*-----------------------------------------------------------------------------
* Input:
* 	name				type						meaning
*
*
* Output:
*
*-----------------------------------------------------------------------------}
procedure TForm1.BtnActivateIndexClick(Sender: TObject);
begin
	UZTable1.IndexName := sIndexFile;							{ set index file to be active index }
	RefreshButtons;													{ reset buttons }
end;
{-------------------------- EOP BtnActivateIndexClick ------------------------}

{-----------------------------------------------------------------------------
*
* BtnDeActivateIndexClick: deactivates the index
*
*-----------------------------------------------------------------------------
* Input:
* 	name				type						meaning
*
*
* Output:
*
*-----------------------------------------------------------------------------}
procedure TForm1.BtnDeActivateIndexClick(Sender: TObject);
begin
	UZTable1.IndexName := '';										{ close index }
	RefreshButtons;													{ reset buttons }
end;
{-------------------------- EOP BtnDeActivateIndexClick ----------------------}

{-----------------------------------------------------------------------------
*
* BtnExitClick: exit
*
*-----------------------------------------------------------------------------
* Input:
* 	name				type						meaning
*
*
* Output:
*
*-----------------------------------------------------------------------------}
procedure TForm1.BtnExitClick(Sender: TObject);
begin
	Application.terminate;
end;
{-------------------------- EOP BtnExitClick ---------------------------------}

{-----------------------------------------------------------------------------
*
* FormCreate: called when form is generated, set initial bitton states
*
*-----------------------------------------------------------------------------
* Input:
* 	name				type						meaning
*
*
* Output:
*
*-----------------------------------------------------------------------------}
procedure TForm1.FormCreate(Sender: TObject);
begin
	RefreshButtons;													{ just set buttons }
end;
{-------------------------- EOP FormCreate -----------------------------------}

{-----------------------------------------------------------------------------
*
* RefreshButtons: sets all button states
*						 called when form is generated or whenever a button
*						 which may affect button states is clicked
*
*-----------------------------------------------------------------------------
* Input:
* 	name				type						meaning
*
*
* Output:
*
*-----------------------------------------------------------------------------}
procedure TForm1.RefreshButtons;
var
	tSrchRec:	TSearchRec;
begin
	if FindFirst(sIndexFile,faAnyFile,tSrchRec) >= 0 then begin		{ indexfile present ?}
		BtnGenerateIndex.Enabled := false;									{ disable generate button }
		BtnActivateIndex.Enabled := (UZTable1.Indexname = '');      { reset activate button}
		BtnDeActivateIndex.Enabled := NOT (UZTable1.Indexname = '');{ reset deactivate button }
	end else begin																	{ ! indexfile NOT present }
		BtnGenerateIndex.Enabled := true;									{ enable generate button }
		BtnActivateIndex.Enabled := false;									{ disable activate button}
		BtnDeActivateIndex.Enabled := false;								{ disable activate button}
	end;																				{ ? indexfile present }
end;
{-------------------------- EOP FormCreate -----------------------------------}


end.
{************************** EOF dB3Tabl1.PAS *********************************}
