unit Udemo;

interface

{ Hello !!
  This demo shows you how to use the DBREADON.DCU unit.
  I've tested with Paradox tables 3.5, 4 and 5 formats.
  This works by changing the table directly, so in the future
  there's no warranty that it will work.
  However, 5.0 Paradox table format stills compatible with 3.5 format.

  The unit has 3 interfaced functions:

    Function IsDBReadOnly(Const TableName:String):Boolean;
    Procedure SetDBReadOnly(Const TableName:String);
    Procedure SetDBReadWrite(Const TableName:String);

  Use try...exception / finally to catch possible errors like
  (table not found, cannot open table, isn't Paradox Table, etc).

  Enjoy and send me any comments.
  David Berneda. 100115,1155@compuserve.com

  DISCLAIMER:
  No Warranties.
  No Liability for Consequential Damages.
  FreeWare unit.
}
uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Buttons, Grids, DBGrids, DB, DBTables, StdCtrls, Balloon;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    Label1: TLabel;
    Button1: TButton;
    Label2: TLabel;
    Label3: TLabel;
    Table1: TTable;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure Edit1Exit(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Edit1KeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
    { Public declarations }
    Procedure CheckParadoxTable;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
Uses DBReadOn; { this is the unit !!! }

Procedure TForm1.CheckParadoxTable;
Begin
  Button1.Enabled:=True;
  Table1.Close;
  try
    { CHECK IF PARADOX TABLE IS READ ONLY }
    if IsDBReadOnly(Edit1.Text) then
    Begin
       Label3.Caption:='Read Only';
       Button1.Caption:='Make Read/Write';
       Table1.ReadOnly:=True;
    end
    else
    begin
       Label3.Caption:='Read/Write';
       Button1.Caption:='Make Read Only';
       Table1.ReadOnly:=False;
    end;
    { OPEN AGAIN THE PARADOX TABLE }
    Table1.Open;
  except
    on E:Exception do
    Begin
       Label3.Caption:=E.Message;
       Button1.Caption:='';
       Button1.Enabled:=False;
    End;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  CheckParadoxTable;
end;

procedure TForm1.Edit1Exit(Sender: TObject);
begin
  CheckParadoxTable;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Table1.Close;
  try
    if IsDBReadOnly(Edit1.Text) then
       SetDBReadWrite(Edit1.Text) { CHANGE FROM READ ONLY TO READ/WRITE }
    else
       SetDBReadOnly(Edit1.Text); { CHANGE FROM READ/WRITE TO READ ONLY }
  finally
    CheckParadoxTable;
  end;
end;

procedure TForm1.Edit1KeyPress(Sender: TObject; var Key: Char);
begin
  if Key=#13 then Edit1Exit(Self);
end;

end.
