unit Main1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Menus;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    Label1: TLabel;
    Label2: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Button1: TButton;
    OpenDialog1: TOpenDialog;
    Button2: TButton;
    Button3: TButton;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Documentation1: TMenuItem;
    N1: TMenuItem;
    About2: TMenuItem;
    procedure Button1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Label1Click(Sender: TObject);
    procedure Label2Click(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Documentation1Click(Sender: TObject);
    procedure About2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  fsize:longint;

implementation

uses about1, message1;

{ Load include file for library declarations }
{$I compress.inc}

{$R *.DFM}

{ Get a file's size in bytes }
function GetSize(filename:string):longint;
var f:file;
begin
{$I-}
     assign(f,filename);
     reset(f,1);
     GetSize:=filesize(f);
     close(f);
{$I+}
end;



procedure TForm1.Button1Click(Sender: TObject);
var filename:string;
begin
     OpenDialog1.Filter :=
      'Text Files|*.DOC;*.TXT;*.ASC|Executables' +
      '|*.EXE;*.COM|Compressed Files|*.CMP|All Files|*.*|';

     if (OpenDialog1.Execute) then
     begin
          filename:=OpenDialog1.Filename;
          edit1.text:=filename;
     end;
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
     halt(0);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
     form1.top:=screen.height div 4;
     form1.left:=screen.width div 4;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
     halt(0);
end;

procedure TForm1.Label1Click(Sender: TObject);
begin
     edit1.setfocus;
end;

procedure TForm1.Label2Click(Sender: TObject);
begin
     edit2.setfocus;
end;

procedure TForm1.Edit1Change(Sender: TObject);
var s:string;
begin
     s:=edit1.text;

     fsize:=getsize(s);
     form1.label4.caption:='Size: '+inttostr(fsize);

     if (pos('.',s)<>0) then
        s:=copy(s,1,pos('.',s)-1);

     if (IsCompressed(edit1.text)) then
        edit2.text:=ExtractFilePath(edit1.text)+GetFilename(edit1.text)
     else
         edit2.text:=s+'.cmp';

     form1.label5.caption:='Size: N/A';
end;

procedure TForm1.Button2Click(Sender: TObject);
var err:word;
    fp:file;
begin
     message.label1.caption:='Compressing File ...';
     message.top:=form1.top+50;
     message.left:=form1.left+25;

     form1.hide;
     message.show;
     application.processmessages;

     err:=compressfile(edit1.text,edit2.text,true);

     message.hide;
     form1.show;

     form1.label5.caption:='Size: '+inttostr(getsize(edit2.text));

     if (err=0) then
     begin
          { Is the target file BIGGER than the source?  If so it couldn't be compressed }
          if (getsize(edit1.text)<getsize(edit2.text)) then
          begin
               form1.label3.caption:='Message: File could not be compressed.';
               assignfile(fp,edit2.text);
               erase(fp);
          end
          else { Tell the user the percentage of saved space }
              form1.label3.caption:='Message: File compressed by '+
                                    inttostr(100*(getsize(edit1.text)-getsize(edit2.text)) div getsize(edit1.text))+'%';
     end
     else if (err<256) then
             form1.label3.caption:='Message: Disk Error while compressing file (#'+inttostr(err)+')'
          else
          begin
               case err of
                    256: form1.label3.caption:='Message: Integrity failure in source file.';
                    257: form1.label3.caption:='Message: Error, Source file does not exist.';
                    258: form1.label3.caption:='Message: Error, Source file is not compressed.';
                    259: form1.label3.caption:='Message: Error, Source file is already compressed.';
               end;
          end;
end;

procedure TForm1.Button3Click(Sender: TObject);
var err:word;
begin
     message.label1.caption:='Uncompressing File ...';
     message.top:=form1.top+50;
     message.left:=form1.left+25;

     form1.hide;
     message.show;
     application.processmessages;

     err:=uncompressfile(edit1.text,edit2.text,true);

     message.hide;
     form1.show;

     form1.label5.caption:='Size: '+inttostr(getsize(edit2.text));

     if (err=0) then
        form1.label3.caption:='Message: File successfully uncompressed.'
     else if (err<256) then
             form1.label3.caption:='Message: Disk Error while uncompressing file (#'+inttostr(err)+')'
          else
          begin
               case err of
                    256: form1.label3.caption:='Message: Integrity failure in source file.';
                    257: form1.label3.caption:='Message: Error, Source file does not exist.';
                    258: form1.label3.caption:='Message: Error, Source file is not compressed.';
                    259: form1.label3.caption:='Message: Error, Source file is already compressed.';
               end;
          end;
end;

procedure TForm1.Documentation1Click(Sender: TObject);
begin
     winhelp(application.handle, 'compress.hlp'#0, HELP_Contents, 0);
end;

procedure TForm1.About2Click(Sender: TObject);
begin
     aboutbox.showmodal;
end;

end.
