unit Ddeform;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, StdCtrls, DdeMan,
  Dialogs;

{ DDEDemo - This demo establishes a DDE conversation with the Program
  Manager, and creates a program group by executing the CreateGroup
  macro. The difficulties normally associated with DDE conversions
  (such as timeouts, etc) are automatically handled by the
  TDDEClient object. }

type
  TForm1 = class(TForm)
    Label1: TLabel;
    GroupName: TEdit;
    Label2: TLabel;
    CreateButton: TButton;
    Button2: TButton;
    DDEClient: TDdeClientConv;
    Label3: TLabel;
    ItemName: TEdit;
    Button1: TButton;
    CmdLine: TEdit;
    WorkDir: TEdit;
    Label4: TLabel;
    Label5: TLabel;
    Button3: TButton;
    OpenDialog: TOpenDialog;
    procedure Button2Click(Sender: TObject);
    procedure CreateButtonClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses  SysUtils;

procedure TForm1.Button2Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.CreateButtonClick(Sender: TObject);
var
  Name: string;
  Macro: string;
  Cmd: array[0..255] of Char;
begin
  if GroupName.Text = '' then
    MessageDlg('Group name can not be blank.', mtError, [mbOK], 0)
  else
  begin
    Name := GroupName.Text;
    Macro := Format('[CreateGroup(%s)]', [Name]) + #13#10;
    StrPCopy (Cmd, Macro);
    DDEClient.OpenLink;
    if not DDEClient.ExecuteMacro(Cmd, False) then
      MessageDlg('Unable to create group.', mtInformation, [mbOK], 0);
{    DDEClient.CloseLink;}
    GroupName.SelectAll;
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  item,command,dir: string;
  Macro: string;
  Cmd: array[0..255] of Char;
begin
{  if GroupName.Text = '' then
    MessageDlg('Group name can not be blank.', mtError, [mbOK], 0)
  else}
  begin
    item := ItemName.text;
    command := CmdLine.text;
    dir := WorkDir.Text;

    Macro := Format('[AddItem(%s,%s)]', [command,item,dir]) + #13#10;
    StrPCopy (Cmd, Macro);
    DDEClient.OpenLink;
    if not DDEClient.ExecuteMacro(Cmd, False) then
      MessageDlg('Unable to create item.', mtInformation, [mbOK], 0);
{    DDEClient.CloseLink;}
    GroupName.SelectAll;
  end;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  if OpenDialog.execute then
    cmdLine.text:=OpenDialog.fileName;
end;

end.

