unit Ddrvcnst;

interface

{ ---------------------------------
     DLL Declarations
-----------------------------------}
 Function rvInit(   hParent :Integer;    {Handle of the calling (parent) window}
                    Title :PChar;        {the title of the report}
                    JustShow,            {if non-zero, ddrv will preview the
                                         print-out, otherwise it will print
                                         directly to the printer.
                                         Use constants:
                                             rv_justprint or rv_showfirst}
                    UnitOfMeas,          {Determines if your parameters are
                                         passed in cm or inches. Use constants:
                                             rv_cm or rv_inch}
                    Options :Integer)    {bitwise options
                                         Use constants:
                                             rv_portrait or rv_landscape,
                                             rv_zoomXXX, rv_magnify,
                                             rv_printselect}
                    : Integer;           {doesn't return anything ... yet}


 Procedure rvViewerPos (
                    x, y,                {Initial screen Left and Top Positions
                                         passed in pixels}
                    w, h,                {Initial screen Width and Height
                                         passed in pixels}
                    ShowCtl :Integer);   {set to either rv_ctlbox (show the
                                         viewer's control box) or rv_noctlbox
                                         (don't show the viewer's control box)}


 Procedure rvButtonCaption (
                    Which   :Integer;    {Which button are we talking about
                                         Use constants:
                                             rv_btn_exit, rv_btn_prev, etc.}
                    Caption :PChar);     {The new caption}


 Procedure rvButtons (
                    w, h        :Integer;{The width and height of the button
                                         graphic in pixels}
                    GraphicFile :PChar); {The filename containing the alternate
                                         button graphics. (SEE ALT_TOOL.BMP
                                         to see the layout of the graphic file)
                                         The bitmap must contain graphics side-
                                         by-side for seven buttons:
                                           #1 - picture for Exit button
                                           #2 - Prev button in enabled state
                                           #3 - Prev button in disabled state
                                           #4 - Next button in enabled state
                                           #5 - Next button in disabled state
                                           #6 - Print button
                                           #7 - Choose printer button.}


 Procedure rvNewPage;                   {Call this to start a new page}

 Procedure rvEndDoc;                    {This function ends the document and
                                        starts the viewer screen (or prints
                                        if rvInit passed rv_justprint)}

 Procedure rvText ( x, y    :Single;    {The x,y coordinate to locate the text}
                    align   :Integer;   {How to align the text about the given
                                        coordinate: use rv_left, rv_right,
                                        rv_center, rv_decimal}
                    TheText :PChar);    {The text to print-out}


 Procedure rvLine ( x1, y1,             {The coordinates at which to start
                                        the line (in inches or cm)}
                    x2, y2,             {The end coordinates of the line}
                    p :Single);         {The thickness of the lines in points}


 Procedure rvRect ( x1, y1,             {Coordinates of the upper-left corner
                                        of the rectangle (in inches or cm)}
                    x2, y2,             {Lower-left corner of rectangle}
                    p :Single;          {The thickness of the border in points}
                    s :Integer);        {Fill style - either
                                          rv_clearback or rv_greyback}

 Procedure rvGraphic (
                    FileName :PChar;    {Full path and filename of the graphic}
                    x1, y1, x2, y2      {DDRV will stretch the graphic to fit
                                        in the rectangle defined by these points
                                        given in inches or cm}
                    :Single);


 Procedure rvFontName (
                    FontName :PChar);   {Sets the current print font to be
                                        FontName}

 Procedure rvFontSize (
                    FontSize :Integer); {Sets the size of the font in points}


 Procedure rvFontStyle (
                    FontStyle :Integer);{Sets the current font style based
                                        on the bit-wise parameter:
                                          e.g.
                                              rvFontStyle( rv_fontbold Or
                                                           rv_fontitalic)
                                        }

{ ---------------------------------
     THE CONSTANTS
-----------------------------------}
  CONST

{ -- Font control -- }
{ ------------------
  NOTE: These are bitwise and used by rvFontStyle
}
       rv_fontnormal    = 0;
       rv_fontbold      = 1;
       rv_fontitalic    = 2;
       rv_fontunderline = 4;
       rv_fontstrikeout = 8;


{ -- Text Alignment -- }
{ --------------------
  NOTE: Used by rvText
}
       rv_left          = 0;
       rv_center        = 1;
       rv_right         = 2;
       rv_decimal       = 3;


{ -- Options -- }
{ -------------------------
  NOTE: Bitwise used by rvInit in the Options Parameter
}
       rv_portrait      = 0;
       rv_landscape     = 1;
       rv_magnify       = 2;
       rv_printselect   = 4;
       rv_zoom100       = 0;
       rv_zoom75        = 8;
       rv_zoom50        = 16;
       rv_zoomFit       = 32;


{ -- Rectangle Style -- }
{ ---------------------
  NOTE: Used by rvRect
}
       rv_clearback     = 0;
       rv_greyback      = 1;


{ -- Units of Measure -- }
{ ----------------------
  NOTE: Used by rvInit
}
       rv_inch          = 0;
       rv_cm            = 1;


{ -- Print control -- }
{ -------------------
  NOTE: Used by rvInit
}
       rv_justprint     = 0;
       rv_viewfirst     = 1;


{ -- Window State -- }
{ ---------------------
  NOTE: Used by rvViewPos in the X parameter
}
       rv_maximize      = -1;
       rv_minimize      = -2;


{ -- Control box -- }
{ ---------------------
  NOTE: Used by rvViewPos
}
       rv_noctlbox      = 0;
       rv_ctlbox        = 1;


{ -- Button indicators -- }
{ ---------------------
  NOTE: Used by rvButtonCaption in the Which parameter
}
       rv_btn_exit            = 0;
       rv_btn_prev            = 1;
       rv_btn_next            = 2;
       rv_btn_print           = 3;
       rv_btn_chooseprinter   = 4;
       rv_cbo_zoom            = 5;


implementation


{ -- Function declarations with descriptions --}

 Function rvInit(   hParent :Integer;
                    Title :PChar;
                    JustShow,
                    UnitOfMeas,
                    Options :Integer) :Integer;
                    external 'ddrv';

 Procedure rvViewerPos (
                    x, y,
                    w, h,
                    ShowCtl :Integer);
                    external 'ddrv';

 Procedure rvButtonCaption (
                    Which   :Integer;
                    Caption :PChar);
                    external 'ddrv';

 Procedure rvButtons (
                    w, h        :Integer;
                    GraphicFile :PChar);
                    external 'ddrv';

 Procedure rvNewPage; external 'ddrv';

 Procedure rvEndDoc; external 'ddrv';

 Procedure rvText ( x, y    :Single;
                    align   :Integer;
                    TheText :PChar);
                    external 'ddrv';

 Procedure rvLine ( x1, y1,
                    x2, y2,
                    p :Single);
                    external 'ddrv';

 Procedure rvRect ( x1, y1,
                    x2, y2,
                    p :Single;
                    s :Integer);
                    external 'ddrv';

 Procedure rvGraphic (
                    FileName :PChar;
                    x1, y1, x2, y2
                    :Single);
                    external 'ddrv';

 Procedure rvFontName (
                    FontName :PChar);
                    external 'ddrv';

 Procedure rvFontSize (
                    FontSize :Integer);
                    external 'ddrv';

 Procedure rvFontStyle (
                    FontStyle :Integer);
                    external 'ddrv';
end.
