// SRPDEBUG for VBXs


/***************************************************************************/
/***************************************************************************/
/*******                 DEBUG/TRACE FACILITY                       ********/
/***************************************************************************/
/***************************************************************************/

#define DB(a) a
#define D()
#include <dos.h>
#include <stdarg.h>

#define UWRD unsigned int 
#define UCHR unsigned char 
#define BASEFUNC

static UWRD VSEG = 0xFFFF;
static UWRD MonoOn = 1;						// Sw from env vbl to activate
extern UWRD GETSEL(void);

/*-------------------------------------
 * Display on MonoMonitor
 *
 * To enable the TSR to 'share' the same 
 * screen we always look for the previous
 * prompt, apart from the first time
 * when we assume we are dealing with
 * a new screen.
 */
void D()DebDsp(char *str) 
{
static int ftsw = 0;
int col, ii;
UWRD far *up;
UCHR far *vp;

if(VSEG == 0xFFFF){
	if (MonoOn == 0)							// Harmless state if no DBMON=* or P
		return;
	VSEG = GETSEL();
	if (VSEG == 0xFFFF)
		return;
}

if (ftsw == 0) {
	ftsw = 1;
	for(vp = MK_FP(VSEG,0); *vp != '' && FP_OFF(vp) < 25*80*2;vp+=2*80){
	}
	if (FP_OFF(vp) >= 25*80*2){
		up = MK_FP(VSEG,0);
		for(ii=0; ii<=25*80; ii++)
			*up++ = 0x07FA;
	}
}

for(vp = MK_FP(VSEG,0); *vp != '' && FP_OFF(vp) < 25*80*2;vp+=2*80){
}
if (FP_OFF(vp) >= 25*80*2){
	vp = MK_FP(VSEG,0);
}
up = (UWRD far *)vp;

col = 0;
for(col=0; col<70; col++){					/* ----- display our trap message---*/
	if(*str)
		*up++ = 0x7000 + *str++;
	else
		*up++ = 0x7000 + ' ';
	if(col >69)
		break;
}
if (FP_OFF(vp) == 24*80*2)
	vp = MK_FP(VSEG,0);
else
	vp += 2*80;
up = (UWRD far *)vp;
for(col=0; col<70; col++){					// Add ptr line to show current
	*up++ = 0x0700 + ((col<10)?'':' ');
}
}



/*-------------- For debug show given status on alt screen ----------------*/
void D()debstat(int row,char *bf)
{
#define COLs  70
UCHR *vp = MK_FP(VSEG,row*160 + 2*COLs);
int ii = 80 - COLs;

if(VSEG == 0xFFFF){
	if (MonoOn == 0)							// Harmless state if no DBMON=* or P
		return;
	VSEG = GETSEL();
	if (VSEG == 0xFFFF)
		return;
}

while(ii-- > 0) {
	if (*bf)
		*vp++ = *bf++;
	else
		*vp++ = ' ';
	*vp++ = 0x07;
}
}

/*-------------------------------------
 * Debugging aid.
 */
void BASEFUNC D()Z(char *str,...)
{
char bf[200];
va_list argptr;
UWRD n;
va_start(argptr,str);
vsprintf(bf,str,argptr);
if (*bf == '!') {
	n = (*(bf+1) & 0x0f)*10 + (*(bf+2) & 0x0f);
	if (n > 24) n = 24;
	debstat(n,bf+3);
	return;
}
DebDsp(bf);
}

/*-------------------------------------
 *htoa: hex -> asci (char -> char(2))
 */
char *htoa(UCHR val)
{
char static ans[2];
int i;
char static vals[17] = "0123456789ABCDEF";
i = val & 0x00f0;
i = i >> 4;
ans[0] = vals[i];
i = val & 0x000f;
ans[1] = vals[i];
return(&ans[0]);
}

/*-------------------------------------
 * Memory dump.
 */
void D()MemDump(FILE *f,char *buf,UWRD len)
{
 char *bufp;
 int ii,jj;
 char x1;
 char c1;
 char aadr[99];
 char *p1,*p2,*htoa(),*pstop;
 char static blnk[2] = {' ',' '};

pstop = &buf[len+1];

for(ii = 0; ii<79; ii++) {
   aadr[ii] = ' ';
}

for(ii = 0;ii<len;ii = ii+16) {
   x1 = ii;p1 = htoa(x1); 
   aadr[2] = *p1; aadr[3] = *(p1+1);
   x1 = ii>>8;p1 = htoa(x1); 
   aadr[0] = *p1; aadr[1] = *(p1+1);
   bufp = &buf[ii];
   p2 = &aadr[5];
   for(jj = 0;jj<16;jj++) {
      if ((jj % 4) == 0)
          p2++;
      if (FP_OFF(bufp) < FP_OFF(pstop))
          p1 = htoa(*bufp);
      else
          p1 = blnk;
      *p2 = *p1; p2++; *p2 = *(p1+1); p2++;
      bufp++;
   } 
   bufp = &buf[ii];
   p2 = p2 + 3;
   for(jj = 0;jj<16;jj++) {
       if (FP_OFF(bufp) >= FP_OFF(pstop)){
          c1 = ' ';
		 }else{
          c1 = *bufp & 0x7f;
          if ((c1 < ' ') || (c1 > 0x7e)) 
             c1 = '.';
		 }
       *p2 = c1; p2++;
       bufp++;
   } 
   aadr[60] = 0x00;
	fprintf(f,"%s\n",aadr);
} 
}

