unit Scrn;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls,Ver, Buttons;

type
  TResTestApp = class(TForm)
    Label1: TLabel;
    StrRes: TEdit;
    Label2: TLabel;
    Panel1: TPanel;
    Icon: TImage;
    Label3: TLabel;
    Panel2: TPanel;
    Bmp: TImage;
    Label4: TLabel;
    FVer: TEdit;
    PVer: TEdit;
    CoName: TEdit;
    FileDesc: TEdit;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    FilVers: TEdit;
    IntName: TEdit;
    Label8: TLabel;
    Label9: TLabel;
    CName: TEdit;
    Label10: TLabel;
    Label11: TLabel;
    OrgName: TEdit;
    Ok: TBitBtn;
    Label12: TLabel;
    FmtStr: TEdit;
    Label13: TLabel;
    FmtRes: TEdit;
    Panel3: TPanel;
    Label14: TLabel;
    Curs: TImage;
    Label15: TLabel;
    UserDef: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure OkClick(Sender: TObject);
  private
    Loading : Boolean;
    Procedure ReadVerInfo;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ResTestApp: TResTestApp;

implementation

{$R *.DFM}

Uses
  Res__Ids;

Procedure TResTestApp.ReadVerInfo;                         { Read Version Information }
Var
  VSize     : LongInt;                                     { Size of the Version Block }
  Vhandle   : Longint;                                     { Version Handle }
  Vinfo     : PChar;                                       { Char Pointer }
  Vitem     : Pointer;                                     { Item Pointer }
  Rc        : Boolean;                                     { Result Code }
  NtFn      : array [0..255] of Char;                      { Ascii Buffer }
  LenRes    : Word;                                        { Resource Length }
  Ne , L    : Integer;                                     { Local Loopers }
  LangCode  : LongInt;                                     { Langauge Code }
  Lang,Code : Word;                                        { Language and Charset }
  Xlate     : String;                                      { String for Translation }
  FFi       : PVS_FixedFileInfo;                           { Ver Info structure }
begin
  StrPCopy(NtFn,Application.ExeName);                      { Get the ExeName }
  Vitem := @NtFn;                                          { Set Pointer to char buffer }
  VSize := GetFileVersionInfoSize(NtFn,Vhandle);           { Get Version Size }
  if VSize = 0 then Exit;                                  { If None, then Exit }
  GetMem(Vinfo,Word(VSize));                               { Grab some Memory }
  Rc := GetFileVersionInfo(NtFn,
                     Vhandle,
                     VSize,
                     Vinfo);                               { Get the Version Block }
  if Not Rc then begin                                     { If We Failed }
    FreeMem(Vinfo,VSize);                                  { Free the memory }
    Exit;                                                  { Get out of here }
    end;
  Rc := VerQueryValue(Vinfo,
                      '\',
                      Vitem,
                      LenRes);                             { Get First Val }
  FFi := Vitem;                                            { Set Struncture }
  FVer.Text := IntToStr(HIWORD(FFi^.dwFileVersionMS)) +
               '.' +
               IntToStr(LOWORD(FFi^.dwFileVersionMS)) +
               '.' +
               IntToStr(HIWORD(FFi^.dwFileVersionLS)) +
               '.' +
               IntToStr(LOWORD(FFi^.dwFileVersionLS));     { Get File Version }

  PVer.Text := IntToStr(HIWORD(FFi^.dwProductVersionMS)) +
               '.' +
               IntToStr(LOWORD(FFi^.dwProductVersionMS)) +
               '.' +
               IntToStr(HIWORD(FFi^.dwProductVersionLS)) +
               '.' +
               IntToStr(LOWORD(FFi^.dwProductVersionLS));  { Get Product Version }

  Rc := VerQueryValue(Vinfo,
                      StrPCopy(NtFn,'\VarFileInfo\Translation'),
                      Vitem,
                      LenRes);                             { Get Trans Block }

  if Rc then begin                                         { If we got it }
    Ne := LenRes Div 4;                                    { Set Reader }
    For L := 1 to ne do begin                              { Lets read the TX block }
      Lang := LOWORD(LongInt(Vitem^));                     { Get the Languag Code }
      Code := HIWORD(LongInt(Vitem^));                     { Get the Char Set Code }
      if Lang = $409 then break;                           { If Got It then stop it }
      end;
    end
  else begin                                               { Set Default }
    Lang := $409;                                          { Set }
    Code := 0;                                             { Set }
    end;
 Xlate := '\StringFileInfo\' + IntToHex(Lang,4) +
                               IntToHex(Code,4) + '\';     { Set Xlate String }

  Rc := VerQueryValue(Vinfo,
                      StrPcopy(NtFn,Xlate + 'CompanyName'),
                      Vitem,
                      LenRes);                             { Get Company Stuff }
  CoName.Text := StrPas(Vitem);                            { Set }

  Rc := VerQueryValue(Vinfo,
                      StrPcopy(NtFn,Xlate + 'FileDescription'),
                      Vitem,
                      LenRes);                             { Get file description }
  FileDesc.Text := StrPas(Vitem);                          { Set }

  Rc := VerQueryValue(Vinfo,
                      StrPcopy(NtFn,Xlate + 'FileVersion'),
                      Vitem,
                      LenRes);                             { Get File Version }
  FilVers.Text := StrPas(Vitem);                           { Set }

  Rc := VerQueryValue(Vinfo,
                      StrPcopy(NtFn,Xlate + 'InternalName'),
                      Vitem,
                      LenRes);                             { Get Internal Name }
  IntName.Text := StrPas(Vitem);                           { Set }

  Rc := VerQueryValue(Vinfo,
                      StrPcopy(NtFn,Xlate + 'LegalCopyRight'),
                      Vitem,
                      LenRes);                             { Get CopyRight }
  CName.Text := StrPas(Vitem);                             { Set }

  Rc := VerQueryValue(Vinfo,
                      StrPcopy(NtFn,Xlate + 'OriginalFileName'),
                      Vitem,
                      LenRes);                             { Get Org File Name }
  OrgName.Text := StrPas(Vitem);                           { Set }

  FreeMem(Vinfo,Vsize);                                    { Free Mem }
end;

procedure TResTestApp.FormCreate(Sender: TObject);
begin
  Loading := True;                                         { Loading }
end;

procedure TResTestApp.FormActivate(Sender: TObject);
Var
  Bitmap  : TBitmap;
  Ico     : TIcon;
  Dh      : THandle;
  Sp      : PChar;
  Fr      : THandle;
begin
  If Loading then Begin                                    { If Loading then ... }
    Loading := False;                                      { Reset Flag }
    StrRes.Text := LoadStr(IDS_TEST_STRING);               { Get a String }
    FmtStr.Text := LoadStr(IDS_TEST_FMT_STRING);           { Get A format String }
    FmtRes.Text := FmtLoadStr(IDS_TEST_FMT_STRING,
                          ['Hello','World',1,2,3]);        { Demo Format }
    Bitmap := TBitmap.Create;                              { Init Bitmap }
    Ico := TIcon.Create;                                   { Init Icon }
    Ico.Handle := LoadIcon(HInstance,
                        MakeIntResource(IDI_TEST_ICON));   { Load the Icon }
    Bitmap.Handle := LoadBitmap(HInstance,
                        MakeIntResource(IDB_TEST_BITMAP)); { Load the Bitmap }
    Bmp.Picture.Graphic := Bitmap;                         { Set }
    Icon.Picture.Graphic := Ico;                           { Set }
    Ico.Free;                                              { Bye Bye Icon }
    Bitmap.Free;                                           { Bye Bye Bitmap }
    Ico := TIcon.Create;                                   { Init Icon }
    Ico.Handle := LoadCursor(HInstance,
                        MakeIntResource(IDC_HELP));        { Load the Cursor }
    Screen.Cursors[15] := Ico.Handle;
    Curs.Picture.Graphic := Ico;                           { Set }
    Curs.Cursor := 15;
    Ico.Free;                                              { Bye Bye Icon }
    ReadVerInfo;                                           { Read the Version Info }
    Dh := LoadResource(HInstance,
            FindResource(HInstance,
                         PChar(MakeLong(IDD_DATA,0)),
                         RT_RCDATA));                      { Get a Handle to the Resource }
    UserDef.Text := StrPas(LockResource(Dh));              { Lock it, get a pointer and load it }
    FreeResource(Dh);                                      { Free It }
    end;
end;

procedure TResTestApp.OkClick(Sender: TObject);
begin
  Close;                                                   { Goodbye Cruel World }
end;

end.
