{ Form Template - Source and Destination Choices Lists }
unit Dirselct;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, FileCtrl;

type
  TDirSelectDlg = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    HelpBtn: TBitBtn;
    DestList: TListBox;
    SrcLabel: TLabel;
    DstLabel: TLabel;
    IncludeBtn: TSpeedButton;
    ExcludeBtn: TSpeedButton;
    ExAllBtn: TSpeedButton;
    DirList: TDirectoryListBox;
    DriveComboBox1: TDriveComboBox;
    procedure IncludeBtnClick(Sender: TObject);
    procedure ExcludeBtnClick(Sender: TObject);
    procedure ExcAllBtnClick(Sender: TObject);
    procedure RemoveSelected(List: TCustomListBox);
    procedure MoveSelected(List: TDirectoryListBox; DestList: TCustomListBox);
    procedure SetItem(List: TListBox; Index: Integer);
    function GetFirstSelection(List: TCustomListBox): Integer;
    procedure SetButtons;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  DirSelectDlg: TDirSelectDlg;

implementation

{$R *.DFM}

procedure TDirSelectDlg.IncludeBtnClick(Sender: TObject);
var
  Index: Integer;
begin
  Index := GetFirstSelection(DirList);
  MoveSelected(DirList,DestList);
  SetButtons;
end;

procedure TDirSelectDlg.ExcludeBtnClick(Sender: TObject);
var
  Index: Integer;
begin
  Index := GetFirstSelection(DestList);
  RemoveSelected(DestList);
  SetItem(DestList, Index);
end;

procedure TDirSelectDlg.ExcAllBtnClick(Sender: TObject);
begin
  DestList.Items.Clear;
  SetItem(DestList, 0);
end;

procedure TDirSelectDlg.RemoveSelected(List: TCustomListBox);
var
  I: Integer;
begin
  for I := List.Items.Count - 1 downto 0 do
    if List.Selected[I] then
    begin
       List.Items.Delete(I);
    end;
end;

procedure TDirSelectDlg.MoveSelected(List: TDirectoryListBox; DestList: TCustomListBox);
var
  I: Integer;
begin
  for I := List.Items.Count - 1 downto 0 do
    if List.Selected[I] then
    begin
       if DestList.Items.IndexOf(List.GetItemPath(I)) = -1 then
              DestList.Items.Add(List.GetItemPath(I));
    end;
end;

procedure TDirSelectDlg.SetButtons;
var
  SrcEmpty, DstEmpty: Boolean;
begin
  DstEmpty := DestList.Items.Count = 0;
  IncludeBtn.Enabled := True;
  ExcludeBtn.Enabled := not DstEmpty;
  ExAllBtn.Enabled := not DstEmpty;
end;

function TDirSelectDlg.GetFirstSelection(List: TCustomListBox): Integer;
begin
  for Result := 0 to List.Items.Count - 1 do
    if List.Selected[Result] then Exit;
  Result := LB_ERR;
end;

procedure TDirSelectDlg.SetItem(List: TListBox; Index: Integer);
var
  MaxIndex: Integer;
begin
  with List do
  begin
    SetFocus;
    MaxIndex := List.Items.Count - 1;
    if Index = LB_ERR then Index := 0
    else if Index > MaxIndex then Index := MaxIndex;
    Selected[Index] := True;
  end;
  SetButtons;
end;


end.
