
{$E+,N+}
program disp3d;
uses dos,crt,graph,lad3d,mouse,DataDef,fdata,wrmode,palette,lpunit,graf;

const UpArrow = char(72+128);
      DnArrow = char(80+128);
      LeftArrow = char(75+128);
      RightArrow = char(77+128);
      PgUp = char(73+128);
      PgDn = char(81+128);
      InsKey = char(82);
      DelKey = char(83);

const Change : boolean = true;
const DoPixels : boolean = true;
const RedBlue : boolean = true;

{++++++++++++++++++++++++++++++++++++++}
{test stuf}

type  RectangleType = record x1,y1,x2,y2:word; end;
var   mb : array[0..29] of RectangleType;
      Bret : boolean;
      xr,yr,zr:float;
      MouseRepeat : boolean;
      Mclk,ClkMask,MouseTime : word;
      SysClock : word absolute $40:$6c;
      RefX,RefY,RefZ : float;
      PcX,PcY,PcZ : float;

type string20 = string[20];
function fstr(D:float):string20;
var s:string20;
begin
  if d >= 100 then
    str(D:1:0,s)
  else if D >= 10 then
    str(D:1:1,s)
  else if D >= 1 then
    str(D:1:2,s)
  else
    str(D:1:4,s);
  fstr := s;
end;
function Lstr(l:longint):string;
var s : string;
begin
  str(l,s);
  Lstr := s;
end;


{------------------------------------------------}

procedure LoadFileList;
var i:word;
begin
  for i := 2 to ParamCount do
  begin
    if DataFileCount >= MaxDataFile then
    begin
      writeln('Error: too many data files (',DataFileCount,')');
      halt(1);
    end;
    DataFileName[DataFileCount] := Paramstr(i);
    inc(DataFileCount);
  end;
end;

procedure LoadData;
var i,Dim,Index:word;
begin
  for i := 0 to pred(DataFileCount) do
  begin
    if not ReadFile(DataFileName[i],Dim,Index) then
    begin
      writeln('Error reading file: ',DataFilename[i],' Line:',Index,' Dim:',Dim);
      halt(1);
    end;
  end;
end;


{===========================================}

procedure DrawMouseControls;
type string12 = string[12];

  function strL(L:word; d:float):string12;
  var s:string12;
  begin
    str(round(d),s);
    while length(s) < L do
    begin
      inc(s[0]);
      s[length(s)] := ' ';
    end;
    strL := s;
  end;

  function DrawMbBox(Index,X,Y:word; s:string12):word;
  begin
    with mb[Index] do
    begin
      x1 := x;
      y1 := y;
      x2 := x+textwidth(s)+10;
      y2 := y+textheight(s)+3;
      setcolor(255);
      rectangle(x1,y1,x2,y2);
      outtextxy(x+2,y,s);
      DrawMbBox := x2;
    end;
  end;

var t:word;
    s:string;
begin
  HideMouse;
  SetTextStyle(MyFont,0,4);
  setfillstyle(solidfill,black);
  bar(0,0,GetMaxX,10);
  T := DrawMbBox(0,   1,0,'X: '+strl(4,LadRoot.Xa));
  T := DrawMbBox(1,T+8,0,'Y: '+strl(4,LadRoot.Ya));
  T := DrawMbBox(2,T+8,0,'Z: '+strl(4,LadRoot.Za));
 { T := DrawMbBox(3,T+8,0,'P: '+strl(4,Pcz)); }
  s := 'Xs:'+fstr(GetMaxX+1)+' Ys:'+fstr(GetMaxY+1);
  outtextxy(getMaxX-TextWidth(s)-8,0,s);
  ShowMouse;
end;


procedure Line3D(x1,y1,z1,x2,y2,z2:integer);
var LX1,LX2,LY1,LY2,LZ1,LZ2:integer;
begin
  LadRoot.transform(x1,y1,z1,LX1,LY1,LZ1);
  LadRoot.transform(x2,y2,z2,LX2,LY2,LZ2);
  with LadRoot,Start do
    line(X+Lx1,Y+Ly1,X+Lx2,Y+Ly2);
end;

procedure Draw3Dbox;
var X1,X2,Y1,Y2,Z1,Z2:integer;
begin
  setcolor(255);
  line3D(PlotXmin-1,PlotYmin-1,PlotZmin-1,
         PlotXmax+1,PlotYmin-1,PlotZmin-1);
  line3D(PlotXmin-1,PlotYmin-1,PlotZmin-1,
         PlotXmin-1,PlotYmax+1,PlotZmin-1);

  setcolor(254);
  line3D(PlotXmin-1,PlotYmin-1,PlotZmin-1,
         PlotXmin-1,PlotYmin-1,PlotZmax+1);


  line3D(PlotXmin-1,PlotYmin-1,PlotZmax+1,
         PlotXmin-1,PlotYmax+1,PlotZmax+1);
  line3D(PlotXmin-1,PlotYmax+1,PlotZmax+1,
         PlotXmin-1,PlotYmax+1,PlotZmin-1);

  line3D(PlotXmin-1,PlotYmin-1,PlotZmax+1,
         PlotXmax+1,PlotYmin-1,PlotZmax+1);
  line3D(PlotXmax+1,PlotYmin-1,PlotZmax+1,
         PlotXmax+1,PlotYmin-1,PlotZmin-1);

  setcolor(255);
  line3D(PlotXmax+1,PlotYmin-1,PlotZmin-1,
         PlotXmax+1,PlotYmax+1,PlotZmin-1);
  line3D(PlotXmax+1,PlotYmax+1,PlotZmin-1,
         PlotXmin-1,PlotYmax+1,PlotZmin-1);
end;

procedure Mark3Dbox;
var x1,y1,z1:integer;
var LX1,LY1,LZ1:integer;
    sb,se:float;
begin
  setcolor(255);
  SetTextStyle(MyFont,0,4);
  if (xtype = 0) or (xtype = 1) then
    begin sb := Xstart; se := Xend; end
    else begin se := Xstart; sb := Xend; end;

  x1 := PlotXmin;
  y1 := PlotYmax+textwidth('X');
  z1 := PlotZmin;
  LadRoot.transform(x1,y1,z1,LX1,LY1,LZ1);
  with LadRoot,Start do
    outtextxy(x+LX1,y+LY1,fstr(sb));
  x1 := PlotXmax-(textheight('X')*2);
  y1 := PlotYmax+textwidth('X');
  z1 := PlotZmin;
  LadRoot.transform(x1,y1,z1,LX1,LY1,LZ1);
  with LadRoot,Start do
    outtextxy(x+LX1,y+LY1,fstr(se));


  if (ytype = 0) or (ytype = 1) then
    begin sb := Ystart; se := Yend; end
    else begin se := Ystart; sb := Yend; end;
  x1 := PlotXmax+(textheight('X'));
  y1 := PlotYmin;
  z1 := PlotZmin;
  LadRoot.transform(x1,y1,z1,LX1,LY1,LZ1);
  with LadRoot,Start do
    outtextxy(x+LX1,y+LY1,fstr(sb));

  x1 := PlotXmax+(textheight('X'));
  y1 := PlotYmax-(textwidth(fstr(se)));
  z1 := PlotZmin;
  LadRoot.transform(x1,y1,z1,LX1,LY1,LZ1);
  with LadRoot,Start do
    outtextxy(x+LX1,y+LY1,fstr(se));


  if (ztype = 0) or (ztype = 1) then
    begin sb := Zstart; se := Zend; end
    else begin se := Zstart; sb := Zend; end;
  x1 := PlotXmin;
  y1 := PlotYmax+textwidth('X');
  z1 := PlotZmin+(textheight('X')*2);
  LadRoot.transform(x1,y1,z1,LX1,LY1,LZ1);
  with LadRoot,Start do
    outtextxy(x+LX1,y+LY1,fstr(sb));

  x1 := PlotXmin;
  y1 := PlotYmax+textwidth('X');
  z1 := PlotZmax;
  LadRoot.transform(x1,y1,z1,LX1,LY1,LZ1);
  with LadRoot,Start do
    outtextxy(x+LX1,y+LY1,fstr(se));
end;

procedure drawdata;
var Bi:word;
    Zt,Xt,Yt:float;
    Xi,Yi,Zi:integer;
begin
  setcolor(255);
  LadRoot.InitTransform;
  LadRoot.xrot(xr);  {init starting angles}
  LadRoot.yrot(yr);
  LadRoot.zrot(zr);
  LadRoot.Setref(RefX,RefY,RefZ);
{  LadRoot.Setpc(PcX,PcY,PcZ); }

{  LadRoot.Setref(GxMin+((GxMax-GxMin+1)/2),
                 GyMin+((GyMax-GyMin+1)/2),
                 GzMin+((GzMax-GzMin+1)/2));}

  HideMouse;
  cleardevice;
  Draw3DBox;
  Mark3Dbox;

  for Bi := 0 to pred(PlotXsize) do
  begin
    Xt := PlotX^[Bi];
    Yt := PlotY^[Bi];
    Zt := PlotZ^[Bi];
    LadRoot.transform(Xt,Yt,Zt,Xi,Yi,Zi);
    Xi := LadRoot.Start.X+Xi;
    Yi := LadRoot.Start.Y+Yi;
    PutPixel(Xi,Yi,{PlotZ^[Bi]} round((GxSize+PlotZ^[Bi])*(253 / (GxSize*2))) );
  end;
  putpixel(LadRoot.Start.X, LadRoot.Start.Y,255);
  ShowMouse;

  DrawMouseControls;
end;

function MouseInMb(Index,X,Y:word):boolean;
begin
  with mb[Index] do
    MouseInMb := (X >= x1) and (X <= x2) and
                 (Y >= Y1) and (Y <= y2);
end;


{
procedure mouseoff;
var regs : registers;
begin
  regs.ax := 0;
   regs.bx := 0;
  intr($33,regs);
end;
}

procedure TweakAngle(Rev:boolean; Tweak:word; var R:float);
begin
   if Rev then
   begin
     r := r + Tweak;
     if r >= 360 then r := 0;
   end
   else
   begin
     r := r - Tweak;
     if r < 0 then r := 360-Tweak;
   end;
end;

procedure TweakNum(Rev:boolean; Tweak:word; var R:float);
begin
   if Rev then
     r := r + Tweak
   else
     r := r - Tweak;
end;


var result,Mx,My : integer;
    i,gd,gm:integer;
    done:boolean;
    ch:char;
    ExitProc:pointer;


{-------------------------------------------------------------------}
begin
  ExitProc := @EndGraph;
  Pa := 10;

  if ParamCount < 1 then
  begin
    writeln('Format is: DISP3D ConfigFile [Datafile]');
    halt(1);
  end;
  LoadConfigFile(ParamStr(1));
  RefX := 0;
  RefY := 0;
  RefZ := 0;
  PcX := 0;
  PcY := 0;
  PcZ := 0;

  ClkMask := $fffc;
  MouseTime := 0;
  MouseRepeat := false;
  fillchar(DataFileName,sizeof(DataFileName),0);
  DataFileCount := 0;
{  ScreenSize := 200; }
  LoadFileList;
  LoadData;
  if not seok then
    ScreenSize := BufSize[0];
  StartGraph(ScreenSize);
  MyFont := LoadFont('LITT.CHR');
  SetTextStyle(MyFont,0,4);
  SetCustomPalette(true,253);
{  CustomBlendPalette(254); }

(*
  GxMin := 6*8; GyMin := 10; GzMin := 1;
  GxMax := GetMaxX-GxMin-10;
  GyMax := GetMaxY-GyMin-10;
  GzMax := {254} (GyMax-GyMin) div 4;
*)

  GxMin := round(GetMaxY / 3);
  GxMax := GxMin+(GxMin);
  GxSize := GxMax-GxMin;
  GyMin := GxMin;
  GyMax := GxMax;
  GySize := GyMax-GyMin;
  GzMin := 0;
  GzMax := GxMin div 2;
  GzSize := (GzMax-GzMin);


  Bx := 0;
  By := 1;
  Bz := 2;

  if not Xsok then
    Xstart := BufLim[Bx].Min;
  if not Xeok then
    Xend := BufLim[Bx].Max;
  if not Ysok then
    Ystart := BufLim[By].Min;
  if not Yeok then
    Yend := BufLim[By].Max;
  if not Zsok then
    Zstart := BufLim[Bz].Min;
  if not Zeok then
    Zend := BufLim[Bz].Max;

{restorecrtmode; }

  ConvertToScreenX(Bx,Xtype,Xstart,Xend,-(GxSize),GxSize);
  ConvertToScreenY(By,Ytype,Ystart,Yend,-(GySize),GySize);
  ConvertToScreenZ(Bz,Ztype,Zstart,Zend,-(GzSize),GzSize);

  xr := 190;   {starting angles}
  yr := 70;
  zr := 105;
  LadRoot.SetStart(GetMaxX div 2, GetMaxY div 2,0);

  cleardevice;
  setcolor(lightgray);

{  outtextxy(1,4,'X:'+fstr(GetMaxX)+' Y:'+fstr(GetMaxY)); }

  {$IFNDEF DPMI}
    UseSimMouse := true;
  {$ENDIF}
  initmouse;

  SetMousePosition(PutMx(50),PutMy(50));
  ShowMouse;

  done := false;
  while not done do
  begin


{    SetFillStyle(0,1); }
{    bar(0,0,GetMaxX,10);
    outtextxy(0,0,'xr:'+fstr(round(xr))+' yr:'+fstr(round(yr))+' zr:'+fstr(round(zr))); }


    if Change then
    begin
      drawdata;
      Change := false;
      Mclk := SysClock;
    end;

    if keypressed then
    begin
      ch := readkey;
      if ch = #0 then
        ch := char(ord(readkey)+128);

      case ch of
        'X' : TweakAngle(false,1,PcX);
        'x' : TweakAngle(true,1,PcX);
        'Y' : TweakAngle(false,1,PcY);
        'y' : TweakAngle(true,1,PcY);
        'Z' : Tweaknum(false,1,PcZ);
        'z' : Tweaknum(true,1,PcZ);
      end;
      case upcase(ch) of
        #$1b : Done := true;
        PgUp: TweakAngle(false,1,zr);
        PgDn: TweakAngle(true,1,zr);
        UpArrow: TweakAngle(false,1,xr);
        DnArrow: TweakAngle(true,1,xr);
        LeftArrow: TweakAngle(true,1,yr);
        RightArrow: TweakAngle(false,1,yr);
        'P': PrintScreen(0,200,true);
      end;
      Change := true;
    end;


    ReadMouse;
    if MouseButtons <> 0 then
    begin
      if Mclk <> SysClock then
      begin
        Mclk := SysClock;
        inc(MouseTime);
      end;
      if MouseTime > 7 then
        MouseRepeat := true
      else
        MouseRepeat := false;
    end
    else
    begin
      MouseTime := 0;
      MouseRepeat := false;
    end;

    if MouseClick or MouseRepeat then
    begin
      Mx := GetMx(MouseX);
      My := GetMy(MouseY);
      Bret := MouseButtons and 1 <> 0;

      if      MouseInMb(0,Mx,My) then {Xrot}
      begin
        TweakAngle(Bret,10,xr);
      end
      else if MouseInMb(1,Mx,My) then {Yrot}
      begin
        TweakAngle(Bret,10,yr);
      end
      else if MouseinMb(2,Mx,My) then {Zrot}
      begin
        TweakAngle(Bret,10,zr);
(*      end
      else if MouseinMb(3,Mx,My) then {Prot}
      begin
        Tweaknum(Bret,10,Pcz); *)
      end;
      Change := true;
    end;

  end;

  EndGraph;
end.

