unit Dispunit;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, VBXCtrl, Pict, StdCtrls, ExtCtrls, Spin, Read3d, Rot3D;

type
  TForm1 = class(TForm)
    DrawBox: TPaintBox;
    OpenFileDialog: TOpenDialog;
    OpenButton: TButton;
    CloseButton: TButton;
    XEdit: TSpinEdit;
    YEdit: TSpinEdit;
    ZEdit: TSpinEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Bevel1: TBevel;
    PointCheckBox: TCheckBox;
    WireCheckBox: TCheckBox;
    procedure OpenButtonClick(Sender: TObject);
    procedure CloseButtonClick(Sender: TObject);
    procedure XEditChange(Sender: TObject);
    procedure YEditChange(Sender: TObject);
    procedure ZEditChange(Sender: TObject);
    procedure WireCheckBoxClick(Sender: TObject);
    procedure PointCheckBoxClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  DataFileName : string[80];
  DataRot : RotObj;

const DrawPoints : boolean = false;
      DrawWires : boolean = true;
      NoData : boolean = true;

implementation

{$R *.DFM}

procedure ClearDrawBox;
begin
  Form1.DrawBox.Canvas.Pen.Color := clwhite;
  Form1.DrawBox.Canvas.Brush.Color := clblack;
  Form1.DrawBox.Canvas.Rectangle(0,0,
           Form1.DrawBox.Width,Form1.DrawBox.Height);
end;

procedure DrawIt;
var Q1,Q2,Q3,Q4,LX1,LX2,LY1,LY2,LZ1,LZ2:integer;
  procedure DrawDataPoints;
  var I : integer;
  begin
    for I := 0 to pred(DataItems) do
    begin
      DataRot.PointTransform(Xval^[I],Yval^[I],Zval^[I],LX1,LY1,LZ1);
      Form1.DrawBox.Canvas.Pixels[Lx1,Ly1] := clLime;
    end;
  end;

    procedure DrawPatch(I:integer);
    var K : integer;
    begin
      for K := 0 to BezierPatternItems-2 do
      begin
        Q1 := Patch^[I][BezierPattern^[K]]-1;
        Q2 := Patch^[I][BezierPattern^[K+1]]-1;
        DataRot.PointTransform(Xval^[Q1],Yval^[Q1],Zval^[Q1],LX1,LY1,LZ1);
        DataRot.PointTransform(Xval^[Q2],Yval^[Q2],Zval^[Q2],LX2,LY2,LZ2);
        Form1.DrawBox.Canvas.MoveTo(Lx1,Ly1);
        Form1.DrawBox.Canvas.LineTo(Lx2,Ly2);
      end;
    end;

  procedure DrawDataWires;
  var I:integer;
  begin
    I := 0;
    for I := 0 to PatchLines-1 do
      DrawPatch(I);
  end;

begin
  if NoData then Exit;
  DataRot.SetTransformMatrix(Xangle,Yangle,Zangle);
  ClearDrawBox;
  if DrawWires then
    DrawDataWires;
  if DrawPoints then
    DrawDataPoints;
end;

procedure TForm1.OpenButtonClick(Sender: TObject);
var W,H,D : word;
begin
  if OpenFileDialog.Execute then
  begin
    DataFilename := OpenFileDialog.FileName;
    DataFilename := copy(DataFilename,1,length(DataFilename)-4);
    if ReadConfig(DataFilename) then
    begin
      Xedit.Value := round(Xangle);
      Yedit.Value := round(Yangle);
      Zedit.Value := round(Zangle);
      W := Form1.DrawBox.Width;
      H := Form1.DrawBox.Height;
      D := Form1.DrawBox.Width;
      Form1.Caption := DataFileName;
      Form1.DrawBox.Canvas.Pen.Color := clwhite;
      Form1.DrawBox.Canvas.Brush.Color := clblack;
      Form1.DrawBox.Canvas.Rectangle(0,0,W,H);
      DataRot.SetDataConversion(Xstart,Ystart,Zstart,Xrange,Yrange,Zrange,
                                W div 2,H div 2,D div 2,W,H,D);
      if not ReadData(DataFilename) then
        NoData := true
      else if not ReadPatch(DataFilename) then
        NoData := true
      else
        NoData := false;
      DrawIt;
    end
    else
    begin
      Form1.Caption := Application.Title;
    end;
  end;

end;

procedure TForm1.CloseButtonClick(Sender: TObject);
begin
  Close;
end;

procedure TForm1.XEditChange(Sender: TObject);
begin
  Xangle := Xedit.Value;
  if Xedit.value >= 360 then Xedit.value := 0;
  if Xedit.value <= -1 then Xedit.value := 360-Xedit.increment;
  Drawit;
end;

procedure TForm1.YEditChange(Sender: TObject);
begin
  if Yedit.value >= 360 then Yedit.value := 0;
  if Yedit.value <= -1 then Yedit.value := 360-Yedit.increment;
  Yangle := Yedit.Value;
  Drawit;
end;

procedure TForm1.ZEditChange(Sender: TObject);
begin
  if Zedit.value >= 360 then Zedit.value := 0;
  if Zedit.value <= -1 then Zedit.value := 360-Zedit.increment;
  Zangle := Zedit.Value;
  Drawit;
end;

procedure TForm1.WireCheckBoxClick(Sender: TObject);
begin
  if Form1.WireCheckBox.State = cbChecked then
    DrawWires := true
  else
    DrawWires := false;
  Drawit;
end;

procedure TForm1.PointCheckBoxClick(Sender: TObject);
begin
  if Form1.PointCheckBox.State = cbChecked then
    DrawPoints := true
  else
    DrawPoints := false;
  Drawit;
end;

end.

