{Demo - DragDrop App.  Created by Harvey Orloff Synchro-Graphix Software
 if you have any comments or ways to improve this app.  please drop me
 an e-mail CIS 70610,724.   This program is for demonstration purposes
 only.}

{ HLO - 8/1/95 DragDrop example with Outline control.  Allow the user to
 Grab any level in the outline and drag and drop it to any other level}

unit Dragoutu;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Grids, Outline;

type
  TForm1 = class(TForm)
    Outline1: TOutline;
    procedure Outline1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Outline1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Outline1DragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure Outline1DragDrop(Sender, Source: TObject; X, Y: Integer);
	end;

var
  Form1: TForm1;

  {Variable bucket to hold source row for Drag Drop}
  DragSourceRow: Integer;
implementation

{$R *.DFM}

procedure TForm1.Outline1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  {Get the original row the user clicked on}
  DragSourceRow := Outline1.GetItem(X, Y);

end;

procedure TForm1.Outline1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin

	{check if the left mouse button is down and if drag mode is off}
	if (ssLeft in Shift) and (Outline1.Dragging = false) then
     {Turn on the drag drop.  the false below allows the mouse to move
      5 pixels in any direction before the cursor changes to a drag drop
      style cursor}
  	Outline1.BeginDrag(false);

end;

procedure TForm1.Outline1DragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
  {validate the user is dagging something and set drop acceptance for the
   outline control}
	if Outline1.Dragging then begin
  	Accept := True;

     {This line will highlight the outline item under the mouse pointer}
     Outline1.SelectedItem := Outline1.GetItem(X, Y);

  end;
end;

procedure TForm1.Outline1DragDrop(Sender, Source: TObject; X, Y: Integer);
begin
  {the user has ended the dragdrop operation move the source row to the
   destination and insert it there.}
	with Outline1.Items[DragSourceRow] do
  	MoveTo(Outline1.SelectedItem, oaInsert);

end;

end.
