unit Fireform;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Menus, ExtCtrls, NewWinG, About;


CONST {Image sizes (flames demo doesn't adapt too well, though)}
  ImageX = 320; {Must be a multiple of two}
  ImageY = 200; {ImageX x ImageY must not exceed 64K}
                {(Unless you want to write your own array access methods...
                  I _REALLY_ want a 32 bit Pascal :-))}

TYPE
  pScreen = ^TScreen; {Bitmap access table}
  TScreen = RECORD
    CASE Integer OF
      0 : (ptb : ARRAY[-(ImageY-1)..0, 0..ImageX-1] OF Byte);
          {ptb = byte coord [y, x]}
      1 : (ptw : ARRAY[-(ImageY-1)..0, 0..(ImageX DIV 2)-1] OF Word);
          {ptw = word coord [y, x div 2]}
      2 : (pta : ARRAY[0..(ImageY*ImageX)-1] OF Byte);
          {pta = byte array [(y*320)+x]}
  END; {REC TScreen}

  TImage = RECORD {DIB Information}
    bi       : TBitmapInfoHeader;
    aColors  : ARRAY[0..255] OF TRGBQUAD;
  END; {REC TImage}

  TPalette = RECORD {Palette Information}
    Version : Word;         {set to $0300 (Windows version 3.0)}
    NumberOfEntries : Word; {set to 256}
    aEntries : ARRAY[0..255] OF TPaletteEntry;
  END; {REC TPalette}

  TWingFireForm = class(TForm)
    FireBox: TPaintBox;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    About1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Timer1: TTimer;
    Screen1: TMenuItem;
    Hot1: TMenuItem;
    Cold1: TMenuItem;
    N2: TMenuItem;
    x21: TMenuItem;
    procedure Exit1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure Hot1Click(Sender: TObject);
    procedure Cold1Click(Sender: TObject);
    procedure FireBoxPaint(Sender: TObject);
    procedure x21Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
  private
    { Private declarations }
    LogicalPalette : TPalette; {Our palette initialization table}
    hPalApp     : hPalette; {Our palette}
    Image       : TImage;   {Our bitmap initialization table}
    hdcImage    : hDC;      {Our WinG DC}
    hOldBitmap  : hBitmap;  {Ye olde bitmap of the WinG DC must be restored}
    bmp         : pScreen;  {Assistant bitmap pointer}
    Orientation : Integer; {Indicates bitmap orientation,  1=top-down -1=bottom-up}
    Direction   : Integer; {Determines animation direction 1=Up       -1=Down}
    BigPicture  : Boolean;  { 640x400???}
    PROCEDURE SetDirection(NewDirection:Integer);
    PROCEDURE wmEraseBkGnd(VAR Msg:TWMEraseBkgnd);  Message wm_EraseBkGnd;
    PROCEDURE wmPaletteChanged(VAR Msg:TWMPaletteChanged);   Message wm_PaletteChanged;
    PROCEDURE wmQueryNewPalette(VAR Msg:TWMQueryNewPalette);  Message wm_QueryNewPalette;
  public
    { Public declarations }
  end;

var
  WingFireForm: TWingFireForm;

implementation

{$R *.DFM}

procedure TWingFireForm.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TWingFireForm.FormCreate(Sender: TObject);
var
  Desktop : hDC;
  i       : Integer;
begin
  InitWinG;
  hPalApp:=0;
  hdcImage:=0;
  hOldBitmap:=0;
  Orientation:=1;
  Direction:=1;

  BigPicture := False;
  WingFireForm.Width := 320;
  WingFireForm.Height := 230;
  FireBox.Top    := 0;
  FireBox.left   := 0;
  FireBox.Width  := 320;
  FireBox.Height := 200;

  {--------------------}
  FillChar(Image, SizeOf(Image), 0); {Better safe than sorry}

  {Ask WinG about the preferred bitmap format}
  IF WinGRecommendDIBFormat(pBitmapInfo(@Image.Bi))
  THEN BEGIN
    Image.Bi.biBitCount:=8;          {Force to 8 bits per pixel}
    Image.Bi.biCompression:=bi_RGB;  {Force to no compression}
    Orientation:=Image.bi.biHeight;  {Get height}
  END
  ELSE WITH Image.bi              {If WinG failed to initialize our image info}
  DO BEGIN                        {we'll do it ourselves}
    biSize:=SizeOf(Image.bi);
    biPlanes:=1;
    biBitCount:=8;
    biCompression:=bi_RGB;
    biSizeImage:=0;
    biClrUsed:=0;
    biClrImportant:=0;
    Orientation:=1;
  END;

  Image.bi.biWidth:=ImageX;       {Define the image sizes}
  Image.bi.biHeight:=ImageY * Orientation;
  image.bi.biSizeImage := (image.bi.biWidth * image.bi.biHeight);
  image.bi.biSizeImage := image.bi.biSizeImage*Orientation;

  Desktop:=GetDC(0); {Setup our palette init info and get the 20 system colors}
  LogicalPalette.Version:=$0300;
  LogicalPalette.NumberOfEntries:=256;
  GetSystemPaletteEntries(Desktop, 0, 10, LogicalPalette.aEntries);
  GetSystemPaletteEntries(Desktop, 246, 10, LogicalPalette.aEntries[246]);
  ReleaseDC(0, Desktop);

  FOR i:=0 TO 9  {Duplicate the system colors into the bitmap}
  DO BEGIN
    Image.aColors[i].rgbRed  :=LogicalPalette.aEntries[i].peRed;
    Image.aColors[i].rgbGreen:=LogicalPalette.aEntries[i].peGreen;
    Image.aColors[i].rgbBlue :=LogicalPalette.aEntries[i].peBlue;
    Image.aColors[i].rgbReserved:=0;
    LogicalPalette.aEntries[i].peFlags:=0;

    Image.aColors[i+246].rgbRed  :=LogicalPalette.aEntries[i].peRed;
    Image.aColors[i+246].rgbGreen:=LogicalPalette.aEntries[i].peGreen;
    Image.aColors[i+246].rgbBlue :=LogicalPalette.aEntries[i].peBlue;
    Image.aColors[i+246].rgbReserved:=0;
    LogicalPalette.aEntries[i+246].peFlags:=0;
  END;

  hdcImage:=WinGCreateDC;                                {Get our WinG DC}

  SetDirection(1);
  Timer1.Enabled := True;
end;

procedure TWingFireForm.FormDestroy(Sender: TObject);
var
  hbm : hBitmap;
begin
  IF Bool(hDCImage)                      {If we have a valid DC handle}
  THEN BEGIN
    hbm:=SelectObject(hdcImage, hOldBitmap); {Restore old bitmap}
    DeleteObject(hBM);                       {Delete our bitmap}
    DeleteDC(hdcImage);                      {Delete our DC}
  END;
  IF Bool(hPalApp)                       {If we have a valid palette handle}
  THEN DeleteObject(hPalApp);                {delete our palette}
  DeInitWinG;
end;

PROCEDURE TWingFireForm.SetDirection(NewDirection:Integer);
  PROCEDURE SetRgb(i,r,g,b:Byte);
  CONST
    c = 4; {Scale up the DOS colors to fit a 24-bit palette}
  BEGIN
    LogicalPalette.aEntries[i].peRed   := r*c;
    LogicalPalette.aEntries[i].peGreen := g*c;
    LogicalPalette.aEntries[i].peBlue  := b*c;
    Image.aColors[i].rgbRed  :=LogicalPalette.aEntries[i].peRed;
    Image.aColors[i].rgbGreen:=LogicalPalette.aEntries[i].peGreen;
    Image.aColors[i].rgbBlue :=LogicalPalette.aEntries[i].peBlue;
    Image.aColors[i].rgbReserved:=0;
    LogicalPalette.aEntries[i].peFlags:=PC_NOCOLLAPSE;
  END;
VAR
  i   : Integer;
  hbm : hBitmap; {Handle to our bitmap}
  mnu : hMenu;
BEGIN
  Direction:=NewDirection;
  IF Direction=1
  THEN BEGIN
    Caption := 'WinG + Pascal = Hot!';
    FOR i := 1 TO 32 {Build Black->Red->Yellow->White colors}
    DO BEGIN
     SetRgb(i, (i shl 1)-1, 0, 0 );
     SetRgb(i+32, 63, (i shl 1)-1, 0 );
     SetRgb(i+64, 63, 63, (i shl 1)-1 );
     SetRgb(i+96, 63, 63, 63 );
    END
  END
  ELSE BEGIN
    Caption := 'WinG + Pascal = Cool!';
    FOR i := 1 TO 32 {Build Black->Blue->Cyan->White colors}
    DO BEGIN
     SetRgb(i, 0, 0, (i shl 1)-1);
     SetRgb(i+32,  0, (i shl 1)-1, 63 );
     SetRgb(i+64, (i shl 1)-1, 63, 63 );
     SetRgb(i+96, 63, 63, 63 );
    END;
  END;


  IF Bool(hOldBitmap)
  THEN BEGIN
    DeleteObject(hPalApp);
    DeleteObject(SelectObject(hDCImage, hOldBitmap));
  END;
  hPalApp:=CreatePalette(pLogPalette(@LogicalPalette)^);
  hBM:=WinGCreateBitmap(hdcImage, pBitmapInfo(@Image.Bi), Pointer(bmp));

  hOldBitmap:=SelectObject(hdcImage, hBM); {Associate the bitmap with the DC}

  PatBlt(hDCImage, 0,0, ImageX, ImageY, BLACKNESS); {Paint the bitmap black}
  InvalidateRect(handle, nil, True);
END; {PROC TWinGWin.SetDirection}

PROCEDURE TWingFireForm.wmEraseBkGnd(VAR Msg:TWMEraseBkgnd);
BEGIN
  Longint(Msg.Result):= 1; {We don't want Windows to erase our background}
END; {FUNC TWinGWin.wmEraseBkGnd}

PROCEDURE TWingFireForm.wmPaletteChanged(VAR Msg:TWMPaletteChanged);
BEGIN                           {If some other Windows app has focus and changed}
  IF Msg.PalChg=handle         {the system colors, we'll update too so that we}
  THEN inherited;{wmQueryNewPalette(Msg);}  {can get the second best choices}
END; {PROC TWinGWin.wmPaletteChanged}

PROCEDURE TWingFireForm.wmQueryNewPalette(VAR Msg:TWMQueryNewPalette);
{ - Update palette and repaint if changed}
VAR
  DC : hDC;
  ReMappedColors:Word;
BEGIN
  IF Bool(hPalApp)
  THEN SelectPalette(Canvas.handle, hPalApp, False);
  ReMappedColors:=RealizePalette(Canvas.handle);
  IF (ReMappedColors > 0)
  THEN BEGIN
    InvalidateRect(handle, nil, True);
    Bool(Msg.Result):=True;
  END
  ELSE Bool(Msg.Result):=False;
END; {PROC TWinGWin.wmQueryNewPalette}

procedure TWingFireForm.Timer1Timer(Sender: TObject);
begin
  InvalidateRect(handle, nil, False); {Force a repaint}
end;

procedure TWingFireForm.Hot1Click(Sender: TObject);
begin
  SetDirection(1);
  Hot1.Checked  := True;
  Cold1.Checked := False;
end;

procedure TWingFireForm.Cold1Click(Sender: TObject);
begin
  SetDirection(-1);
  Hot1.Checked  := False;
  Cold1.Checked := True;
end;

procedure TWingFireForm.FireBoxPaint(Sender: TObject);
var
  x,y,
  x2,y2,c : Integer;
  one, two : Integer;
begin
  SelectPalette(Canvas.handle, hPalApp, False); {Select our palette}
  RealizePalette(Canvas.handle);                {and map it to the system palette}
  IF not Assigned(bmp)
  THEN Exit;
  WITH bmp^         {With our bitmap bits}
  DO BEGIN
    one:=1*Orientation*Direction;
    two:=2*Orientation*Direction;
    FOR x := 0 TO 159  {Update the flame bitmap}
    DO BEGIN
      x2:=x shl 1;
      FOR y := 30 TO 98
      DO BEGIN
        IF Orientation=Direction
        THEN y2:=-(y shl 1)
        ELSE y2:=-200+(y shl 1);
        c := (ptb[y2,x2]
            + ptb[y2,x2+2]
            + ptb[y2,x2-2]
            + ptb[y2-two,x2+2]) shr 2;
        IF c <> 0 THEN dec(c);
        ptw[y2+two, x] := Word(c or (c shl 8));
        ptw[y2+one, x] := Word(c or (c shl 8));
      END;
      ptb[y2,x2] := random(2)*160;
    END;
  END;
  If BigPicture then
    WinGStretchBlt(Canvas.handle, 0,0, 2*ImageX, 2*ImageY, hdcImage, 0,0, ImageX, ImageY)
   else
    WinGBitBlt(Canvas.handle, 0,0, ImageX, ImageY, hdcImage, 0,0);
end;

procedure TWingFireForm.x21Click(Sender: TObject);
begin
  If not BigPicture then begin
    BigPicture := true;
    WingFireForm.Width := 640;
    WingFireForm.Height := 435;
    FireBox.Width := 640;
    FireBox.Height := 400;
    x21.Caption := '&x1';
   end else begin
    BigPicture := False;
    WingFireForm.Width := 320;
    WingFireForm.Height := 235;
    FireBox.Width := 320;
    FireBox.Height := 200;
    x21.Caption := '&x2';
  end;
  Position := poScreenCenter;
end;

procedure TWingFireForm.About1Click(Sender: TObject);
begin
  AboutForm.Visible := True;
end;

end.
