unit Enhds;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DB, dbiprocs, dbitypes, dbierrs, dbtables;

type
  TEnhancedSource = class(TDataSource)
  private
    { Private declarations }

    function GetTableName: string;
    Function GetEofBof: string;
    Function GetFileAccess: string;
    Function GetFileState: string;
  protected
    Ftablename: string;
    FRowStatus: string;
    FEofBof: string;
    FFileAccess: string;
    FFileState: string;
    FRowNumber: longint;
    { Protected declarations }
  public

    function Getrownumber: longint;
    property tablename: string read FTableName;
    property RowStatus: string read FRowStatus;
    property EofBof: string read FEofBof;
    property FileAccess: string read FFileAccess;
    property FileState: string read FFileState;
    procedure UpdateStatus;
    constructor create(aowner: TComponent); override;
    destructor Destroy; override;
    { Public declarations }
  published
    { Published declarations }
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TEnhancedSource]);
end;
constructor TEnhancedSource.Create(AOwner: TComponent);
  begin
   inherited Create(AOwner);
   {fOnDataChange := DataChange;}
  end;
destructor TEnhancedSource.destroy;
 begin
   inherited destroy;
 end;
function TEnhancedSource.getrownumber: longint;
var
res: DbiResult;
rRecProp: RecProps;
cp: CurProps;
szErrMsg: DBIMSG;
begin
result := 0;
try
with dataset do
 begin
  if not active then exit;
  if bof then result := 1;
  if eof then result := recordcount;

  if (eof) or (bof) then exit;
  UpdateCursorPos;
  res := dbigetcursorprops(handle,cp);
  res := dbigetrecord(handle,dbinolock,nil,@rRecProp);

  if res <> DBIERR_NONE then exit;
  if strpas(cp.sztabletype) = 'PARADOX' then
     result := rRecProp.iseqnum;
  if strpas(cp.sztabletype) = 'DBASE' then
     result := rRecProp.iphyrecnum;
 end;
finally
end;
end;

function TEnhancedSource.GetTableName: string;
var
temp: string;
i: integer;
begin
if dataset is ttable then
   with dataset as ttable do
       result := tablename;

if dataset is tquery then
   {extract Table name from sql string}
   with dataset as tquery do
      begin
       temp := '';

       for i := 0 to sql.count-1 do     {had trouble referencing text property, so I did it the hard way}
        temp := temp + sql.strings[i] + ' ';

       temp := uppercase(temp);
       i := pos('FROM ',temp);
       system.delete(temp,1,i+4);

       i := pos('WHERE ',temp);
       if i > 0 then
         system.delete(temp,i,length(temp)-i);

       result := 'Query: ' + temp;
      end;
end;

Function TEnhancedSource.GetEofBof: string;
begin
with dataset do begin
   result := '';
   if eof then result := 'EOF';
   if bof then result := 'BOF';
end;
end;
Function TEnhancedSource.GetFileAccess: string;
begin

if dataset is ttable then
 with dataset as ttable do begin
   result := 'Read/Write';
   if readonly then result := 'Read Only';
 end;

 if dataset is tquery then
 with dataset as tquery do begin
   result := 'Read/Write';
   if not canmodify then result := 'Read Only';
 end;
end;

Function TEnhancedSource.GetFileState: string;
begin
case state of
     dsedit   : result := 'Edit';
     dsinsert : result := 'Insert';
     dsbrowse : result := 'Browse';
else
    result := 'Inactive';
end;
end;

procedure TEnhancedSource.UpdateStatus;

begin

if not dataset.active then exit;

FTableName := GetTableName;
FFileAccess := GetFileAccess;
FFileState := GetFileState;
FEofBof := GetEofBof;
FRowNumber := GetRowNumber;

FRowStatus := 'Records ' + inttostr(dataset.recordcount);
if FRowNumber = 0 then exit;
FRowStatus := 'Row #' + inttostr(FRowNumber) + ' of ' + inttostr(dataset.recordcount);
end;
end.
