program Dtstcoll;
  {Test program for collections}

{ Undefine this if you don't want debugging info or assertion checks }
{$DEFINE DEBUG}

{ Check for Delphi }
{$IFNDEF VER80}
!! Error - this program is for Delphi only
{$ENDIF}

{------Changeable compiler switches-----------------------------------}
{$A+   Word align variables }
{$F+   Force Far calls }
{$K+   Use smart callbacks
{$N+   Allow coprocessor instructions }
{$P+   Open parameters enabled }
{$Q+   No integer overflow checking }
{$R+   No range checking }
{$S+   No stack checking }
{$T-   @ operator is NOT typed }
{---------------------------------------------------------------------}


{------Fixed compiler switches----------------------------------------}
{$B-   Short-circuit boolean expressions }
{$G+   80286+ type instructions }
{$I+   I/O checking via exceptions }
{$V-   Disable var string checking }
{$W-   No Windows realmode stack frame }
{$X+   Enable extended syntax }
{$IFDEF DEBUG}
{$D+,L+,Y+  Enable debug information }
{$ELSE}
{$D-,L-,Y-  Disable debug information }
{$ENDIF}
{---------------------------------------------------------------------}

uses
  SysUtils,
  EZDSLCts in 'EZDSLCTS.PAS',
  EZDSLBse in 'EZDSLBSE.PAS',
  Ezdslcol in 'EZDSLCOL.PAS',
  EZDSLSup in 'EZDSLSUP.PAS',
  WinTypes,
  WinProcs,
  WinCrt;

function RandomStr(Len : byte) : string;
  var
    i : integer;
  begin
    for i := 1 to Len do
      Result[i] := char(Random(26) + ord('A'));
    Result[0] := char(Len);
  end;

function NumToName(i : integer) : string;
  const
    NumNames : array [0..10] of string[5] =
               ('zero', 'one', 'two', 'three', 'four', 'five',
                'six', 'seven', 'eight', 'nine', 'ten');
  begin
    if (i < 0) then
      Result := 'LessThanZero'
    else if (i > 10) then
      Result := 'BigNumber'
    else
      Result := NumNames[i];
  end;

function PrintStrs(C : TAbstractContainer;
                   aData : pointer;
                   ExtraData : pointer) : boolean; far;
  var
    F : ^text absolute ExtraData;
    S : PString absolute aData;
  begin
    Result := true;
    writeln(F^, S^);
  end;

var
  NewColl, Coll : TEZCollection;
  NewSColl, SColl : TEZSortedCollection;
  i, j : integer;
  StartMem : longint;

  P : pointer;
  F : text;
  C : char;
begin
  {make sure there's a new heap block}
  GetMem(P, 8);

  InitWinCrt;
  writeln('Starting tests');

  StartMem := MemAvail;

  Coll := nil;

  Assign(F, 'TEST.LOG');
  Rewrite(F);
  try
    writeln(F, '***UNSORTED COLLECTION***');
    writeln(F, 'First test: insertion into a collection, iterating');
    Coll := TEZCollection.Create(true);
    with Coll do
      begin
        Compare := EZStrCompare;
        DupData := EZStrDupData;
        DisposeData := EZStrDisposeData;
        for i := 1 to 10 do
          Insert(NewStr(NumToName(i)));
        Iterate(PrintStrs, false, @F);
        writeln(F, 'done first test');
      end;

    writeln(F, 'Second test: freeing item 1 repeatedly');
    with Coll do
      begin
        for i := 1 to 10 do
          Free(Items[0]);
        Iterate(PrintStrs, false, @F);
        writeln(F, 'done second test');
      end;
(*
    writeln(F, 'Third test: mega test and Empty');
    with Coll do
      begin
        for i := 1 to 10000 do
          Insert(NewStr(RandomStr(25)));
        Iterate(PrintStrs, false, @F);
        writeln(F, 'now calling Empty');
        Empty;
        writeln(F, 'done third test');
      end;
*)
    writeln(F, '***SORTED COLLECTION***');
    writeln(F, 'First test: insertion into a collection, iterating');
    SColl := TEZSortedCollection.Create(true);
    with SColl do
      begin
        Compare := EZStrCompare;
        DupData := EZStrDupData;
        DisposeData := EZStrDisposeData;
        for i := 1 to 10 do
          Insert(NewStr(NumToName(i)));
        Iterate(PrintStrs, false, @F);
        writeln(F, 'done first test');
      end;

    writeln(F, 'Second test: freeing item 1 repeatedly');
    with SColl do
      begin
        for i := 1 to 10 do
          Free(Items[0]);
        Iterate(PrintStrs, false, @F);
        writeln(F, 'done second test');
      end;

    writeln(F, 'Third test: mega test, Pack and Empty');
    with SColl do
      begin
        for i := 1 to 10000 do
          Insert(NewStr(RandomStr(25)));
        Iterate(PrintStrs, false, @F);
        writeln(F, 'now calling Pack');
        Pack;
        writeln(F, 'now calling Pack again!');
        Pack;
        Iterate(PrintStrs, false, @F);
        writeln(F, 'now calling Empty');
        Empty;
        writeln(F, 'done third test');
      end;

    writeln(F, 'Fourth test: clone and assign');
    with Coll do
      begin
        for i := 1 to 100 do
          Insert(NewStr(RandomStr(25)));
        Iterate(PrintStrs, false, @F);
        writeln(F, 'now calling Clone');
        NewColl := TEZSortedCollection.Clone(Coll, true, EZStrCompare);
        NewColl.Iterate(PrintStrs, false, @F);
        writeln(F, 'now calling Assign');
        SColl.Assign(NewColl);
        SColl.Iterate(PrintStrs, false, @F);
        NewColl.Destroy;
        writeln(F, 'done 4th test');
      end;

  finally
    Coll.Destroy;
    SColl.Destroy;

    writeln(F, 'Memory - Start: ', StartMem);
    writeln(F, '           End: ', MemAvail);

    Close(F);
  end;

  writeln('Tests complete, TEST.LOG file created, press any key');
  C := ReadKey;
  DoneWinCrt;
  FreeMem(P, 8);
end.

