program EXInsDup;
  {-Example program showing how to insert duplicate data objects,
    error checking has not been implemented.}

uses
  SysUtils,
  WinCrt,
  EZDSLBse,
  EZDSLSup,
  EZDSLBtr;

type
  {A data object for non-duplicate strings}
  PNoDupStr = ^TNoDupStr;
  TNoDupStr = record
    Seq : longint;
    St  : string;
  end;

  {A red black tree for storing non-duplicate strings}
  TStringRBTree = class(TrbSearchTree)
    private
      Seq : longint;

    public
      constructor Create;
      procedure Insert (var Cursor : TTreeCursor; aData : pointer); override;
  end;

function NewNoDupStr(const S : string) : PNoDupStr;
  {-Create a new no-dup string}
  var
    P : PNoDupStr;
  begin
    GetMem(P, 5 + length(S));
    P^.Seq := 0;
    P^.St := S;
    NewNoDupStr := P;
  end;

procedure DisposeNoDupStr(P : PNoDupStr);
  {-Dispose of a no-dup string}
  begin
    if (P <> nil) then
      FreeMem(P, 5 + length(P^.St));
  end;

procedure MyDisposeData(aData : pointer); far;
  {Our container's data disposal routine}
  begin
    DisposeNoDupStr(PNoDupStr(aData));
  end;

function MyCompareData(Data1, Data2 : pointer) : integer; far;
  {Our container's comparison routine - it'll write a '!' when
   two strings compare equal and then compare the sequence field}
  var
    P1 : PNoDupStr absolute Data1;
    P2 : PNoDupStr absolute Data2;
    Res : integer;
  begin
    Res := EZStrCompare(@P1^.St, @P2^.St);
    if (Res = 0) then
      begin
        write('!');
        if (P1^.Seq < P2^.Seq) then
          Res := -1
        else
          Res := 1;
      end;
    MyCompareData := Res;
  end;

constructor TStringRBTree.Create;
  {Constructor for our container: zero the Seq field, set our
   data routines}
  begin
    inherited Create(true);
    Seq := 0;
    SetCompare(MyCompareData);
    SetDisposeData(MyDisposeData);
  end;

procedure TStringRBTree.Insert (var Cursor : TTreeCursor; aData : pointer);
  {Insert method for our container: sets the data object's sequence field
   before insertion}
  begin
    inc(Seq);
    PNoDupStr(aData)^.Seq := Seq;
    inherited Insert(Cursor, aData);
  end;

function RandStr3 : string;
  {-Return a random 3 char string}
  var
    i : integer;
    S : string[3];
  begin
    S[0] := char(3);
    for i := 1 to 3 do
      S[i] := char(Random(26) + ord('A'));
    RandStr3 := S;
  end;

var
  i : longint;
  StrRBTree : TStringRBTree;
  StartMem : longint;
  Dummy : TTreeCursor;

begin
  {create a new string tree}
  StrRBTree := TStringRBTree.Create;

  {insert a bunch of string[3]'s - there are bound to be duplicates}
  with StrRBTree do
    for i := 1 to 2000 do
      Insert(Dummy, NewNoDupStr(RandStr3));

  writeln; writeln;
  writeln('There are ', StrRBTree.Count, ' items in the tree');

  {destroy the tree}
  StrRBTree.Free;
end.
