{===EZDSLSTK==========================================================

Part of the Delphi Structures Library--the stack.

EZDSLSTK is Copyright (c) 1993, 1995 by  Julian M. Bucknall

VERSION HISTORY
18Jun95 JMB 1.00 conversion of EZStrucs to Delphi
======================================================================}
{ Copyright (c) 1993, 1995, Julian M. Bucknall. All Rights Reserved   }

unit EZDSLStk;

{Declare the compiler defines}
{$I EZDSLDEF.INC}

{------Changeable compiler switches-----------------------------------}
{$A+   Word align variables }
{$F+   Force Far calls }
{$K+   Use smart callbacks
{$N+   Allow coprocessor instructions }
{$P+   Open parameters enabled }
{$Q+   Integer overflow checking }
{$R+   Range checking }
{$S+   Stack checking }
{$T-   @ operator is NOT typed }
{$U-   Non Pentium safe FDIV }
{$Z-   No automatic word-sized enumerations}
{---------------------------------------------------------------------}

interface

uses
  SysUtils,
  WinTypes,
  WinProcs,
  Classes,
  EZDSLCts,
  EZDSLSup,
  EZDSLBse;

type
  TStack = class(TAbstractContainer)
    {-Stack object}
    private
      Head : PNode;

    public
      constructor Create(DataOwner : boolean); override;
      constructor Clone(Source : TAbstractContainer;
                        DataOwner : boolean; NewCompare : TCompareFunc); override;

      procedure Empty; override;
      function  Examine : pointer;
      function  Pop : pointer;
      procedure Push(aData : pointer);
  end;

implementation

{=TStack==============================================================}
constructor TStack.Create(DataOwner : boolean);
  begin
    NodeSize := 8;
    inherited Create(DataOwner);
    Head := acNewNode(nil);
    Head^.Link := Head;
    FCount := 0;
  end;
{--------}
constructor TStack.Clone(Source : TAbstractContainer;
                         DataOwner : boolean; NewCompare : TCompareFunc);
  var
    JoinNode,
    NewNode,
    Node     : PNode;
    OldStack : TStack absolute Source;
    NewData  : pointer;
  begin
    Create(DataOwner);
    Compare := NewCompare;
    DupData := OldStack.DupData;
    DisposeData := OldStack.DisposeData;

    if not (Source is TStack) then
      RaiseError(escBadSource);

    if OldStack.IsEmpty then Exit;

    JoinNode := Head;
    Node := OldStack.Head^.Link;
    while (Node <> OldStack.Head) do
      begin
        if DataOwner then
             NewData := DupData(Node^.Data)
        else NewData := Node^.Data;
        try
          NewNode := acNewNode(NewData);
          NewNode^.Link := JoinNode^.Link;
          JoinNode^.Link := NewNode;
          JoinNode := NewNode;
          Node := Node^.Link;
        except
          DisposeData(NewData);
          raise;
        end;
      end;
  end;
{--------}
procedure TStack.Empty;
  begin
    if IsDataOwner then
      while not IsEmpty do DisposeData(Pop)
    else
      while not IsEmpty do Pop;
    if InDone then
      if Assigned(Head) then
        acDisposeNode(Head);
  end;
{--------}
function  TStack.Examine : pointer;
  begin
    {$IFDEF DEBUG}
    Assert(not IsEmpty, ascEmptyExamine);
    {$ENDIF}
    Examine := Head^.Link^.Data;
  end;
{--------}
function  TStack.Pop : pointer;
  var
    Node : PNode;
  begin
    {$IFDEF DEBUG}
    Assert(not IsEmpty, ascEmptyPop);
    {$ENDIF}
    Node := Head^.Link;
    Head^.Link := Node^.Link;
    Result := Node^.Data;
    acDisposeNode(Node);
  end;
{--------}
procedure TStack.Push(aData : pointer);
  var
    Node : PNode;
  begin
    Node := acNewNode(aData);
    Node^.Link := Head^.Link;
    Head^.Link := Node;
  end;
{---------------------------------------------------------------------}

end.
