unit Asserts;
{
   Project "Opnek Standard Library (Delphi)"                                   
   Opnek Research                                                              
   Copyright  1995. All Rights Reserved.                                      
                                                                               
   SUBSYSTEM:     General Debug Assistance Library
   FILE:          Assert.pas
   AUTHOR:        Jay Cole
   WRITTEN:       03/04/1995
   LAST ASSERT:   36


   OVERVIEW
   ========
   Because C/C++ allows #defines, it is much easier to implement a non
   intrusive assert().  here, we can copy the assert code, but the procedure
   call still happens.  So, we should at the outer level also ifdef out the
   actual call to assert.  usually this can be accomplished by calling assert
   just like normal, and then search for asserts() after you finish with reg
   expressions and put the conditionals at the beginning and end.
   You must create a (DEFINE of _NDEBUG) to avoid calling the debug procedures
   that are thrown.

   UPDATE HISTORY
   ==============
   03/04/95 (JLC) - Created
}

interface

{ Call if you need to verify implied conditions }
procedure Assert(cond : boolean; const msgStr : string; ndx : integer);

implementation
{$ifdef WINDOWS}
   uses WinProcs, SysUtils, WinTypes;
{$else}
   uses sysUtils;
{$endif}

{ Called when a procedure assumption is not met }
procedure Assert(cond : boolean; const msgStr : string; ndx : integer);
var msgOut : array[0..255] of char;
    msgNum : array[0..20] of char;
    tstr : string;
begin
   {$ifndef _NDEBUG}
      if (not cond) then begin
         StrPCopy(msgOut, msgStr);
         Str(ndx, msgNum);
         StrCat(msgOut, '('); StrCat(msgOut, msgNum); StrCat(msgOut, ')');
         {$ifdef WINDOWS}
            MessageBox(0, 'Assert Failed', msgOut, MB_OK);
         {$else}
            Write('Assert Failed', msgOut);
         {$endif}
         halt;
      end;
   {$endif}
end;

end.
