unit BuffTest;
{
   Project "Test File Buffering"
   Opnek Research
   Copyright  1995. All Rights Reserved.

   SUBSYSTEM:      FileBuff test stub
   FILE:           BuffTest.Pas
   AUTHOR:         Jay Cole
   WRITTEN:        05/10/95
   LAST ASSERT:    0
                                                                               
   OVERVIEW                                                                    
   ========                                                                    
   Provides an interactive way to test the buffering schemes against unbuffered.
   Also it allows us to improve FileBuff and test the results of the new scheme
   against the old.  _TESTHARNESS is defined in the Option|Project section of 
   this project.  We also leave out the Assert Code by defining _NDEBUG in the 
   project so we don't have the overhead call for checking assertions.

   CAUTIONS
   ========
   - Make sure the Far calls are turned on for the project, that way we can gauge
   the impact of far calls (inter module) on the system.  They shouldn't be much.
   - Add integrity checks to make sure the buffered version matches the unbuffered
   version.

   UPDATE HISTORY
   ==============
   05/10/95 - Created
   05/13/95 - Added user defined buffersize/recordsize/iterations
}

interface
{$define _TESTHARNESS } {<- This must be defined in your project in order to run }

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    FileCreateResult: TEdit;
    UniformCopyResult: TEdit;
    FileReadResults: TEdit;
    ModifyInPlaceResults: TEdit;
    FileCreate2: TEdit;
    FileCopy2: TEdit;
    FileReadResults2: TEdit;
    FileModify2: TEdit;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Write64k: TEdit;
    Read64k: TEdit;
    Label8: TLabel;
    Label9: TLabel;
    BuffSize: TEdit;
    Label10: TLabel;
    RecSize: TEdit;
    Label11: TLabel;
    NumIter: TEdit;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
uses FileBuff;

{$R *.DFM}

{ Kick off the test and fill in the results }
procedure TForm1.Button1Click(Sender: TObject);
var oldCreateTime, oldCopyTime, oldReadTime, oldModifyTime : double;
    newCreateTime, newCopyTime, newReadTime, newModifyTime : double;
    numBufSize, numRecSize : word;
    numNumIter : longint;
    writeBench, readBench : double;
begin
   { First, get our information }
   numBufSize := StrToInt(BuffSize.Text);
   numRecSize := StrToInt(RecSize.Text);
   numNumIter := StrToInt(NumIter.Text);
   oldCreateTime := 0.0; oldCopyTime := 0.0; oldReadTime := 0.0; oldModifyTime := 0.0;
   newCreateTime := 0.0; newCopyTime := 0.0; newReadTime := 0.0; newModifyTime := 0.0;

   { Call the tester }
   FileBuff.TestFileBuff(
      numBufSize, numRecSize, numNumIter,
      oldCreateTime, oldCopyTime, oldReadTime, oldModifyTime,
      newCreateTime, newCopyTime, newReadTime, newModifyTime,
      writeBench, readBench
   );

   { Buffered/UnBuffered timings }
   FileCreateResult.Text        := FloatToStrF(oldCreateTime, ffNumber, 4, 2) + ' secs';
   UniformCopyResult.Text       := FloatToStrF(oldCopyTime, ffNumber, 4, 2) + ' secs';
   FileReadResults.Text         := FloatToStrF(oldReadTime, ffNumber, 4, 2) + ' secs';
   ModifyInPlaceResults.Text    := FloatToStrF(oldModifyTime, ffNumber, 4, 2) + ' secs';
   FileCreate2.Text             := FloatToStrF(newCreateTime, ffNumber, 4, 2) + ' secs';
   FileCopy2.Text               := FloatToStrF(newCopyTime, ffNumber, 4, 2) + ' secs';
   FileReadResults2.Text        := FloatToStrF(newReadTime, ffNumber, 4, 2) + ' secs';
   FileModify2.Text             := FloatToStrF(newModifyTime, ffNumber, 4, 2) + ' secs';

   { Raw bench marks for best speed }
   Write64k.Text                := FloatToStrF(writeBench, ffNumber, 4, 2) + ' secs';
   Read64k.Text                 := FloatToStrF(readBench, ffNumber, 4, 2) + ' secs';
end;

end.
 