unit _main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Menus, ExtCtrls;

type
  TMainForm = class(TForm)
    MainMenu1: TMainMenu;
    Bevel1: TBevel;
    cmFile: TMenuItem;
    cmFileCopy: TMenuItem;
    cmFileRen: TMenuItem;
    cmFileComp: TMenuItem;
    N1: TMenuItem;
    cmFileExit: TMenuItem;
    cmFilePrint: TMenuItem;
    N2: TMenuItem;
    About1: TMenuItem;
    procedure cmFileExitClick(Sender: TObject);
    procedure cmFileCopyClick(Sender: TObject);
    procedure cmFileRenClick(Sender: TObject);
    procedure cmFileCompClick(Sender: TObject);
    procedure About1Click(Sender: TObject);
  private
    { Private-dclarations }
  public
    { Public-dclarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

Uses _TwoFile, _Var, _FileRes, _Files95, _CompRes, _about;

procedure TMainForm.cmFileExitClick(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.cmFileCopyClick(Sender: TObject);
Var LI : LongInt;
begin
  With TwoFileForm do
  Begin
    Caption      := 'File Copy (func COPYFILE)';
    Txt1.Caption := 'Source';
    Txt2.Caption := 'Destination';
  End;

  ToDo := FCopy;

  If TwoFileForm.ShowModal = mrOK then
  Begin
    If FileExist(TwoFileForm.Edit2.Text) in [0, File_Access_Denied] then
      If MessageDlg('The destination file you choosed already exist!' + #13#13 +
                    'Do you really want to erase it!',
                    mtWarning, [mbYes, mbNo], 0) = mrNo then Exit;

    LI := CopyFile(TwoFileForm.Edit1.Text, TwoFileForm.Edit2.Text);

    FCopyForm.FCopyMemo.Lines.Add('Error n' + IntToStr(LI) + ' - ' +
                                  TwoFileForm.Edit1.Text + ' - ' +
                                  TwoFileForm.Edit2.Text);
  End;
end;

procedure TMainForm.cmFileRenClick(Sender: TObject);
Var LI : LongInt;
begin
  With TwoFileForm do
  Begin
    Caption      := 'File Rename (func RENAMEFILE)';
    Txt1.Caption := 'Source';
    Txt2.Caption := 'Destination';
  End;

  ToDo := FRename;

  If TwoFileForm.ShowModal = mrOK then
  Begin
    If FileExist(TwoFileForm.Edit2.Text) in [0, File_Access_Denied] then
      If MessageDlg('The destination file you choosed already exist!' + #13#13 +
                    'Do you really want to erase it!',
                    mtWarning, [mbYes, mbNo], 0) = mrNo then Exit;

    LI := RenameFile(TwoFileForm.Edit1.Text, TwoFileForm.Edit2.Text);

    FCopyForm2.FCopyMemo.Lines.Add('Error n' + IntToStr(LI) + ' - ' +
                                   TwoFileForm.Edit1.Text + ' - ' +
                                   TwoFileForm.Edit2.Text);
  End;
end;

procedure TMainForm.cmFileCompClick(Sender: TObject);
Var LI      : LongInt;
    ErrFile : String;
    Check   : Word;
    CompRec : TCompRec;
    FInfo   : TFileInfo;
begin
  With TwoFileForm do
  Begin
    Caption      := 'File Compare (func COMPAREFILE)';
    Txt1.Caption := 'File N1';
    Txt2.Caption := 'File N2';
  End;

  ToDo := FCompare;

  If TwoFileForm.ShowModal = mrOK then
  Begin
    FCompareForm.ErrBox.Clear;

    FCompareForm.txt1.Caption := 'Compare done on the ' + DateToStr(Date) +
                                 ' at ' + TimeToStr(Time);

    FCompareForm.txt2.Caption := TwoFileForm.Edit1.Text;
    FCompareForm.txt3.Caption := TwoFileForm.Edit2.Text;

    LI := CompareFile(TwoFileForm.Edit1.Text, TwoFileForm.Edit2.Text, ErrFile);

    FCompareForm.txt4.Caption := IntToStr(LI) + ' func CompareFile';

    If LI = 0 then
    Begin
      FInfo.FName := ErrFile;

      OpenCompareFile(FInfo);

      CheckCompareAttr(FInfo, Check);

      If Check and Same_Size = Same_Size then FCompareForm.txt5.Caption := 'YES'
      Else FCompareForm.txt5.Caption := 'NO';
      FCompareForm.txt5.Caption := FCompareForm.txt5.Caption + ' (func CheckCompareAttr)';

      If Check and Same_Attr = Same_Attr then FCompareForm.txt6.Caption := 'YES'
      Else FCompareForm.txt6.Caption := 'NO';
      FCompareForm.txt6.Caption := FCompareForm.txt6.Caption + ' (func CheckCompareAttr)';

      If Check and Same_DT = Same_DT then FCompareForm.txt7.Caption := 'YES'
      Else FCompareForm.txt7.Caption := 'NO';
      FCompareForm.txt7.Caption := FCompareForm.txt7.Caption + ' (func CheckCompareAttr)';

      LI := GetCompareErrNum(FInfo);
      FCompareForm.txt8.Caption := IntToStr(LI) + ' (GetCompareErrNum)';

      LI := 0;
      While GetCompareErrRec(FInfo, LI, CompRec) = 0 do
      Begin
        FCompareForm.ErrBox.Items.Add(IntToStr(CompRec.Pos) + ' - ' +
                                      CompRec.CharSource + ' - ' +
                                      CompRec.CharDest);

        Inc(LI);
      End;

      CloseCompareFile(FInfo);

      System.Assign(FInfo.F, FInfo.FName); System.Erase(FInfo.F);
    End
    Else
    Begin
      FCompareForm.txt5.Caption := 'N/A';
      FCompareForm.txt6.Caption := 'N/A';
      FCompareForm.txt7.Caption := 'N/A';
      FCompareForm.txt8.Caption := 'N/A';
    End;
  End;
end;

procedure TMainForm.About1Click(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

end.
