unit GenID;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DB, DBTables;

type
  TIDTable = class(TTable)
  private
    { Private declarations }
  protected
    procedure DoBeforePost; override;
  public
    { Public declarations }
  published
    { Published declarations }
  end;

procedure Register;

implementation

procedure TIDTable.DoBeforePost;
var
  GenID_SP: TStoredProc;
begin

  inherited DoBeforePost;

  if State = dsInsert then
    begin
      GenID_SP:= TStoredProc.Create( Application );
      GenID_SP.DatabaseName:= DatabaseName;
      GenID_SP.StoredProcName:= 'dbo.GenId';
      GenID_SP.Params.CreateParam( ftString, '@TableName', ptInput );
      GenID_SP.Params.CreateParam( ftSmallInt, '@NameLen', ptInput );
      GenID_SP.Params.CreateParam( ftInteger, '@NewId', ptOutput );
      GenID_SP.ParamByName( '@TableName' ).AsString:= TableName;
      GenID_SP.ParamByName( '@NameLen' ).AsSmallInt:= Length( TableName );
      GenID_SP.ExecProc;
      Fields[0].AsInteger:= GenID_SP.ParamByName( '@NewId' ).AsInteger;
      GenID_SP.Free;
    end;

end;

procedure Register;
begin
  RegisterComponents('Data Access', [TIDTable]);
end;

end.
