
DROP PROCEDURE GenId
go

CREATE PROCEDURE GenId @TableName varchar(60), @NameLen smallint,
  @NewId int OUTPUT AS
BEGIN TRANSACTION

  SELECT @TableName = SUBSTRING(@TableName, 1, @NameLen )
  SELECT @NewId = NULL

  IF EXISTS( SELECT * FROM SysId WHERE TableName = @TableName )
    BEGIN
      UPDATE SysId
        SET Id = (Id + 1 ),
            Last_Update = GetDate(),
            Update_By = SUser_Name()
        WHERE TableName = @TableName
      SELECT @NewId = Id FROM SysId
        WHERE TableName = @TableName
    END
  ELSE
    RAISERROR('Unknown table name "%s" in call to procedure GenId',
              11, -1, @TableName )
  COMMIT TRANSACTION

