unit Aboutbox;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls;

type
  TAboutForm = class(TForm)
    LabelUserName: TLabel;
    LabelCompName: TLabel;
    LabelWinVer: TLabel;
    LabelDOSVer: TLabel;
    LabelWinMode: TLabel;
    ValueMemory: TLabel;
    ValueMathCo: TLabel;
    ValueFSRs: TLabel;
    Bevel3: TBevel;
    Image1: TImage;
    BitBtn1: TBitBtn;
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  AboutForm: TAboutForm;

implementation
(*!*) Uses Ver;
{$R *.DFM}
procedure TAboutForm.FormCreate(Sender: TObject);
VAR
  WinVer, WinFlags : LongInt;
  hInstUser : Word;
  Buffer : ARRAY[0..30] OF Char;
  VerBuffSize : LongInt;
  VerBuffHandle : LongInt;
  VerBuff    : PChar;
  VerBuffS   : String;
  VerPosLoc  : Byte;
  VerNumBuff : ARRAY[0..5] OF Char;
  WinVerS    : String[4];
begin
  Image1.Picture.Graphic := Application.Icon;
  hInstUser := LoadLibrary('USER');
  FreeLibrary(hInstUser);
  LoadString(hInstUser, 514, Buffer, 30);
  LabelUserName.Caption := StrPas(Buffer);
  LoadString(hInstUser, 515, Buffer, 30);
  LabelCompName.Caption := StrPas(Buffer);
  WinVer := GetVersion;
  WinVerS := Format('%u.%.2u',
    [LoByte(LoWord(WinVer)), HiByte(LoWord(WinVer))]);
  VerBuffSize := GetFileVersionInfoSize('USER.EXE', VerBuffHandle);
  GetMem(VerBuff, VerBuffSize+1);
  IF GetFileVersionInfo('USER.EXE', VerBuffHandle, VerBuffSize, VerBuff) THEN
    BEGIN
      VerBuff[0] := #255;
      VerPosLoc := Pos('FileVersion', PString(VerBuff)^);
      IF VerPosLoc <> 0 THEN
        WinVerS := Copy(PString(VerBuff)^, VerPosLoc+12, 4);
    END;
  FreeMem(VerBuff, VerBuffSize+1);
  LabelWinVer.Caption := 'Windows ' + WinVerS;
  LabelDosVer.Caption := Format('DOS %u.%.2u',
    [HiByte(HiWord(WinVer)), LoByte(HiWord(WinVer))]);
  WinFlags := GetWinFlags;
  IF WinFlags AND WF_ENHANCED > 0 THEN
    LabelWinMode.Caption := '386 Enhanced Mode'
  ELSE IF WinFlags AND WF_PMODE > 0 THEN
    LabelWinMode.Caption := 'Standard Mode'
  ELSE LabelWinMode.Caption := 'Real Mode';
  IF WinFlags AND WF_80x87 > 0 THEN
    ValueMathCo.Caption := 'Present'
  ELSE ValueMathCo.Caption := 'Absent';
END;

procedure TAboutForm.FormActivate(Sender: TObject);
VAR
  FreeSpace : LongInt;
  Fmt1, Fmt2, Fmt3 : Word;
begin
  Fmt1 := GetFreeSystemResources(
    GFSR_SYSTEMRESOURCES);
  ValueFSRs.Caption := Format(
    '%d%% Free', [Fmt1]);
  ValueMemory.Caption := FormatFloat(',#######',
    MemAvail DIV 1024) + ' KB Free';
end;


end.
