unit SetSrMsg;

    {Form to Create new scrolling messages. It will return:
    MessageFont  : TFont;     the message's font
    MessageSpeed : Integer;   the scrolling speed 1 is fast 100 is slow
    MessageColor : TColor;    the background color
    MessageMsg   : String;    the message's text}



interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, StdCtrls,
     Buttons, Dialogs, Messages, ColorGrd, Toolhelp, SysUtils;

const
  WM_Trigger = WM_USER + 1;

type
  TMiniScrn = Class(TCustomControl)
  Protected
    procedure Paint; Override;
  end;

  TSetupMsg = class(TForm)
    GroupBox1       : TGroupBox;
    SpeedScrollBar  : TScrollBar;
    Label1          : TLabel;
    Label2          : TLabel;
    Label3          : TLabel;
    NewMsg          : TEdit;
    Ok              : TBitBtn;
    Cancel          : TBitBtn;
    TxtFont         : TBitBtn;
    FontDialog      : TFontDialog;
    ColorDialog     : TColorDialog;
    ScrollingMessage: TLabel;
    ColorGrid       : TColorGrid;
    Label4          : TLabel;
    Label5          : TLabel;
    procedure FormCreate(Sender: TObject);
    procedure CancelClick(Sender: TObject);
    procedure TxtFontClick(Sender: TObject);
    procedure OkClick(Sender: TObject);
    procedure NewMsgChange(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ColorGridChange(Sender: TObject);
    procedure SpeedScrollBarChange(Sender: TObject);
  private
    MessageLeft    : Integer;
    MessageRight   : Integer;
    MessageTop     : Integer;
    BitMsg         : TBitmap;
    MiniScreen     : TMiniScrn;
    MessageLoading : Boolean;
    DelayCounter   : LongInt;
    Procedure MoveMsg(Var WinMsg : TMessage); message WM_Trigger;
    Procedure CreateBitmapMessage(FreeMessage : Boolean);
    Function Delay(Msec : Integer) : boolean;
  public
    MessageFont  : TFont;
    MessageSpeed : Integer;
    MessageColor : TColor;
    MessageMsg   : String;
    Procedure Trigger;
  end;

var
  SetupMsg : TSetupMsg;

implementation

{$R *.DFM}

{------------------------------------------------------------------------}
procedure TMiniScrn.Paint;
var
  CLRRect : TRect;
begin
  CLRRect := ClientRect;
  FillRect(Canvas.Handle, CLRRect, Canvas.Brush.Handle);
end;
{------------------------------------------------------------------------}

Function TSetupMsg.Delay(Msec : Integer) : boolean;
Begin
 Inc(DelayCounter);
 if DelayCounter > Msec then begin
  DelayCounter:=0;
  Result:=true;
 end else
  Result:=false;
end;
{------------------------------------------------------------------------}

Procedure TSetupMsg.CreateBitmapMessage(FreeMessage : Boolean);
Var
  Dest : TRect;
Begin
  If FreeMessage then BitMsg.Free;
  BitMsg := TBitmap.Create;
  BitMsg.Canvas.Font := ScrollingMessage.Font;
  BitMsg.Width := BitMsg.Canvas.TextWidth(ScrollingMessage.Caption) +
                  ScrollingMessage.Width;
  BitMsg.Height := BitMsg.Canvas.TextHeight(ScrollingMessage.Caption);
  Dest:=Rect(0,0,BitMsg.Width,BitMsg.Height);
  with BitMsg.Canvas do begin
    Brush.Color := MiniScreen.Canvas.Brush.Color;
    FillRect(Dest);
    TextOut(0,0,ScrollingMessage.Caption + ' ');
    end;
  MessageLeft := ScrollingMessage.Width;
  MessageRight := BitMsg.Width;
  MiniScreen.Refresh;
end;
{------------------------------------------------------------------------}

Procedure TSetupMsg.MoveMsg(Var WinMsg : TMessage);
Begin
  if not Delay(SpeedScrollBar.Position) then exit;
  Dec(MessageLeft,1);
  Dec(MessageRight,1);
  if MessageRight < 0 then begin
    MessageLeft := MiniScreen.Width;
    MessageRight := BitMsg.Width;
  end;
  MiniScreen.Canvas.Draw(MessageLeft, MessageTop, BitMsg);
End;
{------------------------------------------------------------------------}

Procedure TSetupMsg.Trigger;
Begin
  PostMessage(Handle,WM_Trigger ,0,0);
End;
{------------------------------------------------------------------------}

procedure TSetupMsg.FormCreate(Sender: TObject);
begin
  MessageLoading := True;
End;
{------------------------------------------------------------------------}

procedure TSetupMsg.CancelClick(Sender: TObject);
begin
  Close;
end;
{------------------------------------------------------------------------}

procedure TSetupMsg.TxtFontClick(Sender: TObject);
begin
  FontDialog.Font := ScrollingMessage.Font;
  if FontDialog.Execute then begin
     ScrollingMessage.Font := FontDialog.Font;
     CreateBitmapMessage(True);
  end;
end;
{------------------------------------------------------------------------}

procedure TSetupMsg.OkClick(Sender: TObject);
begin
  MessageFont  := ScrollingMessage.Font;
  MessageSpeed := SpeedScrollBar.Position;
  MessageColor := ColorGrid.BackGroundColor;
  MessageMsg   := NewMsg.Text+' ';
end;
{------------------------------------------------------------------------}

procedure TSetupMsg.NewMsgChange(Sender: TObject);
begin
  If MessageLoading then Exit;
  ScrollingMessage.Caption := NewMsg.Text;
  CreateBitmapMessage(True);
end;
{------------------------------------------------------------------------}

procedure TSetupMsg.FormActivate(Sender: TObject);
begin
  If MessageLoading then begin
    Refresh;
    SpeedScrollBar.Position := 6;
    Label5.caption:='Speed = '+IntToStr(SpeedScrollBar.Position);
    ScrollingMessage.Caption := 'New Message Here ';
    NewMsg.Text := 'New Message Here ';
    MiniScreen := TMiniScrn.Create(Self);
    MiniScreen.Parent := Self;
    MiniScreen.Top := ScrollingMessage.Top;
    MiniScreen.Left := ScrollingMessage.Left;
    MiniScreen.Width := ScrollingMessage.Width;
    MiniScreen.Height := ScrollingMessage.Height;
    MiniScreen.Canvas.Brush.Style := BsSolid;
    CreateBitmapMessage(False);
    MessageLoading := False;
    ColorGrid.BackGroundIndex:=4;
    ColorGrid.ForeGroundIndex:=14;
    DelayCounter:=0;
  end;
end;
{------------------------------------------------------------------------}

procedure TSetupMsg.FormDestroy(Sender: TObject);
begin
  BitMsg.Free;
  MiniScreen.Free;
end;
{------------------------------------------------------------------------}

procedure TSetupMsg.ColorGridChange(Sender: TObject);
begin
  If MessageLoading then Exit;
  MiniScreen.Canvas.Brush.Color := ColorGrid.BackGroundColor;
  ScrollingMessage.Font.Color := ColorGrid.ForeGroundColor;
  CreateBitmapMessage(True);
end;
{------------------------------------------------------------------------}

procedure TSetupMsg.SpeedScrollBarChange(Sender: TObject);
begin
  Label5.caption:='Speed = '+IntToStr(SpeedScrollBar.Position);
  SetFocus;
end;
{------------------------------------------------------------------------}
{------------------------------------------------------------------------}

end.

