{$X+,I+}   {<<<<  This is a switch. Don't delete it}


{Copyright 1995 by
 Kevin Adams, 74742,1444
 Jan Dekkers, 72130,353

No part of this Unit may be copied in any way. However, you may derive
other objects from TDBMultiImage, TDBMultiMedia

Part of Imagelib VCL/DLL Library.Uses ImageLib 2.2.1 Changed the callback to a
function instead of a procedure to let the user cancel out.

Bug fixes:

Changed callback in version 2.21 to a function with cdecl.
using the C calling convention.

Version 2.2.2 Added property ImageLibPalette which if set to True will
use the ImageLib Way to paint. If false it will paint the Delphi way.
This is a fix of a Stretchdraw Delphi bug which doesn't paint correctly
256 color palettes on 256 color Video cards}

{Last minute update: Added properties

property TempMov
property TempAVI
property TempWAV
property TempMID
property TempRMI

MultiMedia blobs (AVI, MOV, WAV, MID, RMI are written to a file first
and than that file is being played. This can cause a problem when you
have two TDBMultiMedia objects on your forum both using the same temp file
(A seldom something). Incase that could happen in your app you need to
assign to both TDBMultiMedia ojects different temp filenames. DON'T change
the extension since the delphi multimedia player is extension sensitive}


unit TDBMulti;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Forms,
  Controls, Extctrls, StdCtrls, DLL221, Menus, DB, DBTables, Mask,
  Buttons, MPlayer, SetSrMsg, Printers;



{ TDBMultiImage }
Type
  TDBMultiImage = class(TCustomControl)
  private
    FDataLink           :  TFieldDataLink;
    FPicture            :  TPicture;
    FBorderStyle        :  TBorderStyle;
    FAutoDisplay        :  Boolean;
    FStretch            :  Boolean;
    FCenter             :  Boolean;
    FPictureLoaded      :  Boolean;
    FUpdateAsJpeg       :  Boolean;
    FReserved           :  Byte;
    Fdither             :  byte;
    FResolution         :  byte;
    FSaveQuality        :  byte;
    FSaveSmooth         :  byte;
    FColor              :  TColor;
    FImageLibPalette    :  Boolean;
    {scrolling message stuff}
    BitMsg              :  TBitmap;
    SMessageLeft        :  Integer;
    SMessageRight       :  Integer;
    SMessageTop         :  Integer;
    ScreenWd            :  Integer;
    ScreenHt            :  Integer;
    BitWidth            :  Integer;
    MessageRunning      :  Boolean;
    DelayCounter        :  LongInt;
    OldColor            :  TColor;
    MmsgCount           :  Integer;
    {end scrolling message stuff}
    procedure DataChange(Sender: TObject);
    function GetDataField: string;
    function GetDataSource: TDataSource;
    function GetField: TField;
    function GetReadOnly: Boolean;
    procedure PictureChanged(Sender: TObject);
    procedure SetAutoDisplay(Value: Boolean);
    procedure SetBorderStyle(Value: TBorderStyle);
    procedure SetCenter(Value: Boolean);
    procedure SetDataField(const Value: string);
    procedure SetDataSource(Value: TDataSource);
    procedure SetPicture(Value: TPicture);
    procedure SetReadOnly(Value: Boolean);
    procedure SetStretch(Value: Boolean);
    procedure UpdateData(Sender: TObject);
    procedure CMEnter(var Message: TCMEnter); message CM_ENTER;
    procedure CMExit(var Message: TCMExit); message CM_EXIT;
    procedure WMLButtonDown(var Message: TWMLButtonDown); message WM_LBUTTONDOWN;
    procedure WMLButtonDblClk(var Message: TWMLButtonDblClk); message WM_LBUTTONDBLCLK;
    procedure WMCut(var Message: TMessage); message WM_CUT;
    procedure WMCopy(var Message: TMessage); message WM_COPY;
    procedure WMPaste(var Message: TMessage); message WM_PASTE;
    procedure CMTextChanged(var Message: TMessage); message CM_TEXTCHANGED;
  protected
    procedure CreateParams(var Params: TCreateParams); override;
    function GetPalette: HPALETTE; override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char); override;
    procedure Notification(AComponent: TComponent;
      Operation: TOperation); override;
    procedure Paint; override;
    procedure PaintTheDelpiWay;
    function GetSmooth : Byte;
    procedure SetSmooth(smooth : Byte);
    function GetQuality : Byte;
    procedure SetQuality(Quality : Byte);
    function GetDither : Byte;
    procedure SetDither(dith : Byte);
    function GetRes : Byte;
    procedure SetRes(res : Byte);
    procedure PrintICOWMF(X, Y, pWidth, pHeight: Integer);
    procedure PrintBitMap(X, Y, pWidth, pHeight: Integer);
    procedure LoadMessageFromStream(MessageStream : TStream);
    Procedure MoveMsg(Var WinMsg : TMessage); message WM_Trigger;
    Function Delay(Ms : Integer) : boolean;
    Function SaveMessageToStream(MFont  : Tfont;
                                  Mspeed : integer;
                                  MColor : Tcolor;
                                  MMsg   : String) : Boolean;
  public
    BFiletype           :  String;
    Bwidth              :  Integer;
    BHeight             :  Integer;
    Bbitspixel          :  Integer;
    Bplanes             :  Integer;
    Bnumcolors          :  Integer;
    BSize               :  Longint;
    Bcompression        :  String;
    {scrolling message stuff}
    MsgText             :  String;
    MsgFont             :  TFont;
    MsgBkGrnd           :  TColor;
    MsgSpeed            :  Integer;
    {End scrolling message stuff}
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure CopyToClipboard;
    procedure CutToClipboard;
    procedure LoadPicture;
    procedure PasteFromClipboard;
    procedure LoadFromFile(filename : TFilename);
    procedure SaveToFile(filename : TFilename);
    procedure SaveToFileAsBMP(filename : TFilename);
    procedure SaveToFileAsJpeg(filename : TFilename);
    function GetInfoAndType : String;
    property Field: TField read GetField;
    property Picture: TPicture read FPicture write SetPicture;
    Procedure Trigger;
    Function CreateMessage : Boolean;
    procedure NewMessage;
    Procedure FreeMsg;
    procedure PrintMultiImage(X, Y, pWidth, pHeight: Integer);
  published
    property JPegDither : Byte read GetDither write SetDither;
    property JPegResolution : Byte read GetRes write SetRes;
    property JPegSaveQuality : Byte read GetQuality write SetQuality;
    property JPegSaveSmooth : Byte read GetSmooth write SetSmooth;
    property UPdateBlobAsJpeg : Boolean read FUpdateAsJpeg write FUpdateAsJpeg;
    property AutoDisplay: Boolean read FAutoDisplay write SetAutoDisplay default True;
    property BorderStyle: TBorderStyle read FBorderStyle write SetBorderStyle default bsSingle;
    property Center: Boolean read FCenter write SetCenter default True;
    property Color;
    property Align;
    property Ctl3D;
    property DataField: string read GetDataField write SetDataField;
    property DataSource: TDataSource read GetDataSource write SetDataSource;
    property DragCursor;
    property DragMode;
    property Enabled;
    property Font;
    property ImageLibPalette : Boolean read FImageLibPalette write FImageLibPalette default True;
    property ParentColor default False;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ReadOnly: Boolean read GetReadOnly write SetReadOnly default False;
    property ShowHint;
    property Stretch: Boolean read FStretch write SetStretch default False;
    property TabOrder;
    property TabStop default True;
    property Visible;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
  end;

{TDBMediaPlayer}
Type
  TDBMediaPlayer = class(TMediaPlayer)
  {Just incase you/we want to add some stuff in the
   future we derived a seperate object.}
end;


{TDBMultiMedia }
Type
  TDBMultiMedia = class(TCustomControl)
  private
    FDataLink           :  TFieldDataLink;
    FPicture            :  TPicture;
    FBorderStyle        :  TBorderStyle;
    FAutoDisplay        :  Boolean;
    FStretch            :  Boolean;
    FCenter             :  Boolean;
    FPictureLoaded      :  Boolean;
    FUpdateAsJpeg       :  Boolean;
    FAutoPlayMM         :  Boolean;
    FAutoMMHide         :  Boolean;
    FAutoRePlayMM       :  Boolean;
    FReserved           :  Byte;
    Fdither             :  byte;
    FResolution         :  byte;
    FSaveQuality        :  byte;
    FSaveSmooth         :  byte;
    FMediaPlayer        :  TDBMediaPlayer;
    FMOVTempFile        :  String;
    FMPGTempFile        :  String;
    FAVITempFile        :  String;
    FWAVTempFile        :  String;
    FMIDTempFile        :  String;
    FRMITempFile        :  String;
    FTempFilePath       :  String;
    FImageLibPalette    :  Boolean;
    {scrolling message stuff}
    BitMsg              :  TBitmap;
    SMessageLeft        :  Integer;
    SMessageRight       :  Integer;
    SMessageTop         :  Integer;
    ScreenWd            :  Integer;
    ScreenHt            :  Integer;
    BitWidth            :  Integer;
    MessageRunning      :  Boolean;
    DelayCounter        :  LongInt;
    OldColor            :  TColor;
    MmsgCount           :  Integer;
    {end scrolling message stuff}
    procedure DataChange(Sender: TObject);
    function GetDataField: string;
    function GetDataSource: TDataSource;
    function GetMediaPlayer: TDBMediaPlayer;
    function GetField: TField;
    function GetReadOnly: Boolean;
    procedure PictureChanged(Sender: TObject);
    procedure SetAutoDisplay(Value: Boolean);
    procedure SetBorderStyle(Value: TBorderStyle);
    procedure SetCenter(Value: Boolean);
    procedure SetDataField(const Value: string);
    procedure SetDataSource(Value: TDataSource);
    procedure SetMediaPlayer(Value: TDBMediaPlayer);
    procedure SetPicture(Value: TPicture);
    procedure SetReadOnly(Value: Boolean);
    procedure SetStretch(Value: Boolean);
    procedure UpdateData(Sender: TObject);
    procedure CMEnter(var Message: TCMEnter); message CM_ENTER;
    procedure CMExit(var Message: TCMExit); message CM_EXIT;
    procedure WMLButtonDown(var Message: TWMLButtonDown); message WM_LBUTTONDOWN;
    procedure WMLButtonDblClk(var Message: TWMLButtonDblClk); message WM_LBUTTONDBLCLK;
    procedure WMCut(var Message: TMessage); message WM_CUT;
    procedure WMCopy(var Message: TMessage); message WM_COPY;
    procedure WMPaste(var Message: TMessage); message WM_PASTE;
    procedure CMTextChanged(var Message: TMessage); message CM_TEXTCHANGED;
  protected
    procedure CreateParams(var Params: TCreateParams); override;
    function GetPalette: HPALETTE; override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char); override;
    procedure Notification(AComponent: TComponent;
      Operation: TOperation); override;
    procedure Paint; override;
    procedure PaintTheDelpiWay;
    function GetSmooth : Byte;
    procedure SetSmooth(smooth : Byte);
    function GetQuality : Byte;
    procedure SetQuality(Quality : Byte);
    function GetDither : Byte;
    procedure SetDither(dith : Byte);
    function GetRes : Byte;
    procedure SetRes(res : Byte);
    function GetTempPath : String;
    procedure SetTempPath(temppath : string);
    function AddBackSlash(DirName : string) : string;
    Procedure CleanUpMultiMedia;
    function IsValidMultiMedia(Name : PChar) : boolean;
    procedure TimerNotify(var Message: TMessage); message WM_TIMER;
    procedure PrintICOWMF(X, Y, pWidth, pHeight: Integer);
    procedure PrintBitMap(X, Y, pWidth, pHeight: Integer);
    procedure LoadMessageFromStream(MessageStream : TStream);
    Procedure MoveMsg(Var WinMsg : TMessage); message WM_Trigger;
    Function Delay(Ms : Integer) : boolean;
    Function SaveMessageToStream(MFont  : Tfont;
                                  Mspeed : integer;
                                  MColor : Tcolor;
                                  MMsg   : String) : Boolean;
  public
    BFiletype           :  String;
    Bwidth              :  Integer;
    BHeight             :  Integer;
    Bbitspixel          :  Integer;
    Bplanes             :  Integer;
    Bnumcolors          :  Integer;
    BSize               :  Longint;
    Bcompression        :  String;
    {scrolling message stuff}
    MsgText             :  String;
    MsgFont             :  TFont;
    MsgBkGrnd           :  TColor;
    MsgSpeed            :  Integer;
    {End scrolling message stuff}
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure CopyToClipboard;
    procedure CutToClipboard;
    procedure LoadMedia;
    procedure PasteFromClipboard;
    procedure LoadFromFile(filename : TFilename);
    procedure SaveToFile(filename : TFilename);
    procedure SaveToFileAsBMP(filename : TFilename);
    procedure SaveToFileAsJpeg(filename : TFilename);
    function GetInfoAndType : String;
    function GetMultiMediaExtensions : String;
    property Field: TField read GetField;
    property Picture: TPicture read FPicture write SetPicture;
    Procedure Trigger;
    Function CreateMessage : Boolean;
    procedure NewMessage;
    Procedure FreeMsg;
    procedure PrintMultiImage(X, Y, pWidth, pHeight: Integer);
  published
    property JPegDither : Byte read GetDither write SetDither;
    property JPegResolution : Byte read GetRes write SetRes;
    property JPegSaveQuality : Byte read GetQuality write SetQuality;
    property JPegSaveSmooth : Byte read GetSmooth write SetSmooth;
    property UPdateBlobAsJpeg : Boolean read FUpdateAsJpeg write FUpdateAsJpeg;
    property AutoPlayMultiMedia : Boolean read FAutoPlayMM write FAutoPlayMM;
    property AutoRePlayMultiMedia : Boolean read FAutoRePlayMM write FAutoRePlayMM;
    property AutoHideMediaPlayer : Boolean read FAutoMMHide write FAutoMMHide;
    property PathForTempFile : string read GetTempPath write SetTempPath;
    property Align;
    property AutoDisplay: Boolean read FAutoDisplay write SetAutoDisplay default True;
    property BorderStyle: TBorderStyle read FBorderStyle write SetBorderStyle default bsSingle;
    property Center: Boolean read FCenter write SetCenter default True;
    property Color;
    property Ctl3D;
    property DataField: string read GetDataField write SetDataField;
    property DataSource: TDataSource read GetDataSource write SetDataSource;
    property MediaPlayer: TDBMediaPlayer read GetMediaPlayer write SetmediaPlayer;
    property DragCursor;
    property DragMode;
    property Enabled;
    property Font;
    property ImageLibPalette : Boolean read FImageLibPalette write FImageLibPalette default True;
    property ParentColor default False;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ReadOnly: Boolean read GetReadOnly write SetReadOnly default False;
    property ShowHint;
    property Stretch: Boolean read FStretch write SetStretch default False;
    property TabOrder;
    property TabStop default True;
    property TempMov : String Read FMOVTempFile write FMOVTempFile;
    property TempAVI : String Read FAVITempFile write FAVITempFile;
    property TempWAV : String Read FWAVTempFile write FWAVTempFile;
    property TempMID : String Read FMIDTempFile write FMIDTempFile;
    property TempRMI : String Read FRMITempFile write FRMITempFile;
    property Visible;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
  end;




var
 TDBMultiImageCallBack : TCallBackFunction;
 TDBMultiMediaCallBack : TCallBackFunction;

{------------------------------------------------------------------------}
implementation
uses Consts, DBIErrs, DBITypes, Clipbrd, DBConsts, Dialogs;

{------------------------------------------------------------------------}

{TDBMultiImage}
constructor TDBMultiImage.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  ControlStyle := ControlStyle + [csFramed, csOpaque];
  Width := 105;
  Height := 105;
  TabStop := True;
  ParentColor := False;
  FPicture := TPicture.Create;
  FPicture.OnChange := PictureChanged;
  FBorderStyle := bsSingle;
  FAutoDisplay := True;
  FImageLibPalette:=True;
  FCenter := True;
  FUpdateAsJpeg := True;
  Fdither:=4;
  FResolution:=8;
  FSaveQuality:=25;
  FSaveSmooth:=0;
  FDataLink := TFieldDataLink.Create;
  FDataLink.Control := Self;
  FDataLink.OnDataChange := DataChange;
  FDataLink.OnUpdateData := UpdateData;
  MsgFont:=TFont.Create;
  BitMsg := TBitmap.Create;
  MessageRunning:=False;
  SetupMsg:=Nil;
  DelayCounter:=0;
  Color:=clWindow;
end;
{------------------------------------------------------------------------}

destructor TDBMultiImage.Destroy;
begin
  FPicture.Free;
  FDataLink.Free;
  MsgFont.Free;
  BitMsg.Free;
  FDataLink := nil;
  inherited Destroy;
end;
{------------------------------------------------------------------------}

function TDBMultiImage.GetDataSource: TDataSource;
begin
  Result := FDataLink.DataSource;
end;
{------------------------------------------------------------------------}

procedure TDBMultiImage.SetDataSource(Value: TDataSource);
begin
  FDataLink.DataSource := Value;
end;
{------------------------------------------------------------------------}

function TDBMultiImage.GetDataField: string;
begin
  Result := FDataLink.FieldName;
end;
{------------------------------------------------------------------------}

procedure TDBMultiImage.SetDataField(const Value: string);
begin
  FDataLink.FieldName := Value;
end;
{------------------------------------------------------------------------}

function TDBMultiImage.GetReadOnly: Boolean;
begin
  Result := FDataLink.ReadOnly;
end;
{------------------------------------------------------------------------}

procedure TDBMultiImage.SetReadOnly(Value: Boolean);
begin
  FDataLink.ReadOnly := Value;
end;
{------------------------------------------------------------------------}

function TDBMultiImage.GetField: TField;
begin
  Result := FDataLink.Field;
end;
{------------------------------------------------------------------------}

function TDBMultiImage.GetPalette: HPALETTE;
begin
  Result := 0;
  if ImageLibPalette then exit;
  if FPicture.Graphic is TBitmap then
    Result := TBitmap(FPicture.Graphic).Palette;
end;
{------------------------------------------------------------------------}

procedure TDBMultiImage.SetAutoDisplay(Value: Boolean);
begin
  if FAutoDisplay <> Value then
  begin
    FAutoDisplay := Value;
    if Value then LoadPicture;
  end;
end;
{------------------------------------------------------------------------}

procedure TDBMultiImage.SetBorderStyle(Value: TBorderStyle);
begin
  if FBorderStyle <> Value then
  begin
    FBorderStyle := Value;
    RecreateWnd;
  end;
end;
{------------------------------------------------------------------------}

procedure TDBMultiImage.SetCenter(Value: Boolean);
begin
  if FCenter <> Value then
  begin
    FCenter := Value;
    Invalidate;
  end;
end;
{------------------------------------------------------------------------}

procedure TDBMultiImage.SetPicture(Value: TPicture);
begin
  FPicture.Assign(Value);
end;
{------------------------------------------------------------------------}

procedure TDBMultiImage.SetStretch(Value: Boolean);
begin
  if FStretch <> Value then
  begin
    FStretch := Value;
    Invalidate;
  end;
end;
{------------------------------------------------------------------------}

procedure TDBMultiImage.Paint;
var
  W, H        : Integer;
  R           : TRect;
  S           : string[63];
  OldBitmap   : HBitmap;
  MemDC       : HDC;
  hOldPal     : HPalette;
begin

  if (BFileType = 'ICO') or (BFileType = 'WMF') or (not ImageLibPalette) then begin
      PaintTheDelpiWay;
      exit;
  end;

  with Canvas do begin
    Brush.Style := bsSolid;
    Brush.Color := Color;

    if FPictureLoaded then begin
      if (Stretch) and (Picture.Graphic <> nil) then

        if Picture.Graphic.Empty then
          FillRect(ClientRect) else
         begin

            hOldPal := SelectPalette(Canvas.handle,Picture.BitMap.Palette,False);
            RealizePalette(Canvas.handle);

            MemDC := CreateCompatibleDC(Canvas.handle);
            OldBitmap := SelectObject(MemDC,Picture.BitMap.Handle);

            SetStretchBltMode(Canvas.handle,STRETCH_DELETESCANS);

            StretchBlt(Canvas.handle,
                       ClientRect.Left,
                       ClientRect.Top,
                       ClientRect.Right,
                       ClientRect.Bottom,
                       MemDC,
                       ClientRect.Left,
                       ClientRect.Top,
                       Picture.BitMap.Width,
                       Picture.BitMap.Height,
                       srcCopy);

             SelectObject(MemDC,OldBitmap);
             DeleteDC(MemDC);
             SelectPalette(Canvas.handle,hOldPal,False);
      end else begin

        SetRect(R, 0, 0, Picture.Width, Picture.Height);
        if Center then OffsetRect(R, (ClientWidth - Picture.Width) div 2,
          (ClientHeight - Picture.Height) div 2);

           hOldPal := SelectPalette(Canvas.handle,Picture.BitMap.Palette,False);
           RealizePalette(Canvas.handle);

           MemDC := CreateCompatibleDC(Canvas.handle);
           OldBitmap := SelectObject(MemDC,Picture.BitMap.Handle);

            BitBlt(Canvas.handle,
                       R.Left,
                       R.Top,
                       Picture.BitMap.Width,
                       Picture.BitMap.Height,
                       MemDC,
                       0,
                       0,
                       srcCopy);

             SelectObject(MemDC,OldBitmap);
             DeleteDC(MemDC);
             SelectPalette(Canvas.handle,hOldPal,False);

             ExcludeClipRect(Handle, R.Left, R.Top, R.Right, R.Bottom);
             FillRect(ClientRect);
             SelectClipRgn(Handle, 0);
          end;
    end else begin
     Font := Self.Font;
     if FDataLink.Field <> nil then
        S := FDataLink.Field.DisplayLabel
     else
        S := Name;
      S := '(' + S + ')';
      W := TextWidth(S);
      H := TextHeight(S);
      R := ClientRect;
      TextRect(R, (R.Right - W) div 2, (R.Bottom - H) div 2, S);
    end;

    if (GetParentForm(Self).ActiveControl = Self) and
      not (csDesigning in ComponentState) then begin
        Brush.Color := clWindowFrame;
        FrameRect(ClientRect);
    end;

  end;

  if (MessageRunning) and (Picture = nil) then FreeMsg;
end;
{------------------------------------------------------------------------}

procedure TDBMultiImage.PaintTheDelpiWay;
var
  W, H: Integer;
  R: TRect;
  S: string[63];
begin
  with Canvas do
  begin
    Brush.Style := bsSolid;
    Brush.Color := Color;
    if FPictureLoaded then
    begin
      if (Stretch) and (Picture.Graphic <> nil) then
        if Picture.Graphic.Empty then
          FillRect(ClientRect) else
          StretchDraw(ClientRect, Picture.Graphic)
      else
      begin
        SetRect(R, 0, 0, Picture.Width, Picture.Height);
        if Center then OffsetRect(R, (ClientWidth - Picture.Width) div 2,
          (ClientHeight - Picture.Height) div 2);
        StretchDraw(R, Picture.Graphic);
        ExcludeClipRect(Handle, R.Left, R.Top, R.Right, R.Bottom);
        FillRect(ClientRect);
        SelectClipRgn(Handle, 0);
      end;
    end else
    begin
      Font := Self.Font;
      if FDataLink.Field <> nil then
        S := FDataLink.Field.DisplayLabel else
        S := Name;
      S := '(' + S + ')';
      W := TextWidth(S);
      H := TextHeight(S);
      R := ClientRect;
      TextRect(R, (R.Right - W) div 2, (R.Bottom - H) div 2, S);
    end;
    if (GetParentForm(Self).ActiveControl = Self) and
      not (csDesigning in ComponentState) then
    begin
      Brush.Color := clWindowFrame;
      FrameRect(ClientRect);
    end;
  end;
  if (MessageRunning) and (Picture = nil) then FreeMsg;
end;
{------------------------------------------------------------------------}

procedure TDBMultiImage.PictureChanged(Sender: TObject);
begin
  FDataLink.Modified;
  FPictureLoaded := True;
  Invalidate;
end;
{------------------------------------------------------------------------}

procedure TDBMultiImage.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) and (FDataLink <> nil) and
    (AComponent = DataSource) then DataSource := nil;
end;
{------------------------------------------------------------------------}

procedure TDBMultiImage.LoadPicture;
var
   Stream       :  TMemoryStream;
   BitMap       :  TBitMap;
   Cursor       :  hCursor;
   temp         :  string;
begin
  if not FPictureLoaded and (FDataLink.Field is TBlobField) then begin

   if TBlobField(FDataLink.Field).IsNull then exit;

   Temp:=GetInfoAndType;

   if Temp = 'SCM' then begin
      Stream:=TMemoryStream.Create;
      try
        Cursor := SetCursor(LoadCursor(0,idc_Wait));
         FreeMsg;
         TBlobField(FDataLink.Field).SaveToStream(Stream);
         LoadMessageFromStream(Stream);
         if @TDBMultiMediaCallBack <> nil then
           TDBMultiMediaCallBack(0);
       finally
         SetCursor(Cursor);
         Stream.Free;
       end;
   end else

   if Temp = 'GIF' then begin
      Stream:=TMemoryStream.Create;
      BitMap:=TBitMap.Create;
      try
         FreeMsg;
         Cursor := SetCursor(LoadCursor(0,idc_Wait));
         TBlobField(FDataLink.Field).SaveToStream(Stream);
         if not gifblob(Stream.Memory,Stream.Size, Bitmap, TDBMultiImageCallBack) then begin
            MessageDlg('Invallid or empty GIF blobfield', mtInformation, [mbOk], 0);
            Picture.Assign(Nil);
         end else
            Picture.Assign(BitMap);
         finally
            SetCursor(Cursor);
            BitMap.free;
            Stream.Free;
         end;
   end else

   if Temp = 'PCX' then begin
      Stream:=TMemoryStream.Create;
      BitMap:=TBitMap.Create;
      try
         FreeMsg;
         Cursor := SetCursor(LoadCursor(0,idc_Wait));
         TBlobField(FDataLink.Field).SaveToStream(Stream);
         if not pcxblob(Stream.Memory,Stream.Size, Bitmap, TDBMultiImageCallBack) then begin
            MessageDlg('Invallid or empty PCX blobfield', mtInformation, [mbOk], 0);
            Picture.Assign(Nil);
         end else
            Picture.Assign(BitMap);
         finally
          SetCursor(Cursor);
          BitMap.free;
          Stream.Free;
         end;
   end else

   if Temp = 'BMP' then begin
      Stream:=TMemoryStream.Create;
      BitMap:=TBitMap.Create;
      try
         FreeMsg;
         Cursor := SetCursor(LoadCursor(0,idc_Wait));
         TBlobField(FDataLink.Field).SaveToStream(Stream);
         if not bmpblob(Stream.Memory,Stream.Size, Bitmap, TDBMultiImageCallBack) then begin
            MessageDlg('Invallid or empty BMP blobfield', mtInformation, [mbOk], 0);
            Picture.Assign(Nil);
         end else
            Picture.Assign(BitMap);
         finally
          SetCursor(Cursor);
          BitMap.free;
          Stream.Free;
         end;
   end else

   if Temp = 'JPG' then begin
      Stream:=TMemoryStream.Create;
      BitMap:=TBitMap.Create;
      if FResolution <> 4 then
      if FResolution <> 8 then
      if FResolution <> 24 then FResolution:=8;
      if (FDither < 0) or (FDither > 4) then FDither:=4;
      try
         FreeMsg;
         Cursor := SetCursor(LoadCursor(0,idc_Wait));
         TBlobField(FDataLink.Field).SaveToStream(Stream);
         if not jpgblob(Stream.Memory,Stream.Size, FResolution, Fdither, Bitmap, TDBMultiImageCallBack) then begin
            MessageDlg('Invallid or empty Jpeg Blobfield', mtInformation, [mbOk], 0);
            Picture.Assign(Nil);
         end else
             Picture.Assign(BitMap);
         finally
             SetCursor(Cursor);
             BitMap.free;
             Stream.Free;
         end;
    end;
    GetInfoAndType;
 end;
end;
{------------------------------------------------------------------------}

procedure TDBMultiImage.DataChange(Sender: TObject);
begin
  If MessageRunning then FreeMsg;
  Picture.Graphic := nil;
  FPictureLoaded := False;
  if FAutoDisplay then LoadPicture;
end;
{------------------------------------------------------------------------}

procedure TDBMultiImage.UpdateData(Sender: TObject);
var
   Stream       :  TMemoryStream;
   Cursor       :  hCursor;
   Usize        :  longInt;
   x,y          :  longInt;
   p            :  Pointer;
begin
  if FDataLink.Field is TBlobField then begin

    if Picture.Graphic is TBitmap then begin
      x:=Picture.BitMap.Width;
      y:=Picture.BitMap.Height;

      y:=y+(y div 5);
      x:=x+(x div 5);

      Usize:=(y * x);

      if Usize < 90000 then Usize:=Usize*2;

      {Since we can't know how much memory we need to allocate
      to write the picture to the stream we need to guess it. This
      is done using the width and height of the bitmap. After the call
      to the dll using PUTJPGBLOB or PUTBMPBLOB Usize contains the
      correct size of the Bitmap stored in P^. You can increase or decrease
      the guessed memory by altering the Div by. For instance

      y:=y+(y div 3);
      x:=x+(x div 3);

      will allocate more memory then

      y:=y+(y div 6);
      x:=x+(x div 6);

      We played it on the save side. Use this "guess work" very carefully}


      P := GlobalAllocPtr(HeapAllocFlags, Usize);

      if P = Nil then
        exit;

      if FUpdateAsJpeg then begin
         if not putjpgblob(P, USize, FSaveQuality, FSaveSmooth, Picture.Bitmap, TDBMultiImageCallBack) then
           MessageDlg('Jpeg BLOB Write Error', mtInformation, [mbOk], 0);
      end else begin
         if not putbmpblob(P, USize, Picture.Bitmap, TDBMultiImageCallBack) then
           MessageDlg('BMP BLOB Write Error', mtInformation, [mbOk], 0);
      end;

      Stream:=TMemoryStream.Create;
      Stream.Write(P^,USize);
      GlobalFreePtr(P);

      try
        TBlobField(FDataLink.Field).LoadFromStream(Stream);
      finally
        Stream.Free;
      end;

    end else
      TBlobField(FDataLink.Field).Clear;
   end;
   GetInfoAndType;
end;
{------------------------------------------------------------------------}

procedure TDBMultiImage.CopyToClipboard;
begin
  if Picture.Graphic <> nil then Clipboard.Assign(Picture);
end;
{------------------------------------------------------------------------}

procedure TDBMultiImage.CutToClipboard;
begin
  if Picture.Graphic <> nil then
  begin
    CopyToClipboard;
    if FDataLink.Edit then
      Picture.Graphic := nil;
  end;
end;
{------------------------------------------------------------------------}

procedure TDBMultiImage.PasteFromClipboard;
begin
  if Clipboard.HasFormat(CF_PICTURE) and FDataLink.Edit then begin
    MessageRunning:=False;
    Picture.Assign(Clipboard);
   end;
end;
{------------------------------------------------------------------------}

procedure TDBMultiImage.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  if FBorderStyle = bsSingle then
    Params.Style := Params.Style or WS_BORDER;
end;
{------------------------------------------------------------------------}

procedure TDBMultiImage.KeyDown(var Key: Word; Shift: TShiftState);
begin
  inherited KeyDown(Key, Shift);
  case Key of
    VK_INSERT:
      if ssShift in Shift then PasteFromClipBoard else
        if ssCtrl in Shift then CopyToClipBoard;
    VK_DELETE:
      if ssShift in Shift then CutToClipBoard;
  end;
end;
{------------------------------------------------------------------------}

procedure TDBMultiImage.KeyPress(var Key: Char);
begin
  inherited KeyPress(Key);
  case Key of
    ^X: CutToClipBoard;
    ^C: CopyToClipBoard;
    ^V: PasteFromClipBoard;
    #13: LoadPicture;
    #27: FDataLink.Reset;
  end;
end;
{------------------------------------------------------------------------}

procedure TDBMultiImage.CMEnter(var Message: TCMEnter);
begin
  Invalidate; { Draw the focus marker }
  inherited;
end;
{------------------------------------------------------------------------}

procedure TDBMultiImage.CMExit(var Message: TCMExit);
begin
  Invalidate; { Erase the focus marker }
  inherited;
end;
{------------------------------------------------------------------------}

procedure TDBMultiImage.CMTextChanged(var Message: TMessage);
begin
  inherited;
  if not FPictureLoaded then Invalidate;
end;
{------------------------------------------------------------------------}

procedure TDBMultiImage.WMLButtonDown(var Message: TWMLButtonDown);
begin
  if TabStop and CanFocus then SetFocus;
  inherited;
end;
{------------------------------------------------------------------------}

procedure TDBMultiImage.WMLButtonDblClk(var Message: TWMLButtonDblClk);
begin
  LoadPicture;
  inherited;
end;
{------------------------------------------------------------------------}

procedure TDBMultiImage.WMCut(var Message: TMessage);
begin
  CutToClipboard;
end;
{------------------------------------------------------------------------}

procedure TDBMultiImage.WMCopy(var Message: TMessage);
begin
  CopyToClipboard;
end;
{------------------------------------------------------------------------}

procedure TDBMultiImage.WMPaste(var Message: TMessage);
begin
  PasteFromClipboard;
end;
{------------------------------------------------------------------------}

procedure TDBMultiImage.LoadFromFile(filename : TFilename);
var
   Cursor       :  hCursor;
begin
  if not FileExists(filename) then begin
    MessageDlg('File not found', mtInformation, [mbOk], 0);
    exit;
  end;

  if UpperCase(ExtractFileExt(filename)) <> '.JPG' then
  if UpperCase(ExtractFileExt(filename)) <> '.GIF' then
  if UpperCase(ExtractFileExt(filename)) <> '.PCX' then
  if UpperCase(ExtractFileExt(filename)) <> '.BMP' then
  if UpperCase(ExtractFileExt(filename)) <> '.SCM' then
  begin
    MessageDlg('Not a Jpeg, Gif, Pcx, Scm or Bmp File', mtInformation, [mbOk], 0);
    exit;
  end;

  if FDataLink.Field is TBlobField then begin
    Cursor := SetCursor(LoadCursor(0,idc_Wait));
    TBlobField(FDataLink.Field).LoadFromFile(filename);
    SetCursor(Cursor);
  end else begin
    MessageDlg('Field is not a blobfield', mtInformation, [mbOk], 0);
    exit;
  end;
  GetInfoAndType;
end;
{------------------------------------------------------------------------}

procedure TDBMultiImage.SaveToFile(filename : TFilename);
var
  Cursor       :  hCursor;
begin
  if FDataLink.Field is TBlobField then begin

    if TBlobField(FDataLink.Field).IsNull then begin
       MessageDlg('Can''t save, blobfield is empty', mtInformation, [mbOk], 0);
       exit;
    end;

    Cursor := SetCursor(LoadCursor(0,idc_Wait));
    TBlobField(FDataLink.Field).SaveToFile(filename);
    GetInfoAndType;
    SetCursor(Cursor)

  end else begin
    MessageDlg('Field is not a blobfield', mtInformation, [mbOk], 0);
    exit;
  end;
end;
{------------------------------------------------------------------------}

procedure TDBMultiImage.SaveToFileAsBMP(filename : TFilename);
var
  Cursor       :  hCursor;
begin
  if FDataLink.Field is TBlobField then begin

    if TBlobField(FDataLink.Field).IsNull then begin
       MessageDlg('Can''t save, blobfield bitmap is empty', mtInformation, [mbOk], 0);
       exit;
    end;

    if picture.bitmap.empty then begin
       MessageDlg('Can''t save, image is not displayed, Set Autodisplay or double click display to view image first.',
                  mtInformation, [mbOk], 0);
       exit;
    end;

    Cursor := SetCursor(LoadCursor(0,idc_Wait));

    if not putbmpfile(FileName, picture.Bitmap, TDBMultiImageCallBack) then begin
      SetCursor(Cursor);
      MessageDlg('Writing bmp file failed', mtInformation, [mbOk], 0);
      exit;
    end;

    GetInfoAndType

  end else begin
    SetCursor(Cursor);
    MessageDlg('Field is not a blobfield', mtInformation, [mbOk], 0);
    exit;
  end;

  SetCursor(Cursor);
end;
{------------------------------------------------------------------------}

procedure TDBMultiImage.SaveToFileAsJpeg(filename : TFilename);
var
  Cursor       :  hCursor;
begin
  if FDataLink.Field is TBlobField then begin

    if TBlobField(FDataLink.Field).IsNull then begin
       MessageDlg('Can''t save, blobfield bitmap is empty', mtInformation, [mbOk], 0);
       exit;
    end;

    if picture.bitmap = nil then begin
       MessageDlg('Can''t save, image is not displayed', mtInformation, [mbOk], 0);
       exit;
    end;

    Cursor := SetCursor(LoadCursor(0,idc_Wait));

    if not putjpgfile(FileName, FSaveQuality, FSaveSmooth, picture.Bitmap, TDBMultiImageCallBack) then begin
      SetCursor(Cursor);
      MessageDlg('Writing jpg file failed', mtInformation, [mbOk], 0);
      exit;
    end;

    GetInfoAndType

  end else begin
    SetCursor(Cursor);
    MessageDlg('Field is not a blobfield', mtInformation, [mbOk], 0);
    exit;
  end;

  SetCursor(Cursor);
end;


{------------------------------------------------------------------------}

function TDBMultiImage.GetInfoAndType : String;
var
 Stream       :  TMemoryStream;
 Hdr          :  Array[0..45] of char;
 i            :  Byte;
begin
  if (FDataLink.Field is TBlobField) then
   if TBlobField(FDataLink.Field).IsNull then exit;

   BFileType := 'Empty';
   Bwidth:=-1;
   BHeight:=-1;
   Bbitspixel:=-1;
   Bplanes:=-1;
   Bnumcolors:=-1;
   Bcompression:='-1';
   BSize:=-1;
   GetInfoAndType :='-1';

   Stream:=TMemoryStream.Create;
   TBlobField(FDataLink.Field).SaveToStream(Stream);

  if Stream.Memory = nil then begin
     MessageDlg('Error allocation temporary blob memory', mtInformation, [mbOk], 0);
     exit;
  end;

  Stream.Seek(0,0);
  Stream.read(hdr,SizeOf(Hdr)-1);

  for i:=0 to SizeOf(hdr)-1 do
   if hdr[i] = #0 then hdr[i]:=' ';

  if StrPos(hdr,'kevinjan') <> nil then begin
        Bwidth:=-1;
        BHeight:=-1;
        Bbitspixel:=-1;
        Bplanes:=-1;
        Bnumcolors:=-1;
        Bcompression:='MSG';
        BSize:=Stream.Size;
        BFileType:= 'SCM';
        GetInfoAndType:='SCM';
        if Stream.Memory <> nil then Stream.Free;
        exit;
   end else

   if not GetBlobInfo(Stream.Memory,
                    Stream.Size,
                    BFileType,
                    Bwidth,
                    BHeight,
                    Bbitspixel,
                    Bplanes,
                    Bnumcolors,
                    Bcompression) then
    MessageDlg('blobfield getinfo failed', mtInformation, [mbOk], 0) else
    begin
         BSize:=Stream.Size;
         if UpperCase(BFileType) = 'GIF' then GetInfoAndType:='GIF' else
         if UpperCase(BFileType) = 'PCX' then GetInfoAndType:='PCX' else
         if UpperCase(BFileType) = 'JPEG' then GetInfoAndType:='JPG' else
         if UpperCase(BFileType) = 'BMP' then GetInfoAndType:='BMP';
    end;
  if Stream.Memory <> nil then Stream.Free;
end;
{------------------------------------------------------------------------}

function TDBMultiImage.GetSmooth : Byte;
begin
  GetSmooth:=FSaveSmooth;
end;
{------------------------------------------------------------------------}

procedure TDBMultiImage.SetSmooth(Smooth : Byte);
begin
  if (Smooth > 100) or (Smooth < 0) then FSaveSmooth:=5 else
   FSaveSmooth:=Smooth;
end;
{------------------------------------------------------------------------}

function TDBMultiImage.GetQuality : Byte;
begin
  GetQuality:=FSaveQuality;
end;
{------------------------------------------------------------------------}

procedure TDBMultiImage.SetQuality(Quality : Byte);
begin
  if (Quality > 100) OR (Quality < 1) then FSaveQuality:=25 else
   FSaveQuality:=Quality;
end;
{------------------------------------------------------------------------}
function TDBMultiImage.GetDither : Byte;
begin
  GetDither:=Fdither
end;
{------------------------------------------------------------------------}

procedure TDBMultiImage.SetDither(dith : Byte);
begin
  Fdither:=4;
  case dith of
            0..4 :Fdither:=dith;
  end;
end;
{------------------------------------------------------------------------}

function TDBMultiImage.GetRes : Byte;
begin
  GetRes:=FResolution;
end;
{------------------------------------------------------------------------}


procedure TDBMultiImage.SetRes(res : Byte);
begin
  FResolution:=8;
  case res of
            4 :FResolution:=res;
            8 :FResolution:=res;
            24:FResolution:=res;
  end;
end;

{------------------------------------------------------------------------
 scrolling message stuff
------------------------------------------------------------------------}

procedure TDBMultiImage.LoadMessageFromStream(MessageStream : TStream);
var
  Msg      : TLabel;
begin
  FreeMsg;
  ScreenWd:=Width;
  ScreenHt:=Height;
  Msg := TLabel.Create(Self);
  readmessagefromstream(MessageStream, MsgFont, MsgSpeed, MsgBkGrnd, MsgText);
  Refresh;
  if MsgText[Length(MsgText)] <> ' ' then MsgText:=MsgText+' ';
  Msg.Parent :=Self;
  Msg.Visible := False;
  Msg.Font := MsgFont;
  Msg.Caption := MsgText;
  BitWidth:=Msg.Width;
  SMessageLeft := ScreenWd;
  SMessageRight := ScreenWd + Msg.Width;
  SMessageTop := (ScreenHt - Msg.Height) Div 2;
  BitMsg.Width := Msg.Width;
  BitMsg.Height := Msg.Height;
  OldColor:=Color;
  Color:=MsgBkGrnd;

  with BitMsg.Canvas do begin
    Brush.Color := MsgBkGrnd;
    Font := Msg.Font;
    TextOut(0,0,Msg.Caption);
  end;

   Msg.Free;
   Msg := nil;
   MessageRunning:=True;
end;
{------------------------------------------------------------------------}

procedure TDBMultiImage.NewMessage;
var
  Msg      : TLabel;
begin
  FreeMsg;
  if MsgText = '' then exit;
  if MsgText[Length(MsgText)] <> ' ' then MsgText:=MsgText+' ';
  ScreenWd:=Width;
  ScreenHt:=Height;
  Msg := TLabel.Create(Self);
  Refresh;
  Msg.Parent :=Self;
  Msg.Visible := False;
  Msg.Font := MsgFont;
  Msg.Caption := MsgText;
  BitWidth:=Msg.Width;
  SMessageLeft := ScreenWd;
  SMessageRight := ScreenWd + Msg.Width;
  SMessageTop := (ScreenHt - Msg.Height) Div 2;
  BitMsg.Width := Msg.Width;
  BitMsg.Height := Msg.Height;
  OldColor:=Color;
  Color:=MsgBkGrnd;

  with BitMsg.Canvas do begin
    Brush.Color := MsgBkGrnd;
    Font := Msg.Font;
    TextOut(0,0,Msg.Caption);
  end;

   Msg.Free;
   Msg := nil;
   MessageRunning:=True;
end;
{------------------------------------------------------------------------}

Function TDBMultiImage.CreateMessage : Boolean;
begin
 Result:=False;
 Application.CreateForm(TSetupMsg, SetupMsg );
 SetupMsg.ShowModal;
 if SetupMsg.ModalResult = mrOK then begin
  Result:=SaveMessageToStream(SetupMsg.MessageFont,
                              SetupMsg.MessageSpeed,
                              SetupMsg.MessageColor,
                              SetupMsg.MessageMsg);
 end;
 SetupMsg.destroy;
 SetupMsg:=Nil;
end;
{------------------------------------------------------------------------}

Procedure TDBMultiImage.FreeMsg;
Begin
  Picture.Assign(nil);
  if MessageRunning then
  Color:=OldColor;
  MessageRunning:=False;
end;
{------------------------------------------------------------------------}

Function TDBMultiImage.Delay(Ms : Integer) : boolean;
Begin
 Inc(DelayCounter);
 if DelayCounter > MS then begin
  DelayCounter:=0;
  Result:=true;
 end else
  Result:=false;
end;
{------------------------------------------------------------------------}

Procedure TDBMultiImage.MoveMsg(Var WinMsg : TMessage);
Begin
  if Not MessageRunning then exit;
  if Not Delay(MsgSpeed)then exit;
  Dec(SMessageLeft,1);
  Dec(SMessageRight,1);
  Inc(MmsgCount,1);
  if SMessageRight < 0 then begin
    SMessageLeft := ScreenWd;
    SMessageRight := SMessageLeft + BitWidth;
  end;
    with Canvas do
       Draw(SMessageLeft,SMessageTop,BitMsg);
end;
{------------------------------------------------------------------------}

Procedure TDBMultiImage.Trigger;
Begin
  if SetupMsg <> nil then SetupMsg.Trigger;
    if (visible) and (enabled) then
   PostMessage(Handle, WM_Trigger, 0, 0);
End;
{------------------------------------------------------------------------}

Function TDBMultiImage.SaveMessageToStream(MFont  : Tfont;
                                           Mspeed : integer;
                                           MColor : Tcolor;
                                           MMsg   : String) : Boolean;
var
   Stream       :  TMemoryStream;
   Cursor       :  hCursor;
   Usize        :  longInt;
   P            :  Array[0..1602] of char;
begin
  Result:=True;
  if FDataLink.Field is TBlobField then begin
     If Length(MMsg) < 1 then
      begin
        Result:=False;
        exit;
       end;

      Usize:=WriteMessageToStream(MFont, MSpeed, MColor, MMsg, P);

      If Usize < 1 then
       begin
        Result:=False;
        exit;
       end;

      Stream:=TMemoryStream.Create;
      Stream.Write(P,Usize+1);

      try
        TBlobField(FDataLink.Field).LoadFromStream(Stream);
      finally
        Stream.Free;
      end;
     GetInfoAndType;
   end;
end;

{------------------------------------------------------------------------
Printing Stuff
------------------------------------------------------------------------}

procedure TDBMultiImage.PrintMultiImage(X, Y, pWidth, pHeight: Integer);
begin
 if Picture.Graphic.Empty then exit;

 if (BFiletype = 'ICO') or (BFiletype = 'WMF') then
   PrintICOWMF(X, Y, pWidth, pHeight)
 else
   PrintBitMap(X, Y, pWidth, pHeight)
end;
{---------------------------------------------------------------------}

procedure TDBMultiImage.PrintBitMap(X, Y, pWidth, pHeight: Integer);
var
  Info     : PBitmapInfo;
  InfoSize : Integer;
  Image    : Pointer;
  ImageSize: Longint;
begin
   if (pWidth < 1) or (pHeight < 1) then begin
      pWidth:=Picture.Bitmap.Width;
      pHeight:=Picture.Bitmap.Height;
   end;

   Printer.Begindoc;

    with Picture.Bitmap do begin
      GetDIBSizes(Handle, InfoSize, ImageSize);
      Info := MemAlloc(InfoSize);
      try
        Image := MemAlloc(ImageSize);
        try
          GetDIB(Handle, Palette, Info^, Image^);
          with Info^.bmiHeader do
           StretchDIBits(Printer.Canvas.Handle, X, Y, pWidth,
            pHeight, 0, 0, biWidth, biHeight, Image, Info^,
            DIB_RGB_COLORS, SRCCOPY)
         finally
          FreeMem(Image, ImageSize);
         end;
      finally
       FreeMem(Info, InfoSize);
      end;
    end;
    Printer.Enddoc;
  end;
{---------------------------------------------------------------------}

procedure TDBMultiImage.PrintICOWMF(X, Y, pWidth, pHeight: Integer);
begin
   if (pWidth < 1) or (pHeight < 1) then begin
    pWidth:=Picture.Graphic.Width;
    pHeight:=Picture.Graphic.Height;
   end;

   Printer.Begindoc;

   Printer.Canvas.StretchDraw(Rect(X, Y, pWidth, pHeight), Picture.Graphic);

   Printer.Enddoc;
end;
{------------------------------------------------------------------------
 end TDBMultiImage
------------------------------------------------------------------------}



{TDBMultiMedia}

constructor TDBMultiMedia.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  ControlStyle := ControlStyle + [csFramed, csOpaque];
  Width := 105;
  Height := 105;
  TabStop := True;
  ParentColor := False;
  FPicture := TPicture.Create;
  FPicture.OnChange := PictureChanged;
  FBorderStyle := bsSingle;
  FAutoDisplay := True;
  FImageLibPalette:=True;
  FCenter := True;
  FUpdateAsJpeg := True;
  Fdither:=4;
  FResolution:=8;
  FSaveQuality:=25;
  FSaveSmooth:=0;
  FDataLink := TFieldDataLink.Create;
  FDataLink.Control := Self;
  FDataLink.OnDataChange := DataChange;
  FDataLink.OnUpdateData := UpdateData;
  FMOVTempFile:='$$$.MOV';
  FMPGTempFile:='$$$.MPG';
  FAVITempFile:='$$$.AVI';
  FWAVTempFile:='$$$.WAV';
  FMIDTempFile:='$$$.MID';
  FRMITempFile:='$$$.RMI';
  FTempFilePath:='C:\';
  MsgFont:=TFont.Create;
  BitMsg := TBitmap.Create;
  MessageRunning:=False;
  SetupMsg:=Nil;
  DelayCounter:=0;
  Color:=clWindow;
  FAutoMMHide := False;
end;
{------------------------------------------------------------------------}

destructor TDBMultiMedia.Destroy;
begin
  CleanUpMultiMedia;
  FPicture.Free;
  FDataLink.Free;
  MsgFont.Free;
  BitMsg.Free;
  FDataLink := nil;
  inherited Destroy;
end;
{------------------------------------------------------------------------}

function TDBMultiMedia.GetDataSource: TDataSource;
begin
  Result := FDataLink.DataSource;
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.SetDataSource(Value: TDataSource);
begin
  FDataLink.DataSource := Value;
end;
{------------------------------------------------------------------------}

function TDBMultiMedia.GetDataField: string;
begin
  Result := FDataLink.FieldName;
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.SetDataField(const Value: string);
begin
  FDataLink.FieldName := Value;
end;
{------------------------------------------------------------------------}

function TDBMultiMedia.GetReadOnly: Boolean;
begin
  Result := FDataLink.ReadOnly;
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.SetReadOnly(Value: Boolean);
begin
  FDataLink.ReadOnly := Value;
end;
{------------------------------------------------------------------------}

function TDBMultiMedia.GetField: TField;
begin
  Result := FDataLink.Field;
end;
{------------------------------------------------------------------------}

function TDBMultiMedia.GetPalette: HPALETTE;
begin
  Result := 0;
  if ImageLibPalette then exit;
  if FPicture.Graphic is TBitmap then
    Result := TBitmap(FPicture.Graphic).Palette;
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.SetAutoDisplay(Value: Boolean);
begin
  if FAutoDisplay <> Value then
  begin
    FAutoDisplay := Value;
    if Value then LoadMedia;
  end;
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.SetBorderStyle(Value: TBorderStyle);
begin
  if FBorderStyle <> Value then
  begin
    FBorderStyle := Value;
    RecreateWnd;
  end;
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.SetCenter(Value: Boolean);
begin
  if FCenter <> Value then
  begin
    FCenter := Value;
    Invalidate;
  end;
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.SetPicture(Value: TPicture);
begin
  FPicture.Assign(Value);
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.SetStretch(Value: Boolean);
begin
  if FStretch <> Value then
  begin
    FStretch := Value;
    Invalidate;
  end;
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.Paint;
var
  W, H        : Integer;
  R           : TRect;
  S           : string[63];
  OldBitmap   : HBitmap;
  MemDC       : HDC;
  hOldPal     : HPalette;
begin

  if (BFileType = 'ICO') or (BFileType = 'WMF') or (not ImageLibPalette) then begin
      PaintTheDelpiWay;
      exit;
  end;

  with Canvas do begin
    Brush.Style := bsSolid;
    Brush.Color := Color;

    if FPictureLoaded then begin
      if (Stretch) and (Picture.Graphic <> nil) then

        if Picture.Graphic.Empty then
          FillRect(ClientRect) else
         begin

            hOldPal := SelectPalette(Canvas.handle,Picture.BitMap.Palette,False);
            RealizePalette(Canvas.handle);

            MemDC := CreateCompatibleDC(Canvas.handle);
            OldBitmap := SelectObject(MemDC,Picture.BitMap.Handle);

            SetStretchBltMode(canvas.handle,STRETCH_DELETESCANS);

            StretchBlt(Canvas.handle,
                       ClientRect.Left,
                       ClientRect.Top,
                       ClientRect.Right,
                       ClientRect.Bottom,
                       MemDC,
                       ClientRect.Left,
                       ClientRect.Top,
                       Picture.BitMap.Width,
                       Picture.BitMap.Height,
                       srcCopy);

             SelectObject(MemDC,OldBitmap);
             DeleteDC(MemDC);
             SelectPalette(Canvas.handle,hOldPal,False);
      end else begin

        SetRect(R, 0, 0, Picture.Width, Picture.Height);
        if Center then OffsetRect(R, (ClientWidth - Picture.Width) div 2,
          (ClientHeight - Picture.Height) div 2);

           hOldPal := SelectPalette(Canvas.handle,Picture.BitMap.Palette,False);
           RealizePalette(Canvas.handle);

           MemDC := CreateCompatibleDC(Canvas.handle);
           OldBitmap := SelectObject(MemDC,Picture.BitMap.Handle);

            BitBlt(Canvas.handle,
                       R.Left,
                       R.Top,
                       Picture.BitMap.Width,
                       Picture.BitMap.Height,
                       MemDC,
                       0,
                       0,
                       srcCopy);

             SelectObject(MemDC,OldBitmap);
             DeleteDC(MemDC);
             SelectPalette(Canvas.handle,hOldPal,False);

             ExcludeClipRect(Handle, R.Left, R.Top, R.Right, R.Bottom);
             FillRect(ClientRect);
             SelectClipRgn(Handle, 0);
      end;
    end else begin
     Font := Self.Font;
     if FDataLink.Field <> nil then
        S := FDataLink.Field.DisplayLabel
     else
        S := Name;
      S := '(' + S + ')';
      W := TextWidth(S);
      H := TextHeight(S);
      R := ClientRect;
      TextRect(R, (R.Right - W) div 2, (R.Bottom - H) div 2, S);
    end;

    if (GetParentForm(Self).ActiveControl = Self) and
      not (csDesigning in ComponentState) then begin
        Brush.Color := clWindowFrame;
        FrameRect(ClientRect);
    end;

  end;

  if (MessageRunning) and (Picture = nil) then FreeMsg;
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.PaintTheDelpiWay;
var
  W, H: Integer;
  R: TRect;
  S: string[63];
begin
  with Canvas do
  begin
    Brush.Style := bsSolid;
    Brush.Color := Color;
    if FPictureLoaded then
    begin
      if (Stretch) and (Picture.Graphic <> nil) then
        if Picture.Graphic.Empty then
          FillRect(ClientRect) else
          StretchDraw(ClientRect, Picture.Graphic)
      else
      begin
        SetRect(R, 0, 0, Picture.Width, Picture.Height);
        if Center then OffsetRect(R, (ClientWidth - Picture.Width) div 2,
          (ClientHeight - Picture.Height) div 2);
        StretchDraw(R, Picture.Graphic);
        ExcludeClipRect(Handle, R.Left, R.Top, R.Right, R.Bottom);
        FillRect(ClientRect);
        SelectClipRgn(Handle, 0);
      end;
    end else
    begin
      Font := Self.Font;
      if FDataLink.Field <> nil then
        S := FDataLink.Field.DisplayLabel else
        S := Name;
      S := '(' + S + ')';
      W := TextWidth(S);
      H := TextHeight(S);
      R := ClientRect;
      TextRect(R, (R.Right - W) div 2, (R.Bottom - H) div 2, S);
    end;
    if (GetParentForm(Self).ActiveControl = Self) and
      not (csDesigning in ComponentState) then
    begin
      Brush.Color := clWindowFrame;
      FrameRect(ClientRect);
    end;
  end;
  if (MessageRunning) and (Picture = nil) then FreeMsg;
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.PictureChanged(Sender: TObject);
begin
  FDataLink.Modified;
  FPictureLoaded := True;
  Invalidate;
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) and (FDataLink <> nil) and
    (AComponent = DataSource) then DataSource := nil;

  if (Operation = opRemove) and
    (AComponent = FMediaPlayer) then FMediaPlayer := nil;
end;
{------------------------------------------------------------------------}

Procedure TDBMultiMedia.CleanUpMultiMedia;
begin
   if (csDesigning in ComponentState) then exit;
   deletefile(FTempFilePath+FMPGTempFile);
   deletefile(FTempFilePath+FMOVTempFile);
   deletefile(FTempFilePath+FAVITempFile);
   deletefile(FTempFilePath+FWAVTempFile);
   deletefile(FTempFilePath+FMIDTempFile);
   deletefile(FTempFilePath+FRMITempFile);
end;


procedure TDBMultiMedia.LoadMedia;
var
   Stream       :  TMemoryStream;
   BitMap       :  TBitMap;
   Cursor       :  hCursor;
   Temp         :  string;
begin
  if not FPictureLoaded and (FDataLink.Field is TBlobField) then begin

   if TBlobField(FDataLink.Field).IsNull then exit;

   Temp:=GetInfoAndType;

   if FMediaPlayer <> nil then
     FMediaPlayer.Close;

   CleanUpMultiMedia;


  if Temp = 'SCM' then begin
      Stream:=TMemoryStream.Create;
      try
       if FMediaPlayer <> nil then
         if FAutoMMHide then
           FMediaPlayer.Visible:=False;
         Cursor := SetCursor(LoadCursor(0,idc_Wait));
         FreeMsg;
         TBlobField(FDataLink.Field).SaveToStream(Stream);
         LoadMessageFromStream(Stream);
         KillTimer(handle,1);
         if @TDBMultiMediaCallBack <> nil then
           TDBMultiMediaCallBack(0);
       finally
         SetCursor(Cursor);
         Stream.Free;
       end;
   end else

  if Temp = 'MPG' then begin
         try
            if (csDesigning in ComponentState) then exit;

            if not IsValidMultiMedia('MPG') then exit;
              Cursor := SetCursor(LoadCursor(0,idc_Wait));
              FreeMsg;
              if FMediaPlayer <> nil then begin
               FMediaPlayer.Visible:=true;
               TBlobField(FDataLink.Field).SaveToFile(FTempFilePath+FMPGTempFile);
               FMediaPlayer.FileName:=FTempFilePath+FMPGTempFile;
               FMediaPlayer.Open;
               if FAutoPlayMM then
                 FMediaPlayer.Play;
               SetTimer(handle,1,500,nil);
            end;
         finally
            SetCursor(Cursor);
         end;
   end else

   if Temp = 'MOV' then begin
         try
            if (csDesigning in ComponentState) then exit;

            if not IsValidMultiMedia('MOV') then exit;
              Cursor := SetCursor(LoadCursor(0,idc_Wait));
              FreeMsg;
              if FMediaPlayer <> nil then begin
               FMediaPlayer.Visible:=true;
               TBlobField(FDataLink.Field).SaveToFile(FTempFilePath+FMOVTempFile);
               FMediaPlayer.FileName:=FTempFilePath+FMOVTempFile;
               FMediaPlayer.Open;
               if FAutoPlayMM then
                 FMediaPlayer.Play;
               SetTimer(handle,1,500,nil);
            end;
         finally
            SetCursor(Cursor);
         end;
   end else

   if Temp = 'AVI' then begin
         try
            if (csDesigning in ComponentState) then exit;

            if not IsValidMultiMedia('AVI') then exit;
              Cursor := SetCursor(LoadCursor(0,idc_Wait));
              FreeMsg;
              if FMediaPlayer <> nil then begin
               FMediaPlayer.Visible:=true;
               TBlobField(FDataLink.Field).SaveToFile(FTempFilePath+FAVITempFile);
               FMediaPlayer.FileName:=FTempFilePath+FAVITempFile;
               FMediaPlayer.Open;
               if FAutoPlayMM then
                 FMediaPlayer.Play;
               SetTimer(handle,1,500,nil);
            end;
         finally
            SetCursor(Cursor);
         end;
   end else

   if Temp = 'WAV' then begin
         try
            if (csDesigning in ComponentState) then exit;

            if not IsValidMultiMedia('WAV') then exit;
             Cursor := SetCursor(LoadCursor(0,idc_Wait));
             FreeMsg;
             if FMediaPlayer <> nil then begin
               FMediaPlayer.Visible:=true;
               TBlobField(FDataLink.Field).SaveToFile(FTempFilePath+FWAVTempFile);
               FMediaPlayer.FileName:=FTempFilePath+FWAVTempFile;
               FMediaPlayer.Open;
               if FAutoPlayMM then
                 FMediaPlayer.Play;
               SetTimer(handle,1,500,nil);
            end;
         finally
            SetCursor(Cursor);
         end;
   end else

   if Temp = 'MID' then begin
         try
            if (csDesigning in ComponentState) then exit;

            if not IsValidMultiMedia('MID') then exit;
             Cursor := SetCursor(LoadCursor(0,idc_Wait));
             FreeMsg;
             if FMediaPlayer <> nil then begin
               FMediaPlayer.Visible:=true;
               TBlobField(FDataLink.Field).SaveToFile(FTempFilePath+FMIDTempFile);
               FMediaPlayer.FileName:=FTempFilePath+FMIDTempFile;
               FMediaPlayer.Open;
               if FAutoPlayMM then
                 FMediaPlayer.Play;
               SetTimer(handle,1,500,nil);
            end;
         finally
            SetCursor(Cursor);
         end;
   end else

   if Temp = 'RMI' then begin
         try
            if (csDesigning in ComponentState) then exit;

            if not IsValidMultiMedia('RMI') then exit;
            Cursor := SetCursor(LoadCursor(0,idc_Wait));
            FreeMsg;
            if FMediaPlayer <> nil then begin
               FMediaPlayer.Visible:=true;
               TBlobField(FDataLink.Field).SaveToFile(FTempFilePath+FRMITempFile);
               FMediaPlayer.FileName:=FTempFilePath+FRMITempFile;
               FMediaPlayer.Open;
               if FAutoPlayMM then
                 FMediaPlayer.Play;
               SetTimer(handle,1,500,nil);
            end;
         finally
            SetCursor(Cursor);
         end;
   end else

   if Temp = 'GIF' then begin
      Stream:=TMemoryStream.Create;
      BitMap:=TBitMap.Create;
      try
       if FMediaPlayer <> nil then
         if FAutoMMHide then
           FMediaPlayer.Visible:=False;
         KillTimer(handle,1);
         Cursor := SetCursor(LoadCursor(0,idc_Wait));
         FreeMsg;
         TBlobField(FDataLink.Field).SaveToStream(Stream);
         if not gifblob(Stream.Memory,Stream.Size, Bitmap, TDBMultiMediaCallBack) then begin
            MessageDlg('Invallid or empty GIF blobfield', mtInformation, [mbOk], 0);
            Picture.Assign(Nil);
         end else
            Picture.Assign(BitMap);
         finally
            SetCursor(Cursor);
            BitMap.free;
            Stream.Free;
         end;
   end else

   if Temp = 'PCX' then begin
      Stream:=TMemoryStream.Create;
      BitMap:=TBitMap.Create;
      try
       if FMediaPlayer <> nil then
         if FAutoMMHide then
           FMediaPlayer.Visible:=False;
         KillTimer(handle,1);
         Cursor := SetCursor(LoadCursor(0,idc_Wait));
         FreeMsg;
         TBlobField(FDataLink.Field).SaveToStream(Stream);
         if not pcxblob(Stream.Memory,Stream.Size, Bitmap, TDBMultiMediaCallBack) then begin
            MessageDlg('Invallid or empty PCX blobfield', mtInformation, [mbOk], 0);
            Picture.Assign(Nil);
         end else
            Picture.Assign(BitMap);
         finally
          SetCursor(Cursor);
          BitMap.free;
          Stream.Free;
         end;
   end else

   if Temp = 'BMP' then begin
      Stream:=TMemoryStream.Create;
      BitMap:=TBitMap.Create;
      try
       if FMediaPlayer <> nil then
         if FAutoMMHide then
           FMediaPlayer.Visible:=False;
         KillTimer(handle,1);
         Cursor := SetCursor(LoadCursor(0,idc_Wait));
         FreeMsg;
         TBlobField(FDataLink.Field).SaveToStream(Stream);
         if not bmpblob(Stream.Memory,Stream.Size, Bitmap, TDBMultiMediaCallBack) then begin
            MessageDlg('Invallid or empty BMP blobfield', mtInformation, [mbOk], 0);
            Picture.Assign(Nil);
         end else
            Picture.Assign(BitMap);
         finally
          SetCursor(Cursor);
          BitMap.free;
          Stream.Free;
         end;
   end else

   if Temp = 'JPG' then begin
      Stream:=TMemoryStream.Create;
      BitMap:=TBitMap.Create;
      if FResolution <> 4 then
      if FResolution <> 8 then
      if FResolution <> 24 then FResolution:=8;
      if (FDither < 0) or (FDither > 4) then FDither:=4;
      try
       if FMediaPlayer <> nil then
         if FAutoMMHide then
           FMediaPlayer.Visible:=False;
         KillTimer(handle,1);
         Cursor := SetCursor(LoadCursor(0,idc_Wait));
         FreeMsg;
         TBlobField(FDataLink.Field).SaveToStream(Stream);
         if not jpgblob(Stream.Memory,Stream.Size, FResolution, Fdither, Bitmap, TDBMultiMediaCallBack) then begin
            MessageDlg('Invallid or empty Jpeg Blobfield', mtInformation, [mbOk], 0);
            Picture.Assign(Nil);
         end else
             Picture.Assign(BitMap);
         finally
             SetCursor(Cursor);
             BitMap.free;
             Stream.Free;
         end;
    end else
     KillTimer(handle,1);
    {GetInfoAndType;}
 end;
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.DataChange(Sender: TObject);
begin
  If MessageRunning then FreeMsg;
  Picture.Graphic := nil;
  FPictureLoaded := False;
  if FAutoDisplay then LoadMedia;
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.UpdateData(Sender: TObject);
var
   Stream       :  TMemoryStream;
   Cursor       :  hCursor;
   Usize        :  longInt;
   x,y          :  longInt;
   p            :  Pointer;
begin
  if FDataLink.Field is TBlobField then begin

    if Picture.Graphic is TBitmap then begin
      x:=Picture.BitMap.Width;
      y:=Picture.BitMap.Height;

      y:=y+(y div 5);
      x:=x+(x div 5);

      Usize:=(y * x);

      if Usize < 90000 then Usize:=Usize*2;

      {Since we can't know how much memory we need to allocate
      to write the picture to the stream we need to guess it. This
      is done using the width and height of the bitmap. After the call
      to the dll using PUTJPGBLOB or PUTBMPBLOB Usize contains the
      correct size of the Bitmap stored in P^. You can increase or decrease
      the guessed memory by altering the Div by. For instance

      y:=y+(y div 3);
      x:=x+(x div 3);

      will allocate more memory then

      y:=y+(y div 6);
      x:=x+(x div 6);

      We played it on the save side. Use this "guess work" very carefully}


      P := GlobalAllocPtr(HeapAllocFlags, Usize);
      if P = Nil then
        exit;

      if FUpdateAsJpeg then begin
         if not putjpgblob(P, USize, FSaveQuality, FSaveSmooth, Picture.Bitmap, TDBMultiMediaCallBack) then
           MessageDlg('Jpeg BLOB Write Error', mtInformation, [mbOk], 0);
      end else begin
         if not putbmpblob(P, USize, Picture.Bitmap, TDBMultiMediaCallBack) then
           MessageDlg('BMP BLOB Write Error', mtInformation, [mbOk], 0);
      end;

      Stream:=TMemoryStream.Create;
      Stream.Write(P^,USize);
      GlobalFreePtr(P);

      try
        TBlobField(FDataLink.Field).LoadFromStream(Stream);
      finally
        Stream.Free;
      end;

    end else
      TBlobField(FDataLink.Field).Clear;
   end;
   GetInfoAndType;
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.CopyToClipboard;
begin
  if Picture.Graphic <> nil then Clipboard.Assign(Picture);
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.CutToClipboard;
begin
  if Picture.Graphic <> nil then
  begin
    CopyToClipboard;
    if FDataLink.Edit then
      Picture.Graphic := nil;
  end;
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.PasteFromClipboard;
begin
  if Clipboard.HasFormat(CF_PICTURE) and FDataLink.Edit then begin
    MessageRunning:=False;
    Picture.Assign(Clipboard);
   end;
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  if FBorderStyle = bsSingle then
    Params.Style := Params.Style or WS_BORDER;
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.KeyDown(var Key: Word; Shift: TShiftState);
begin
  inherited KeyDown(Key, Shift);
  case Key of
    VK_INSERT:
      if ssShift in Shift then PasteFromClipBoard else
        if ssCtrl in Shift then CopyToClipBoard;
    VK_DELETE:
      if ssShift in Shift then CutToClipBoard;
  end;
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.KeyPress(var Key: Char);
begin
  inherited KeyPress(Key);
  case Key of
    ^X: CutToClipBoard;
    ^C: CopyToClipBoard;
    ^V: PasteFromClipBoard;
    #13: LoadMedia;
    #27: FDataLink.Reset;
  end;
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.CMEnter(var Message: TCMEnter);
begin
  Invalidate; { Draw the focus marker }
  inherited;
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.CMExit(var Message: TCMExit);
begin
  Invalidate; { Erase the focus marker }
  inherited;
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.CMTextChanged(var Message: TMessage);
begin
  inherited;
  if not FPictureLoaded then Invalidate;
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.WMLButtonDown(var Message: TWMLButtonDown);
begin
  if TabStop and CanFocus then SetFocus;
  inherited;
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.WMLButtonDblClk(var Message: TWMLButtonDblClk);
begin
  LoadMedia;
  inherited;
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.WMCut(var Message: TMessage);
begin
  CutToClipboard;
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.WMCopy(var Message: TMessage);
begin
  CopyToClipboard;
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.WMPaste(var Message: TMessage);
begin
  PasteFromClipboard;
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.LoadFromFile(filename : TFilename);
var
   Cursor       :  hCursor;
begin

  if not FileExists(filename) then begin
    MessageDlg('File not found', mtInformation, [mbOk], 0);
    exit;
  end;

  if UpperCase(ExtractFileExt(filename)) <> '.JPG' then
  if UpperCase(ExtractFileExt(filename)) <> '.GIF' then
  if UpperCase(ExtractFileExt(filename)) <> '.PCX' then
  if UpperCase(ExtractFileExt(filename)) <> '.BMP' then
  if UpperCase(ExtractFileExt(filename)) <> '.WAV' then
  if UpperCase(ExtractFileExt(filename)) <> '.AVI' then
  if UpperCase(ExtractFileExt(filename)) <> '.MOV' then
  if UpperCase(ExtractFileExt(filename)) <> '.MID' then
  if UpperCase(ExtractFileExt(filename)) <> '.RMI' then
  if UpperCase(ExtractFileExt(filename)) <> '.SCM' then
  {if UpperCase(ExtractFileExt(filename)) <> '.MPG' then}
  begin
    MessageDlg('A None Supported File Format', mtInformation, [mbOk], 0);
    exit;
  end;

  if FDataLink.Field is TBlobField then begin
    Cursor := SetCursor(LoadCursor(0,idc_Wait));
    TBlobField(FDataLink.Field).LoadFromFile(filename);
    SetCursor(Cursor);
  end else begin
    MessageDlg('Field is not a blobfield', mtInformation, [mbOk], 0);
    exit;
  end;
  {GetInfoAndType;}
  SetCursor(Cursor);
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.SaveToFile(filename : TFilename);
var
  Cursor       :  hCursor;
begin
  if FDataLink.Field is TBlobField then begin

    if TBlobField(FDataLink.Field).IsNull then begin
       MessageDlg('Can''t save, blobfield is empty', mtInformation, [mbOk], 0);
       exit;
    end;

    Cursor := SetCursor(LoadCursor(0,idc_Wait));
    TBlobField(FDataLink.Field).SaveToFile(filename);
    GetInfoAndType;
    SetCursor(Cursor)

  end else begin
    MessageDlg('Field is not a blobfield', mtInformation, [mbOk], 0);
    exit;
  end;
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.SaveToFileAsBMP(filename : TFilename);
var
  Cursor       :  hCursor;
begin
  if FDataLink.Field is TBlobField then begin

    if TBlobField(FDataLink.Field).IsNull then begin
       MessageDlg('Can''t save, blobfield bitmap is empty', mtInformation, [mbOk], 0);
       exit;
    end;

    if picture.bitmap.empty then begin
       MessageDlg('Can''t save, image is not displayed, Set Autodisplay or double click display to view image first.',
                  mtInformation, [mbOk], 0);
       exit;
    end;

    Cursor := SetCursor(LoadCursor(0,idc_Wait));

    if not putbmpfile(FileName, picture.Bitmap, TDBMultiMediaCallBack) then begin
      SetCursor(Cursor);
      MessageDlg('Writing bmp file failed', mtInformation, [mbOk], 0);
      exit;
    end;

    GetInfoAndType

  end else begin
    SetCursor(Cursor);
    MessageDlg('Field is not a blobfield', mtInformation, [mbOk], 0);
    exit;
  end;

  SetCursor(Cursor);
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.SaveToFileAsJpeg(filename : TFilename);
var
  Cursor       :  hCursor;
begin
  if FDataLink.Field is TBlobField then begin

    if TBlobField(FDataLink.Field).IsNull then begin
       MessageDlg('Can''t save, blobfield bitmap is empty', mtInformation, [mbOk], 0);
       exit;
    end;

    if picture.bitmap = nil then begin
       MessageDlg('Can''t save, image is not displayed, Set Autodisplay or double click display to view image first.',
                  mtInformation, [mbOk], 0);
       exit;
    end;

    Cursor := SetCursor(LoadCursor(0,idc_Wait));

    if not putjpgfile(FileName, FSaveQuality, FSaveSmooth, picture.Bitmap, TDBMultiMediaCallBack) then begin
      SetCursor(Cursor);
      MessageDlg('Writing jpg file failed', mtInformation, [mbOk], 0);
      exit;
    end;

    GetInfoAndType

  end else begin
    SetCursor(Cursor);
    MessageDlg('Field is not a blobfield', mtInformation, [mbOk], 0);
    exit;
  end;

  SetCursor(Cursor);
end;
{------------------------------------------------------------------------}


function TDBMultiMedia.GetInfoAndType : String;
var
 Stream       :  TMemoryStream;
 Hdr          :  Array[0..45] of char;
 i            :  Byte;
begin
  if (FDataLink.Field is TBlobField) then
   if TBlobField(FDataLink.Field).IsNull then exit;

   BFileType := 'Empty';
   Bwidth:=-1;
   BHeight:=-1;
   Bbitspixel:=-1;
   Bplanes:=-1;
   Bnumcolors:=-1;
   Bcompression:='-1';
   BSize:=-1;
   GetInfoAndType :='-1';

   Stream:=TMemoryStream.Create;
   TBlobField(FDataLink.Field).SaveToStream(Stream);

   if Stream.Memory = nil then begin
     MessageDlg('Error allocation temporary blob memory', mtInformation, [mbOk], 0);
     exit;
   end;

   Stream.Seek(0,0);
   Stream.read(hdr,SizeOf(Hdr)-1);

   for i:=0 to SizeOf(hdr)-1 do
    if hdr[i] = #0 then hdr[i]:=' ';

   if StrPos(hdr,'RIFF') <> nil then begin
        Bwidth:=-1;
        BHeight:=-1;
        Bbitspixel:=-1;
        Bplanes:=-1;
        Bnumcolors:=-1;
        Bcompression:='RIFF';

     if StrPos(hdr,'WAV') <> nil then begin
        BSize:=Stream.Size;
        BFileType:= 'WAV';
        GetInfoAndType:='WAV';
     end;

     if StrPos(hdr,'AVI') <> nil then begin
        BSize:=Stream.Size;
        BFileType:= 'AVI';
        GetInfoAndType:='AVI';
     end;

     if StrPos(hdr,'RMID') <> nil then begin
        BSize:=Stream.Size;
        BFileType:= 'RMI';
        GetInfoAndType:='RMI';
     end;

     if Stream.Memory <> nil then Stream.Free;
     exit;
   end else

{   if StrPos(hdr,'mpeg') <> nil then begin
        Bwidth:=-1;
        BHeight:=-1;
        Bbitspixel:=-1;
        Bplanes:=-1;
        Bnumcolors:=-1;
        Bcompression:='MPEG';
        BSize:=Stream.Size;
        BFileType:= 'MPG';
        GetInfoAndType:='MPG';
        if Stream.Memory <> nil then Stream.Free;
        exit;
   end else}

   if StrPos(hdr,'mdat') <> nil then begin
        Bwidth:=-1;
        BHeight:=-1;
        Bbitspixel:=-1;
        Bplanes:=-1;
        Bnumcolors:=-1;
        Bcompression:='QTM';
        BSize:=Stream.Size;
        BFileType:= 'MOV';
        GetInfoAndType:='MOV';
        if Stream.Memory <> nil then Stream.Free;
        exit;
   end else

   if StrPos(hdr,'MThd') <> nil then begin
        Bwidth:=-1;
        BHeight:=-1;
        Bbitspixel:=-1;
        Bplanes:=-1;
        Bnumcolors:=-1;
        Bcompression:='MIDI';
        BSize:=Stream.Size;
        BFileType:= 'MID';
        GetInfoAndType:='MID';
        if Stream.Memory <> nil then Stream.Free;
        exit;
     end else

   if StrPos(hdr,'kevinjan') <> nil then begin
        Bwidth:=-1;
        BHeight:=-1;
        Bbitspixel:=-1;
        Bplanes:=-1;
        Bnumcolors:=-1;
        Bcompression:='MSG';
        BSize:=Stream.Size;
        BFileType:= 'SCM';
        GetInfoAndType:='SCM';
        if Stream.Memory <> nil then Stream.Free;
        exit;
     end else

 if not GetBlobInfo(Stream.Memory,
                    Stream.Size,
                    BFileType,
                    Bwidth,
                    BHeight,
                    Bbitspixel,
                    Bplanes,
                    Bnumcolors,
                    Bcompression) then
       MessageDlg('blobfield getinfo failed', mtInformation, [mbOk], 0)
    else begin
       BSize:=Stream.Size;
       if UpperCase(BFileType) = 'GIF' then GetInfoAndType:='GIF' else
       if UpperCase(BFileType) = 'PCX' then GetInfoAndType:='PCX' else
       if UpperCase(BFileType) = 'JPEG' then GetInfoAndType:='JPG' else
       if UpperCase(BFileType) = 'BMP' then GetInfoAndType:='BMP';
    end;
  if Stream.Memory <> nil then Stream.Free;
end;
{------------------------------------------------------------------------}

function TDBMultiMedia.GetSmooth : Byte;
begin
  GetSmooth:=FSaveSmooth;
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.SetSmooth(Smooth : Byte);
begin
  if (Smooth > 100) or (Smooth < 0) then FSaveSmooth:=5 else
   FSaveSmooth:=Smooth;
end;
{------------------------------------------------------------------------}

function TDBMultiMedia.GetQuality : Byte;
begin
  GetQuality:=FSaveQuality;
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.SetQuality(Quality : Byte);
begin
  if (Quality > 100) or (Quality < 1) then FSaveQuality:=25 else
   FSaveQuality:=Quality;
end;
{------------------------------------------------------------------------}

function TDBMultiMedia.GetDither : Byte;
begin
  GetDither:=Fdither
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.SetDither(dith : Byte);
begin
  Fdither:=4;
  case dith of
            0..4 :Fdither:=dith;
  end;
end;
{------------------------------------------------------------------------}

function TDBMultiMedia.GetRes : Byte;
begin
  GetRes:=FResolution;
end;
{------------------------------------------------------------------------}

function TDBMultiMedia.GetTempPath : String;
begin
  GetTempPath:=FTempFilePath;
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.SetTempPath(temppath : string);
var
 temp, OldDir : string;
begin
  temp:=AddBackSlash(TempPath);
  GetDir(0,OldDir);

  {$I-}
   ChDir(temp);
   if IOResult <> 0 then temp:='C:\';
  {$I+}

  (*try ChDir(temp); except temp:='C:\'; end;*)
  ChDir(OldDir);
  FTempFilePath:=temp;
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.SetRes(res : Byte);
begin
  FResolution:=8;
  case res of
            4 :FResolution:=res;
            8 :FResolution:=res;
            24:FResolution:=res;
  end;
end;
{------------------------------------------------------------------------}

function TDBMultiMedia.GetMediaPlayer: TDBMediaPlayer;
begin
 Result:=FMediaPlayer;
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.SetMediaPlayer(Value: TDBMediaPlayer);
begin
  FMediaPlayer:=Value;
end;
{------------------------------------------------------------------------}

function TDBMultiMedia.AddBackSlash(DirName : string) : string;
const
  DosDelimSet : set of Char = ['\', ':', #0];
  begin
    if DirName[Length(DirName)] in DosDelimSet then
      AddBackSlash := DirName
    else
      AddBackSlash := DirName+'\';
  end;
{------------------------------------------------------------------------}

function TDBMultiMedia.IsValidMultiMedia(Name : PChar) : boolean;
 var
  temp : Array[0..25] of char;
begin
   Result:=ValidMultiMedia(Name);
end;
{------------------------------------------------------------------------}

function TDBMultiMedia.GetMultiMediaExtensions : String;
var
  temp : string;
begin
  temp:='All MultiMedia|*.bmp;*.gif;*.pcx;*.jpg;*.scm;';

  if IsValidMultiMedia('wav') then
    temp:=temp+'*.wav;';
  if IsValidMultiMedia('mid') then
    temp:=temp+'*.mid;';
  if IsValidMultiMedia('rmi') then
    temp:=temp+'*.rmi;';
  if IsValidMultiMedia('avi') then
    temp:=temp+'*.avi;';
  if IsValidMultiMedia('mov') then
    temp:=temp+'*.mov;';
 {if IsValidMultiMedia('mgp') then
    temp:=temp+'*.mpg;';}

  temp:=temp+'|BMP Files|*.bmp';
  temp:=temp+'|GIF Files|*.gif';
  temp:=temp+'|JPG Files|*.jpg';
  temp:=temp+'|PCX Files|*.pcx';
  temp:=temp+'|SCM Files|*.scm';

  if IsValidMultiMedia('wav') then
    temp:=temp+'|Wave Files|*.wav';
  if IsValidMultiMedia('mid') then
    temp:=temp+'|Midi Files|*.mid';
  if IsValidMultiMedia('rmi') then
    temp:=temp+'|RMI Files|*.rmi';
  if IsValidMultiMedia('avi') then
    temp:=temp+'|AVI Files|*.avi';
  if IsValidMultiMedia('mov') then
    temp:=temp+'|Movie Files|*.mov';
  {if IsValidMultiMedia('mgp') then
   temp:=temp+'|Mpeg Files|*.mpg';}

  Result:=temp;
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.TimerNotify(var Message: TMessage);
var
  MPosition : integer;
begin
 if FMediaPlayer = nil then exit;

 if not AutoRePlayMultiMedia then
   if FMediaPlayer.Mode <> MpPlaying then exit;

  MPosition:=Round(FMediaPlayer.Position * (100 / FMediaPlayer.length));

  if @TDBMultiMediaCallBack <> nil then
   TDBMultiMediaCallBack(MPosition);

  if (FAutoRePlayMM) and (MPosition >= 100) and (FMediaPlayer.FileName <> '') then
   FMediaPlayer.Play;

end;
{------------------------------------------------------------------------
 scrolling message stuff
------------------------------------------------------------------------}

procedure TDBMultiMedia.LoadMessageFromStream(MessageStream : TStream);
var
  Msg      : TLabel;
begin
  FreeMsg;
  ScreenWd:=Width;
  ScreenHt:=Height;
  Msg := TLabel.Create(Self);
  readmessagefromstream(MessageStream, MsgFont, MsgSpeed, MsgBkGrnd, MsgText);
  Refresh;
  if MsgText[Length(MsgText)] <> ' ' then MsgText:=MsgText+' ';
  Msg.Parent :=Self;
  Msg.Visible := False;
  Msg.Font := MsgFont;
  Msg.Caption := MsgText;
  BitWidth:=Msg.Width;
  SMessageLeft := ScreenWd;
  SMessageRight := ScreenWd + Msg.Width;
  SMessageTop := (ScreenHt - Msg.Height) Div 2;
  BitMsg.Width := Msg.Width;
  BitMsg.Height := Msg.Height;
  OldColor:=Color;
  Color:=MsgBkGrnd;

  with BitMsg.Canvas do begin
    Brush.Color := MsgBkGrnd;
    Font := Msg.Font;
    TextOut(0,0,Msg.Caption);
  end;

   Msg.Free;
   Msg := nil;
   MessageRunning:=True;
end;
{------------------------------------------------------------------------}

procedure TDBMultiMedia.NewMessage;
var
  Msg      : TLabel;
begin
  FreeMsg;
  if MsgText = '' then exit;
  if MsgText[Length(MsgText)] <> ' ' then MsgText:=MsgText+' ';
  ScreenWd:=Width;
  ScreenHt:=Height;
  Msg := TLabel.Create(Self);
  Refresh;
  Msg.Parent :=Self;
  Msg.Visible := False;
  Msg.Font := MsgFont;
  Msg.Caption := MsgText;
  BitWidth:=Msg.Width;
  SMessageLeft := ScreenWd;
  SMessageRight := ScreenWd + Msg.Width;
  SMessageTop := (ScreenHt - Msg.Height) Div 2;
  BitMsg.Width := Msg.Width;
  BitMsg.Height := Msg.Height;
  OldColor:=Color;
  Color:=MsgBkGrnd;

  with BitMsg.Canvas do begin
    Brush.Color := MsgBkGrnd;
    Font := Msg.Font;
    TextOut(0,0,Msg.Caption);
  end;

   Msg.Free;
   Msg := nil;
   MessageRunning:=True;
end;
{------------------------------------------------------------------------}

Function TDBMultiMedia.CreateMessage : Boolean;
begin
 Result:=False;

 Application.CreateForm(TSetupMsg, SetupMsg );

 SetupMsg.ShowModal;

 if SetupMsg.ModalResult = mrOK then begin
  Result:=SaveMessageToStream(SetupMsg.MessageFont,
                              SetupMsg.MessageSpeed,
                              SetupMsg.MessageColor,
                              SetupMsg.MessageMsg);
 end;
 SetupMsg.destroy;
 SetupMsg:=Nil;
end;
{------------------------------------------------------------------------}

Procedure TDBMultiMedia.FreeMsg;
Begin
  Picture.Assign(nil);
  if MessageRunning then
  Color:=OldColor;
  MessageRunning:=False;
end;
{------------------------------------------------------------------------}

Function TDBMultiMedia.Delay(Ms : Integer) : boolean;
Begin
 Inc(DelayCounter);
 if DelayCounter > MS then begin
  DelayCounter:=0;
  Result:=true;
 end else
  Result:=false;
end;
{------------------------------------------------------------------------}

Procedure TDBMultiMedia.MoveMsg(Var WinMsg : TMessage);
Begin
  if Not MessageRunning then exit;
  if Not Delay(MsgSpeed)then exit;
  Dec(SMessageLeft,1);
  Dec(SMessageRight,1);
  Inc(MmsgCount,1);
  if SMessageRight < 0 then begin
    SMessageLeft := ScreenWd;
    SMessageRight := SMessageLeft + BitWidth;
  end;
    with Canvas do
       Draw(SMessageLeft,SMessageTop,BitMsg);
end;
{------------------------------------------------------------------------}

Procedure TDBMultiMedia.Trigger;
Begin
  if SetupMsg <> nil then SetupMsg.Trigger;
  if (visible) and (enabled) then
   PostMessage(Handle, WM_Trigger, 0, 0);
End;
{------------------------------------------------------------------------}

Function TDBMultiMedia.SaveMessageToStream(MFont  : Tfont;
                                           Mspeed : integer;
                                           MColor : Tcolor;
                                           MMsg   : String) : Boolean;
var
   Stream       :  TMemoryStream;
   Cursor       :  hCursor;
   Usize        :  longInt;
   P            :  Array[0..1602] of char;
begin
  Result:=True;
  if FDataLink.Field is TBlobField then begin
     If Length(MMsg) < 1 then
      begin
        Result:=False;
        exit;
       end;

      Usize:=WriteMessageToStream(MFont, MSpeed, MColor, MMsg, P);

      If Usize < 1 then
       begin
        Result:=False;
        exit;
       end;

      Stream:=TMemoryStream.Create;
      Stream.Write(P,Usize+1);

      try
        TBlobField(FDataLink.Field).LoadFromStream(Stream);
      finally
        Stream.Free;
      end;
     GetInfoAndType;
   end;
end;

{------------------------------------------------------------------------
Printing Stuff
------------------------------------------------------------------------}

procedure TDBMultiMedia.PrintMultiImage(X, Y, pWidth, pHeight: Integer);
begin
 if Picture.Graphic.Empty then exit;

 if (BFiletype = 'ICO') or (BFiletype = 'WMF') then
   PrintICOWMF(X, Y, pWidth, pHeight)
 else
   PrintBitMap(X, Y, pWidth, pHeight)
end;
{---------------------------------------------------------------------}

procedure TDBMultiMedia.PrintBitMap(X, Y, pWidth, pHeight: Integer);
var
  Info     : PBitmapInfo;
  InfoSize : Integer;
  Image    : Pointer;
  ImageSize: Longint;
begin
   if (pWidth < 1) or (pHeight < 1) then begin
      pWidth:=Picture.Bitmap.Width;
      pHeight:=Picture.Bitmap.Height;
   end;

   Printer.Begindoc;

    with Picture.Bitmap do begin
      GetDIBSizes(Handle, InfoSize, ImageSize);
      Info := MemAlloc(InfoSize);
      try
        Image := MemAlloc(ImageSize);
        try
          GetDIB(Handle, Palette, Info^, Image^);
          with Info^.bmiHeader do
           StretchDIBits(Printer.Canvas.Handle, X, Y, pWidth,
            pHeight, 0, 0, biWidth, biHeight, Image, Info^,
            DIB_RGB_COLORS, SRCCOPY)
         finally
          FreeMem(Image, ImageSize);
         end;
      finally
       FreeMem(Info, InfoSize);
      end;
    end;
    Printer.Enddoc;
  end;
{---------------------------------------------------------------------}

procedure TDBMultiMedia.PrintICOWMF(X, Y, pWidth, pHeight: Integer);
begin
   if (pWidth < 1) or (pHeight < 1) then begin
    pWidth:=Picture.Graphic.Width;
    pHeight:=Picture.Graphic.Height;
   end;

   Printer.Begindoc;

   Printer.Canvas.StretchDraw(Rect(X, Y, pWidth, pHeight), Picture.Graphic);

   Printer.Enddoc;
end;

{------------------------------------------------------------------------}

{------------------------------------------------------------------------}



begin
 TDBMultiImageCallBack:=nil;
 TDBMultiMediaCallBack:=nil;
end.


