{Part of Imagelib VCL/DLL Library.
Written by Jan Dekkers and Kevin Adams (c) 1995. If you are a non
registered client, you may use or alter this demo only for evaluation
purposes.

Uses ImageLib 2.2.1 Changed the callback to a function instead of a
procedure to let the user cancel out. Added:

Changed callback in version 2.21 to a function with cdecl.
using the C calling convention.


scrolling text images
Cut, Copy and Paste to/from the clipboard
Printing bitmaps}


unit Uimage;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, FileCtrl, TMulti, VBXCtrl, Switch, Spin,
  Buttons, UFullscr, Menus, Uabout, ExtCtrls, Gauges, printers, U_p_size;


type
  TForm1 = class(TForm)
    DriveComboBox1     : TDriveComboBox;
    DirectoryListBox1  : TDirectoryListBox;
    FileListBox1       : TFileListBox;
    Sstretch           : TBiSwitch;
    Label1             : TLabel;
    SaveAs             : TBiSwitch;
    Label4             : TLabel;
    SaveDialog1        : TSaveDialog;
    SaveButton         : TBitBtn;
    QualitySpin        : TSpinEdit;
    Smoothspin         : TSpinEdit;
    QualityLabel       : TLabel;
    SmoothLabel        : TLabel;
    GroupBox1          : TGroupBox;
    res4               : TRadioButton;
    res24              : TRadioButton;
    res8               : TRadioButton;
    GroupBox2          : TGroupBox;
    Label5             : TLabel;
    Label6             : TLabel;
    Label7             : TLabel;
    DitherOneNo        : TRadioButton;
    DitherOneYes       : TRadioButton;
    DitherTwoNo        : TRadioButton;
    DitherTwoYes       : TRadioButton;
    Dither24Bit        : TRadioButton;
    MainMenu1          : TMainMenu;
    N1                 : TMenuItem;
    O1                 : TMenuItem;
    N2                 : TMenuItem;
    N3                 : TMenuItem;
    E1                 : TMenuItem;
    A1                 : TMenuItem;
    OpenDialog1        : TOpenDialog;
    N4                 : TMenuItem;
    Print1             : TMenuItem;
    PrintSetup1        : TMenuItem;
    PrinterSetupDialog1: TPrinterSetupDialog;
    PrintDialog1       : TPrintDialog;
    MultiImage1        : TMultiImage;
    Gauge1             : TGauge;
    Label9             : TLabel;
    Label10            : TLabel;
    Label11            : TLabel;
    Label12            : TLabel;
    Label13            : TLabel;
    Label14            : TLabel;
    Label15            : TLabel;
    Edit1              : TEdit;
    Edit2              : TEdit;
    Edit3              : TEdit;
    Edit4              : TEdit;
    Edit5              : TEdit;
    Edit6              : TEdit;
    Edit7              : TEdit;
    GetInfoChecked     : TCheckBox;
    Label8             : TLabel;
    Edit8              : TEdit;
    CheckBox1          : TCheckBox;
    BitBtn1            : TBitBtn;
    Edit9: TMenuItem;
    Cut1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    ScrollBar1: TScrollBar;
    N5: TMenuItem;
    CreateMessage1: TMenuItem;
    procedure DriveComboBox1Change(Sender: TObject);
    procedure DirectoryListBox1Change(Sender: TObject);
    procedure FileListBox1Change(Sender: TObject);
    procedure SstretchOnOff(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure resClick(Sender: TObject);
    procedure DitherClick(Sender: TObject);
    procedure SaveButtonClick(Sender: TObject);
    procedure MultiImage1Click(Sender: TObject);
    procedure E1Click(Sender: TObject);
    procedure O1Click(Sender: TObject);
    procedure A1Click(Sender: TObject);
    procedure setsavevisible(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure PrintSetup1Click(Sender: TObject);
    procedure GetInfoCheckedClick(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Cut1Click(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
    procedure Paste1Click(Sender: TObject);
    procedure ScrollBar1Change(Sender: TObject);
    procedure SmoothspinChange(Sender: TObject);
    procedure QualitySpinChange(Sender: TObject);
  private
    { Private declarations }
   oldsavefiles   : TstringList;
   oldreadfiles   : TstringList;
   procedure DisPlayInfo(dis : boolean);
   Procedure Trigger(Sender : TObject; Var Done : Boolean);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{---------------------------------------------------------------------}

{Changed in version 2.21 from a procedure to a function with cdecl.
 To cancel return a 0 else return a 1}

 Function ImageLibCallBack(i : integer) : integer; cdecl; export;
{Callback function from the dll, CDECL and EXPORT ARE REQUIRED}
begin
 if Application.Terminated then begin
   {User wants to terminate the program. Pass a 0 to the dll}
   Result:=0;
  end else begin
  {Be nice to others <g>}
   Application.ProcessMessages;
   {process a Gauge}
   Form1.Gauge1.Progress:=i;
   {tell the dll that everything is OK}
   Result:=1;
   end;
end;
{---------------------------------------------------------------------}

procedure TForm1.DriveComboBox1Change(Sender: TObject);
{update the drive of DirectoryListBox1 with the drive of DriveComboBox1}
begin
  DirectoryListBox1.Drive := DriveComboBox1.Drive;
end;
{---------------------------------------------------------------------}

procedure TForm1.DisPlayInfo(dis : boolean);
begin
    {If scrolling message then show the speed scroll bar}
    if MultiImage1.BFileType = 'SCM' then begin
    {Show it}
     ScrollBar1.Visible:=true;
     {set the speed/position}
     ScrollBar1.Position:=MultiImage1.MsgSpeed;
    end else
     ScrollBar1.Visible:=False;

(*     {show or hide the jpeg options}
     GroupBox1.Visible:=(MultiImage1.BFileType = 'JPEG');
     GroupBox2.Visible:=(MultiImage1.BFileType = 'JPEG');
*)

    if dis then begin
       {display the image info}
       Edit1.Text:=IntToStr(MultiImage1.Bwidth);
       Edit2.Text:=IntToStr(MultiImage1.BHeight);
       Edit3.Text:=IntToStr(MultiImage1.Bbitspixel);
       Edit4.Text:=IntToStr(MultiImage1.Bplanes);
       Edit5.Text:=IntToStr(MultiImage1.Bnumcolors);
       Edit6.Text:=MultiImage1.BFileType;
       Edit7.Text:=MultiImage1.Bcompression;
       Edit8.Text:=IntToStr(MultiImage1.BSize);
     end else begin
      {set the image info to ''}
       Edit1.Text:='';
       Edit2.Text:='';
       Edit3.Text:='';
       Edit4.Text:='';
       Edit5.Text:='';
       Edit6.Text:='';
       Edit7.Text:='';
       Edit8.Text:='';
     end;
end;
{---------------------------------------------------------------------}

procedure TForm1.DirectoryListBox1Change(Sender: TObject);
{update the directory of FileListBox1 with the directory of FileListBox1}
begin
  FileListBox1.Directory := DirectoryListBox1.Directory;
end;
{---------------------------------------------------------------------}

procedure TForm1.FileListBox1Change(Sender: TObject);
{Display the image of the FileListBox1.filename}
begin
 {set hourglass cursor}
  screen.cursor:=crHourGlass;

 {delete the old image}
  MultiImage1.imagename:='';

 {display an image using the vcl}
  MultiImage1.imagename:=FileListBox1.filename;

  {Request fileinfo from the DLL}
  {Note, fileinfo will not work on WMF and ICO}
  if GetInfoChecked.Checked then
   DisplayInfo(true) else DisplayInfo(false);

  {Reset the gauge}
  Gauge1.Progress:=0;

 {add filename to the history list of the open dialog}
  oldreadfiles.add(FileListBox1.filename);

 {copy the stringlist to the historylist}
  OpenDialog1.historylist:=oldreadfiles;

  {set default cursor}
  screen.cursor:=crDefault;
end;
{---------------------------------------------------------------------}

procedure TForm1.SstretchOnOff(Sender: TObject);
{set strech mode}
begin
  MultiImage1.stretch:=Sstretch.Pon;
end;
{---------------------------------------------------------------------}

procedure TForm1.setsavevisible(Sender: TObject);
{hide or show jpeg save options}
begin
    QualitySpin.visible:=SaveAs.Pon;
    Smoothspin.visible:=SaveAs.Pon;
    QualityLabel.visible:=SaveAs.Pon;
    SmoothLabel.visible:=SaveAs.Pon;
end;
{---------------------------------------------------------------------}

procedure TForm1.FormCreate(Sender: TObject);
{what we do on create}
begin
    {Define the callback procedure}
    TMultiImageCallBack:=ImageLibCallBack;

    {set the value of the QualitySpin to the value of JPegSaveQuality}
    QualitySpin.value:=MultiImage1.JPegSaveQuality;

    {set the value of the Smoothspin to the value of JPegSaveSmooth}
    Smoothspin.value:=MultiImage1.JPegSaveSmooth;

    {show the save options depending on the saveas switch pon state}
    setsavevisible(sender);

    {create temporary history stringlists}
    oldsavefiles := TstringList.create;
    oldreadfiles := TstringList.create;
    {IMPORTANT}
    {This is the moving engine for all the messages. Since an applcation
    can have only one OnIdle Trigger, this trigger needs to be subdivided
    by all your moving and animated objects. In this particular case the
    function is called TRIGGER but you can name it as you want as long
    you have a procedure named the same.}

    Application.OnIdle:=Trigger;
end;
{---------------------------------------------------------------------}

Procedure TForm1.Trigger(Sender : TObject; Var Done : Boolean);
begin
   {This function is called when your app is idle. Subdivide the
    trigger event to your TMultiImage objects who may need one.
    If no Message is active it will not take up significant time}
    MultiImage1.Trigger;
end;
{---------------------------------------------------------------------}

procedure TForm1.resClick(Sender: TObject);
{Set the jpeg resolution to either 16, 256 or true color in the vcl}
begin
 {set jpeg show resolution to 4 bit 16 color}
 if res4.checked  then MultiImage1.JPegResolution:=4;

 {set jpeg show resolution to 8 bit 256 color}
 if res8.checked  then MultiImage1.JPegResolution:=8;

 {set jpeg show resolution to 24 bit true color}
 if res24.checked then MultiImage1.JPegResolution:=24;
end;
{---------------------------------------------------------------------}

procedure TForm1.DitherClick(Sender: TObject);
{Set the jpeg dither in the vcl}
begin
  {set the jpeg show dither to none (best choice for true color 24 bit}
  if Dither24Bit.checked  then MultiImage1.JPegDither:=0;

  {set the jpeg show dither to one pass none}
  if DitherOneNo.checked  then MultiImage1.JPegDither:=1;

  {set the jpeg show dither to one pass dithered (best choice for 16 colors)}
  if DitherOneYes.checked  then MultiImage1.JPegDither:=2;

  {set the jpeg show dither to one pass none}
  if DitherTwoNo.checked  then MultiImage1.JPegDither:=3;

  {set the jpeg show dither to two pass dithered (best choice for 256 colors)}
  if DitherTwoYes.checked  then MultiImage1.JPegDither:=4;
end;
{---------------------------------------------------------------------}

procedure TForm1.SaveButtonClick(Sender: TObject);
{save a jpeg or bmp}
begin
 {Set various filters}
 if MultiImage1.BFileType = 'SCM' then begin
  SaveDialog1.Filename:='*.SCM';
  SaveDialog1.Filter:='Scroll message|*.scm';
 end else begin
  SaveDialog1.Filename:='*.jpg';
  SaveDialog1.Filter:='jpeg|*.jpg|bitmap|*.bmp';
 end;

 {open save dialog}
 if SaveDialog1.execute then begin

 {set hourglass cursor}
  screen.cursor:=crHourGlass;

  {save it if the extension is jpg}
  if UpperCase(ExtractFileExt(SaveDialog1.Filename)) =  '.JPG' then
    MultiImage1.SaveAsJpg(SaveDialog1.FileName);

  {save it if the extension is bmp}
  if UpperCase(ExtractFileExt(SaveDialog1.Filename)) =  '.BMP' then
    MultiImage1.Picture.SaveToFile(SaveDialog1.FileName);

 {save it if the extension is SCM}
  if UpperCase(ExtractFileExt(SaveDialog1.Filename)) =  '.SCM' then
    MultiImage1.SaveCurrentMessage(SaveDialog1.FileName);

 {add filename to the history list of the save dialog}
  oldSavefiles.add(SaveDialog1.filename);

 {copy the stringlist to the historylist}
  SaveDialog1.historylist:=oldSavefiles;

 {set default cursor}
  screen.cursor:=crDefault;

  {update the filelist box sothat the file saved shows up}
  FileListBox1.Update;
 end;
end;
{---------------------------------------------------------------------}

procedure TForm1.MultiImage1Click(Sender: TObject);
{show fullscreen}
begin
  {copy image to fullscreen image}
  FullSlide.MultiImage1.Picture.Graphic:=MultiImage1.Picture.Graphic;
  {show the image fulscreen}
  FullSlide.showmodal;
end;
{---------------------------------------------------------------------}

procedure TForm1.E1Click(Sender: TObject);
{exit the program}
begin
 close;
end;
{---------------------------------------------------------------------}

procedure TForm1.O1Click(Sender: TObject);
{open a image using the open dialog}
begin
  if OpenDialog1.execute then begin

   {set hourglass cursor}
    screen.cursor:=crHourGlass;

   {delete the old image}
    MultiImage1.imagename:='';

    {display an image using the vcl}
    MultiImage1.imagename:=OpenDialog1.filename;

   {Request fileinfo from the DLL}
   {Note, fileinfo will not work on WMF and ICO}
    if GetInfoChecked.Checked then
      DisplayInfo(true) else DisplayInfo(false);

    {reset the gauge}
    Gauge1.Progress:=0;

   {add filename to the history list of the open dialog}
    oldreadfiles.add(OpenDialog1.filename);

   {copy the stringlist to the historylist}
    OpenDialog1.historylist:=oldreadfiles;

   {set default cursor}
    screen.cursor:=crDefault;
  end;
end;
{---------------------------------------------------------------------}

procedure TForm1.A1Click(Sender: TObject);
{about box}
begin
{Copy the image to the image of he about box}
 AboutBox.Image1.Picture.Graphic:=MultiImage1.Picture.Graphic;
{show the about box}
 AboutBox.showmodal;
end;
{---------------------------------------------------------------------}

procedure TForm1.Print1Click(Sender: TObject);
{Print image}
begin
  if PrintDialog1.execute then begin
  {Initialize the height spinedit of the printsize dialog box}
   Printersize.HeigthSpinEdit.Value:=MultiImage1.Picture.Height;
   {Initialize the width spinedit of the printsize dialog box}
   Printersize.WidthSpinEdit.Value:=MultiImage1.Picture.Width;
   {Show it}
   Printersize.ShowModal;
   if Printersize.Modalresult = mrok then
    {print TMultiImage}
     MultiImage1.PrintMultiImage(0,0,Printersize.WidthSpinEdit.Value,Printersize.HeigthSpinEdit.Value);
   {Hide it if done}
   Printersize.hide;
  end;
end;
{---------------------------------------------------------------------}

procedure TForm1.PrintSetup1Click(Sender: TObject);
{Set up printer}
begin
  PrinterSetupDialog1.Execute;
end;
{---------------------------------------------------------------------}

procedure TForm1.GetInfoCheckedClick(Sender: TObject);
{depending on the state of the checkbox,  display or not display info}
begin
 DisPlayInfo(GetInfoChecked.Checked);
end;
{---------------------------------------------------------------------}
procedure TForm1.CheckBox1Click(Sender: TObject);
{depending on the state of the checkbox, center or not center image}
begin
 MultiImage1.Center:=CheckBox1.Checked;
end;
{---------------------------------------------------------------------}

procedure TForm1.BitBtn1Click(Sender: TObject);
var
  RunAfterCreate : Boolean;
begin
    {Create a new message using the message editor}
    {boolean indicating to run the message after creation}
    RunAfterCreate:=True;

    {CreateMessage takes a pathname as the initial path to save the
     message and a boolean to run it. For Instance:
    {MultiImage1.CreateMessage('c:\',true);}
    MultiImage1.CreateMessage(ExtractFilePath(Application.Exename),RunAfterCreate);

    {Show new message in listbox}
    FileListBox1.Update;
end;
{---------------------------------------------------------------------}

procedure TForm1.FormDestroy(Sender: TObject);
begin
   {release memory of the stringlist boxes}
    oldsavefiles.free;
    oldreadfiles.free;
end;
{---------------------------------------------------------------------}

procedure TForm1.Cut1Click(Sender: TObject);
begin
{Cut Image and Copy it to the clipboard}
  MultiImage1.CutToClipboard
end;
{---------------------------------------------------------------------}

procedure TForm1.Copy1Click(Sender: TObject);
begin
{Copy Image to the clipboard}
  MultiImage1.CopyToClipboard;
end;
{---------------------------------------------------------------------}

procedure TForm1.Paste1Click(Sender: TObject);
begin
{Paste Image from the clipboard}
  MultiImage1.PasteFromClipboard;
end;
{---------------------------------------------------------------------}

procedure TForm1.ScrollBar1Change(Sender: TObject);
begin
 {Change the speed of a srolling message}
  MultiImage1.MsgSpeed:=ScrollBar1.Position;
end;
{---------------------------------------------------------------------}


procedure TForm1.SmoothspinChange(Sender: TObject);
begin
    {set the value of the JPegSaveSmooth}
    MultiImage1.JPegSaveSmooth:=Smoothspin.value;
end;

procedure TForm1.QualitySpinChange(Sender: TObject);
begin
    {set the value of the JPegSaveQuality}
    MultiImage1.JPegSaveQuality:=QualitySpin.value;
end;

end.
