{Part of Imagelib VCL/DLL Library.
Written by Jan Dekkers and Kevin Adams (c) 1995. If you are a non
registered client, you may use or alter this demo only for evaluation
purposes.

Uses ImageLib 2.2.1 Changed the callback to a function instead of a
procedure to let the user cancel out. Added:

Changed callback in version 2.21 to a function with cdecl.
using the C calling convention.


scrolling text images
Cut, Copy and Paste to/from the clipboard
Printing bitmaps}

unit Umail;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, DBCtrls, MPlayer, TDBMulti, StdCtrls, DB,
  DBTables, Gauges, Mask, Buttons, Spin;

type
  TForm1 = class(TForm)
    DataSource1: TDataSource;
    Table1: TTable;
    DBMultiImage1: TDBMultiImage;
    DBMultiMedia1: TDBMultiMedia;
    DBMemo1: TDBMemo;
    DBNavigator1: TDBNavigator;
    DBMultiImage2: TDBMultiImage;
    AddMM: TBitBtn;
    AddImage: TBitBtn;
    AddMsg: TBitBtn;
    BitBtn6: TBitBtn;
    DBEdit1: TDBEdit;
    DBEdit2: TDBEdit;
    Gauge1: TGauge;
    Gauge2: TGauge;
    OpenDialog1: TOpenDialog;
    DBMediaPlayer1: TDBMediaPlayer;
    SpinButton1: TSpinButton;
    procedure FormCreate(Sender: TObject);
    procedure AddImageClick(Sender: TObject);
    procedure AddMMClick(Sender: TObject);
    procedure DataSource1DataChange(Sender: TObject; Field: TField);
    procedure AddMsgClick(Sender: TObject);
    procedure SpinButton1DownClick(Sender: TObject);
    procedure SpinButton1UpClick(Sender: TObject);
    procedure BitBtn6Click(Sender: TObject);
  private
    { Private declarations }
    function JustPathname(PathName : string) : string;
    Procedure Trigger(Sender : TObject; Var Done : Boolean);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}


{IMPORTANT}
{Changed in version 2.21 from a procedure to a function with cdecl.
 To cancel return a 0 else return a 1}

Function MMCalledBack ( i : integer) : integer; cdecl; export;

{Callback function from the dll, CDECL and EXPORT ARE REQUIRED}
begin

  if Application.Terminated then

   {User wants to terminate the program. Pass a 0 to the dll}
   Result:=0

  else begin
   {Process Progress bar}
   Form1.Gauge1.Progress:=i;

   {Live in peace with others}
   Application.ProcessMessages;

   {tell the dll that everything is OK}
   Result:=1;
   end;
end;
{---------------------------------------------------------------------}

{IMPORTANT}
{Changed in version 2.21 from a procedure to a function with cdecl.
 To cancel return a 0 else return a 1}

Function MICalledBack ( i : integer) : integer; cdecl; export;

{Callback function from the dll, CDECL and EXPORT ARE REQUIRED}
begin

  if Application.Terminated then

   {User wants to terminate the program. Pass a 0 to the dll}
   Result:=0

  else begin
   {Process Progress bar}
   Form1.Gauge2.Progress:=i;

   {Live in peace with others}
   Application.ProcessMessages;

   {tell the dll that everything is OK}
   Result:=1;
   end;
end;
{---------------------------------------------------------------------}


function TForm1.JustPathname(PathName : string) : string;
    {-Return just the drive:directory portion of a pathname}
  var
    I : Word;
  const
     DosDelimSet : set of Char = ['\', ':', #0];
  begin
    I := Succ(Word(Length(PathName)));
    repeat
      Dec(I);
    until (PathName[I] in DosDelimSet) or (I = 0);

    if I = 0 then
      {Had no drive or directory name}
      JustPathname[0] := #0
    else if I = 1 then
      {Either the root directory of default drive or invalid pathname}
      JustPathname := PathName[1]
    else if (PathName[I] = '\') then begin
      if PathName[Pred(I)] = ':' then
        {Root directory of a drive, leave trailing backslash}
        JustPathname := Copy(PathName, 1, I)
      else
        {Subdirectory, remove the trailing backslash}
        JustPathname := Copy(PathName, 1, Pred(I));
    end else
      {Either the default directory of a drive or invalid pathname}
      JustPathname := Copy(PathName, 1, I);
  end;
{---------------------------------------------------------------------}



Procedure TForm1.Trigger(Sender : TObject; Var Done : Boolean);
begin
    {IMPORTANT}
   {This function is called when your app is idle. Subdivide the
    trigger event to your TDBMultiMedia objects who may need one.
    If no Message is active it will not take up significant time}
    DBMultiMedia1.Trigger;
    DBMultiImage1.Trigger;
    DBMultiImage2.Trigger;
end;
{---------------------------------------------------------------------}


procedure TForm1.FormCreate(Sender: TObject);
begin
    {Register the callback Fuctions to the VCL}
    TDBMultiMediaCallBack:=MMCalledBack;
    TDBMultiImageCallBack:=MICalledBack;

    If FileExists(ExtractFilePath(Application.ExeName)+'MAIL_ORD.DB') then begin
       {if the table exists open it on creation}
       Table1.DataBaseName:=JustPathName(Application.ExeName);
       Table1.TableName:='MAIL_ORD.DB';
       Table1.Active:=True;
     end;

   {IMPORTANT}
    {This is the moving engine for all the messages. Since an applcation
    can have only one OnIdle Trigger, this trigger needs to be subdivided
    by all your moving and animated objects. In this particular case the
    function is called TRIGGER but you can name it as you want as long
    you have a procedure named the same.}
    Application.OnIdle:=Trigger;
 end;


procedure TForm1.AddImageClick(Sender: TObject);
begin
  OpenDialog1.filter:='All Images|*.jpg;*.bmp;*.gif;*.pcx|Jpeg|*.jpg|BitMap|*.bmp|Gif|*.gif|Pcx|*.pcx';
  {Execute the open dialog box}
  if OpenDialog1.Execute then begin

    Table1.Edit;

    {Load the Multimedia into the Blob}
    DBMultiImage2.LoadfromFile(OpenDialog1.FileName);

    {Post that thing}
    Table1.Post;
  end;
end;



procedure TForm1.AddMMClick(Sender: TObject);
begin
  {fill the OpenDialog filter with the MM extensions as found in the win.ini
   (This means that the appropriate drivers are installed)}
  OpenDialog1.filter:=DBMultiMedia1.GetMultiMediaExtensions;

  {Execute the open dialog box}
  if OpenDialog1.Execute then begin

    Table1.Edit;

    {Load the Multimedia into the Blob}
    DBMultiMedia1.LoadfromFile(OpenDialog1.FileName);

    {Post that thing}
    Table1.Post;
  end;
end;

procedure TForm1.DataSource1DataChange(Sender: TObject; Field: TField);
begin
    {Set the Video display rectangle to the rectangle of the blob window}
    DBMediaPlayer1.DisplayRect:=Rect(0,0,DBMultiMedia1.Width,DBMultiMedia1.Height);

    {Set the Video display to the the display of the blob window}
    DBMediaPlayer1.Display:=DBMultiMedia1;

end;

procedure TForm1.AddMsgClick(Sender: TObject);
begin
    Table1.Edit;
    {Create a New Message}
    If DBMultiImage1.CreateMessage then
    {Post or cancel that thing}
       Table1.Post
    else
       Table1.Cancel;
end;


procedure TForm1.SpinButton1DownClick(Sender: TObject);
begin
  if DBMultiImage1.MsgSpeed <10 then Inc(DBMultiImage1.MsgSpeed)
end;

procedure TForm1.SpinButton1UpClick(Sender: TObject);
begin
  if DBMultiImage1.MsgSpeed >0 then Dec(DBMultiImage1.MsgSpeed)
end;

procedure TForm1.BitBtn6Click(Sender: TObject);
begin
 Application.Terminate;   
end;

end.
