unit LButton;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Dialogs, Buttons,
  Lgeneral;
{$DEFINE DEBUGX}
type
  TLnchButton = class( TSpeedButton )
  private
    hInstance : Word;
    aModule  : array [0..kMaxCommandBufSize] of Char;
    aCmdLine : array [0..kMaxCommandBufSize] of Char;
    function GetCmdLineBuf: PChar;
  public
    hIcon : Word;
    destructor Destroy; override;
    function  hInstanceOK: Boolean;
    procedure WinExecError( iErr : Word );
    function  OkToLaunch: Boolean;
    procedure Reposition( const bNewVis: Boolean;
                          const bSideways: Boolean;
                          const iVisBtnNo:Integer );
    procedure Click; override;
    property CmdLine : PChar read GetCmdLineBuf;
  end;

implementation

{ -------------- Launcher Button --------------  }
destructor TLnchButton.Destroy;
begin
  if hIcon <> 0 then
     DeleteObject( hIcon );
  inherited Destroy;
end;

function TLnchButton.GetCmdLineBuf: PChar;
begin
  Result := @aCmdLine;
end;

function TLnchButton.hInstanceOK: Boolean;
begin
  { assume failure }
  Result := False;
  if hInstance >= 32 then
    Result := True;
end;

type TFindHwndRec = record
  FoundWnd: HWND;
  ChkInst:  THandle;
  ChkModule: array [0..kMaxCommandBufSize] of Char;
end;
type PFindHwndRec = ^TFindHwndRec;

function FindHwndFromInstance( WndBeingChecked: HWND;
                               rec: PFindHwndRec): Bool; export;
var
  OldInstance: THandle;
  aOldModule : array [0..kMaxCommandBufSize] of Char;
  nLen : Integer;
begin
  Result := True;
  rec^.FoundWnd := HWND(0);
  OldInstance := GetWindowWord( WndBeingChecked, GWW_HINSTANCE );
  nLen := GetModuleFileName( OldInstance, aOldModule, kMaxCommandBufSize );

  if (OldInstance = rec^.ChkInst)
  or (0 = lstrcmpi( aOldModule, rec^.ChkModule ) )then
  begin
    rec^.FoundWnd := WndBeingChecked;
    Result := False;
  end;
end;

function TLnchButton.OkToLaunch: Boolean;
var
{  aPgmRunning : array [0..kMaxCommandBufSize] of Char; }
  rec: TFindHwndRec;
begin
  { assume OK to launch }
  Result := True;
  { We can try to relaunch if hInstance is not valid or unused (ie. 0) }
  if hInstance >= 32 then
  begin
    { Get name of program associated with the last instance of program
      launched with this button ... if it is still running.
      If this handle is being reused, we will get the wrong program name,
      but for now this should work }
    rec.ChkInst := hInstance;
    StrLCopy( rec.ChkModule, aModule, kMaxCommandBufSize );
    EnumWindows( @FindHwndFromInstance, Longint(@rec) );
    if rec.FoundWnd <> 0 then
    begin
      Result := False;
      if (not IsWindowVisible (rec.FoundWnd)) then
      begin
        ShowWindow (rec.FoundWnd, sw_ShowNormal);
        PostMessage (rec.FoundWnd, wm_User, 0, 0);
      end else
      begin
        SetActiveWindow (rec.FoundWnd);
      end;
    end;
  end;
end;

procedure TLnchButton.Click;
var
  nLen: Integer;
begin
  if OkToLaunch then
  begin
    hInstance := WinExec( aCmdLine, sw_shownormal );
    nLen := GetModuleFileName( hInstance, aModule, kMaxCommandBufSize );
  end;
  if not hInstanceOK then
    WinExecError( hInstance );
  inherited Click;
end;

procedure TLnchButton.Reposition( const bNewVis: Boolean;
                                  const bSideways: Boolean;
                                  const iVisBtnNo:Integer );
begin
  Visible := bNewVis;
  if Visible then
  begin
    if bSideways then
    begin
      Top  := kiBorder;
      Left := kiBorder + iVisBtnNo*( kiInnerBorder + Width );
    end else
    begin
      Top  := kiBorder + iVisBtnNo*( kiInnerBorder + Height );
      Left := kiBorder;
    end;
  end;
end;

procedure TLnchButton.WinExecError( iErr : Word );
var
  sErrMsg, sCmdLine : String;
begin
{ $IFDEF WINEXECERR }
    sCmdLine := StrPas( aCmdLine );
  case iErr of
    0:  sErrMsg := 'System was out of memory, executable file was corrupt,'
                 + ' or relocations were invalid.';
    2:  sErrMsg := 'File was not found.' + #13 + #10 + sCmdLine;
    3:  sErrMsg := 'Path was not found.' + #13 + #10 + sCmdLine;
    5:  sErrMsg := 'Attempt was made to dynamically link to a task, or there'
                 + ' was a sharing or network-protection error.';
    6:  sErrMsg := 'Library required separate data segments for each task.';
    8:  sErrMsg := 'There was insufficient memory to start the application.';
    10: sErrMsg := 'Windows version was incorrect.';
    11: sErrMsg := 'Executable file was invalid. Either it was not a Windows'
                 + ' application or there was an error in the .EXE image.';
    12: sErrMsg := 'Application was designed for a different operating system.';
    13: sErrMsg := 'Application was designed for MS-DOS 4.0.';
    14: sErrMsg := 'Type of executable file was unknown.';
    15: sErrMsg := 'Attempt was made to load a real-mode application'
                 + ' (developed for an earlier version of Windows).';
    16: sErrMsg := 'Attempt was made to load a second instance of an'
                 + ' executable file containing multiple data segments'
                 + ' that were not marked read-only.';
    19: sErrMsg := 'Attempt was made to load a compressed executable file.'
                 + ' The file must be decompressed before it can be loaded.';
    20: sErrMsg := 'Dynamic-link library (DLL) file was invalid.  One of the'
                 + ' DLLs required to run this application was corrupt.';
    21: sErrMsg := 'Application requires 32-bit extensions.';
  end;
  MessageDlg( sErrMsg, mtWarning, [mbOk], 0);
{ $ENDIF WINEXECERR }
end;

end.
