unit Lconfig;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, TabNotBk, StdCtrls, Buttons, ExtCtrls, IniFiles,
  Mask,
  LGeneral, FileCtrl;  { for TLchIniFile, TWskIniFile }

type
  TfrmConfig = class(TForm)
    TabbedNotebook1: TTabbedNotebook;
    btnCloseApp: TBitBtn;
    HelpBtn: TBitBtn;
    Label1: TLabel;
    gbNew: TGroupBox;
    edtNew: TEdit;
    btnBrowse: TBitBtn;
    OpenDialog1: TOpenDialog;
    btnHide: TBitBtn;
    btnRemove: TBitBtn;
    edtHint: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    lstPrograms: TListBox;
    pnlScreen: TPanel;
    rgbOrientation: TRadioGroup;
    rgbCorner: TRadioGroup;
    pnlSideways: TPanel;
    sbH3: TSpeedButton;
    sbH2: TSpeedButton;
    sbH1: TSpeedButton;
    pnlUpAndDown: TPanel;
    sbV1: TSpeedButton;
    sbV2: TSpeedButton;
    sbV3: TSpeedButton;
    edtPrefix: TEdit;
    lblPrefix: TLabel;
    rgbComPort: TRadioGroup;
    rgbBaudRate: TRadioGroup;
    chkDialOne: TCheckBox;
    chkBlockCallWait: TCheckBox;
    Label4: TLabel;
    Label5: TLabel;
    mskPhone: TMaskEdit;
    mskGateway: TMaskEdit;
    Label7: TLabel;
    Bevel1: TBevel;
    Label8: TLabel;
    imgChkOn: TImage;
    imgChkOff: TImage;
    btnSave: TBitBtn;
    btnForgetUserid: TBitBtn;
    btnForgetPassword: TBitBtn;
    chkUseDialPrefix: TCheckBox;
    Label9: TLabel;
    mskAreaCode: TMaskEdit;
    Label10: TLabel;
    gbBkgds: TGroupBox;
    fLstBkgd: TFileListBox;
    chkBkgd: TCheckBox;
    procedure btnBrowseClick(Sender: TObject);
    procedure btnCloseAppClick(Sender: TObject);
    procedure btnHideClick(Sender: TObject);
    procedure ModelLocation;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure edtNewChange(Sender: TObject);
    procedure btnRemoveClick(Sender: TObject);
    procedure lstProgramsKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure lstProgramsMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure lstProgramsClick(Sender: TObject);
    procedure lstProgramsDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure lstProgramsMeasureItem(Control: TWinControl; Index: Integer;
      var Height: Integer);
    procedure lstProgramsKeyPress(Sender: TObject; var Key: Char);
    procedure lstProgramsMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure edtKeyPress(var Key: Char);
    procedure edtNewKeyPress(Sender: TObject; var Key: Char);
    procedure edtHintKeyPress(Sender: TObject; var Key: Char);
    procedure rgbCornerClick(Sender: TObject);
    procedure rgbOrientationClick(Sender: TObject);
    procedure btnForgetUseridClick(Sender: TObject);
    procedure btnForgetPasswordClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure mskAreaCodeExit(Sender: TObject);
    procedure mskPhoneExit(Sender: TObject);
    procedure mskGatewayExit(Sender: TObject);
    procedure chkDialOneClick(Sender: TObject);
    procedure chkBlockCallWaitClick(Sender: TObject);
    procedure edtPrefixChange(Sender: TObject);
    procedure rgbComPortClick(Sender: TObject);
    procedure rgbBaudRateClick(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
    procedure fLstBkgdChange(Sender: TObject);
    procedure chkBkgdClick(Sender: TObject);
    procedure edtNewExit(Sender: TObject);
    procedure edtHintExit(Sender: TObject);
  private
    { Private declarations }
    iCurrItem : Integer;
    bmpChkOn, bmpChkOff: TBitMap;
    oldX, oldY: Integer;
    bSet: Boolean;
    sBlockCallWait: String;
    iniLch: TLchIniFile;
    iniWsk: TWskIniFile;
    procedure RemoveCurrent;
    procedure UpdateRemoveButton;
    procedure UpdateSaveButton;
    procedure ClearPgmBox;
    function FlushPgmBox:Boolean;
    function ValidPgmBox:Boolean;
    function UpdatePgmBox:Boolean;
    procedure initSerialTCP;
    procedure SetPhoneNo;
    procedure btnForget( const sErasableThing, sIdent: String );
  public
    { Public declarations }
  end;

implementation

{$R *.DFM}

uses
  Lprogram,  { for TLnchProgram }
  Launcher;

{
=====================================================================
                          All Tabs
=====================================================================
}

function GetCurrPgmObj( const frmConfig: TfrmConfig;
                        const iItem: Integer;
                          var sCmdLine: String ): TLnchProgram;
begin
  Result := nil;
  with frmConfig.lstPrograms.Items do
  if (iItem >= 0) and (iItem < Count) then
  begin
    sCmdLine := Strings[ iItem ];
    Result := frmLauncher.Programs[ sCmdLine ];
  end;
end;

procedure TfrmConfig.btnCloseAppClick(Sender: TObject);
begin
  iniLch.WriteRect( ksConfigWndSect, BoundsRect );
  frmLauncher.SavePositionINI;
  frmLauncher.Close;
end;

procedure TfrmConfig.btnHideClick(Sender: TObject);
begin
  iniLch.WriteRect( ksConfigWndSect, BoundsRect );
  Close;
end;

procedure TfrmConfig.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  frmLauncher.ReleaseConfigForm;
end;

procedure TfrmConfig.SetPhoneNo;
var
  sPhoneNo: String;
  sAreaCode: String;
begin
  sPhoneNo := edtPrefix.Text;
  if chkBlockCallWait.Checked then
    sPhoneNo := sPhoneNo + sBlockCallWait;
  if chkDialOne.Checked then
    sPhoneNo := sPhoneNo + '1-';
  sAreaCode := mskAreaCode.Text;
  if Length( sAreaCode ) = 3 then
    sPhoneNo := sPhoneNo + sAreaCode;
  sPhoneNo := sPhoneNo + mskPhone.Text;
  iniWsk.WriteString( ksWVarSect, ksPhoneNo, sPhoneNo );
end;

procedure TfrmConfig.initSerialTCP;
var
  ii, iListIndex: Integer;
  lBaud: LongInt;
begin
  mskAreaCode.Text   := iniLch.ReadString( ksDialerSect,
                                          ksAreaCode, ksDefaultAC );
  mskPhone.Text      := iniLch.ReadString( ksDialerSect,
                                          ksPhone,    ksDefaultPhone );
  edtPrefix.Text     := iniLch.ReadString( ksDialerSect,ksPrefix, '' );
  chkDialOne.Checked := iniLch.ReadBool(   ksDialerSect, ksDialOne, False );
  chkBlockCallWait.Checked := iniLch.ReadBool( ksDialerSect,
                                               ksBlockCallWait, True );
  sBlockCallWait     := iniLch.ReadString( ksDialerSect,
                                       ksBlockCallWaitIdent,
                                       ksBlockCallWaitDigits );
  SetPhoneNo;
  { INI file Port range: 1..4 --- rgbComPort.ItemIndex range: 0..3 }
  rgbComPort.ItemIndex := iniWsk.ReadInteger( ksWMainSect,
                                              ksPort,
                                              kiComPortDefault+1 ) - 1;
  mskGateway.Text := iniWsk.ReadString( ksWMainSect, ksGateway, '127.0.0.1' );
  lBaud := iniWsk.ReadInteger( ksWMainSect, ksBaudRate, 9600 );
  rgbBaudRate.ItemIndex := kiBaudDefault;
  for ii := 0 to rgbBaudRate.Items.Count-1 do
  begin
    if lBaud = StrToInt( rgbBaudRate.Items[ ii ] ) then
    begin
      rgbBaudRate.ItemIndex := ii;
      break;
    end;
  end;
end;

procedure TfrmConfig.FormCreate(Sender: TObject);
var
  ii, iListIndex: Integer;
  sCmdLine: String;
  MyRect: TRect;
  bNoDialer: Boolean;
  sBkgdBmpFile: String;
begin
  bmpChkOn  :=  imgChkOn.Picture.Bitmap;
  bmpChkOff := imgChkOff.Picture.Bitmap;
  bSet := False;

  iniLch := TLchIniFile.Create;
  iniWsk := TWskIniFile.Create( iniLch );

  iCurrItem := -1;
  btnRemove.Enabled := False;
  btnSave.Enabled := False;
  MyRect := iniLch.ReadRect( ksConfigWndSect );

  Left := MyRect.Left;
  Top  := MyRect.Top;

  case frmLauncher.iCorner of
  kNone:
    rgbCorner.ItemIndex := 0;
  else
    rgbCorner.ItemIndex := 1;
  end;

  case frmLauncher.iOrientation of
  kSideways:
    rgbOrientation.ItemIndex := 0;
  else
    rgbOrientation.ItemIndex := 1;
  end;

  ModelLocation;

  with frmLauncher do
  begin
    for ii := 0 to ProgramObjCount-1 do
    begin
      sCmdLine := ProgramObjects[ii].CmdLine;
      iListIndex := lstPrograms.Items.Add( sCmdLine );
    end;
  end;

  { read from INI file }
  initSerialTCP;
  chkBkgd.Checked := frmLauncher.bBitmap;
  sBkgdBmpFile := iniLch.ReadString( ksLaunchWndSect, kssBkgdBmpFile, EmptyStr);
  if sBkgdBmpFile <> EmptyStr then
  begin
    fLstBkgd.ItemIndex := fLstBkgd.Items.IndexOf( sBkgdBmpFile );
  end;

  bNoDialer := iniLch.ReadBool( ksConfigWndSect, ksbNoDialer, True );
  if bNoDialer then
  begin
    TabbedNotebook1.Pages.Delete( 3 );
    TabbedNotebook1.Pages.Delete( 2 );
  end;

end;

procedure TfrmConfig.FormDestroy(Sender: TObject);
begin
  iniWsk.Free;
  iniLch.Free;
end;

{
=====================================================================
                           Programs Tab
=====================================================================
}
procedure TfrmConfig.btnBrowseClick(Sender: TObject);
begin
  with OpenDialog1 do
  begin
    HistoryList := frmLauncher.GetProgramList;
    Execute;
    edtNew.Text := FileName;
  end;
end;

{ Event occurs when lstProgram.ItemIndex changes }
procedure TfrmConfig.edtNewChange(Sender: TObject);
begin
  UpdateSaveButton;
end;

procedure TfrmConfig.RemoveCurrent;
begin
  with lstPrograms do
    if ItemIndex >= 0 then
    begin
      { Delete from INI file and program list }
      frmLauncher.DeleteProgram( Items.Strings[ ItemIndex ] );
      if iCurrItem = ItemIndex then
      begin
         Dec(iCurrItem);
         if iCurrItem = -1 then
           if Items.Count > 0 then
             iCurrItem := 0;
      end;
 {      ClearPgmBox; }
      Items.Delete( ItemIndex );
      ItemIndex := iCurrItem;
      UpdatePgmBox;
    end;
end;

procedure TfrmConfig.btnRemoveClick(Sender: TObject);
begin
  RemoveCurrent;
end;

procedure TfrmConfig.UpdateRemoveButton;
begin
  if lstPrograms.ItemIndex >= 0 then
    btnRemove.Enabled := True
  else
    btnRemove.Enabled := False;
end;

procedure TfrmConfig.UpdateSaveButton;
begin
  if edtNew.Text = EmptyStr then
     btnSave.Enabled := False
  else
     btnSave.Enabled := True;
end;

procedure TfrmConfig.ClearPgmBox;
begin
   edtNew.Text := EmptyStr;
  edtHint.Text := EmptyStr;
end;

function TfrmConfig.ValidPgmBox:Boolean;
begin
  { assume failure }
  Result := False;
  if Length( edtNew.Text ) > 0 then
  begin
    if Length( edtNew.Text ) > 120 then
      edtNew.Text := Copy( edtNew.Text, 1, 120);
    { try to load module without running it }
    Result := True;
  end;
end;

procedure TfrmConfig.btnSaveClick(Sender: TObject);
begin
  { Add to launcher list, INI file }
  if frmLauncher.AddProgram( edtNew.Text, edtHint.Text, True ) then
  begin
    { Add to list box }
    lstPrograms.Items.Insert( 0, edtNew.Text );
  end;
end;

{ Copy cmd line & Hint info to program Object AND
  to the currently highlighted line in lstPrograms
  This is the opposite of UpdatePgmBox!! }
function TfrmConfig.FlushPgmBox: Boolean;
var
  sOldCmdLine, sOldHint: String;
  pgm: TLnchProgram;
begin
  Result := False;
  pgm := GetCurrPgmObj( Self, iCurrItem, sOldCmdLine );
  if pgm <> nil then with pgm do
  begin
    sOldHint := Hint;
{    CmdLine := UpperCase( edtNew.Text ); }
    CmdLine := edtNew.Text ;
       Hint := edtHint.Text;
    { call "Update" for this pgm (See Lprogram unit }
    if Update( True ) <> kIconError then
    begin
      lstPrograms.Items.Strings[ iCurrItem ] := edtNew.Text;
      Result := True;
      frmLauncher.SetPgmString( pgm );
      frmLauncher.SetButtonPositions;
    end else
    begin
      CmdLine := sOldCmdLine;
      Hint := sOldHint;
    end;
  end;
end;

{ Copy cmd line & Hint info from program Object that corresponds
  to the currently highlighted line in lstPrograms
  This is the opposite of FlushPgmBox!! }
function TfrmConfig.UpdatePgmBox: Boolean;
var
  iNewItem: Integer;
  sCmdLine, sHint: String;
  NewProgram : TLnchProgram;
begin
{  FlushPgmBox;  }
  iNewItem := lstPrograms.ItemIndex;
  if iNewItem < 0 then
  begin
    ClearPgmBox;
  end else{ if iNewItem <> iCurrItem then }
  begin
    iCurrItem := iNewItem;
    { Lookup cmd line and Hint }
    NewProgram := GetCurrPgmObj( Self, iNewItem, sCmdLine );
    if NewProgram <> nil then
    begin
      edtNew.Text := NewProgram.CmdLine;
      edtHint.Text := NewProgram.Hint;
    end;
  end;
  frmLauncher.SetButtonPositions;
  Application.ProcessMessages;
{  lstPrograms.ItemIndex := iCurrItem; }
  UpdateRemoveButton;
end;

procedure TfrmConfig.lstProgramsKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  UpdatePgmBox;
end;

procedure TfrmConfig.lstProgramsMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  bSet := False;
  UpdatePgmBox;
end;

procedure TfrmConfig.lstProgramsClick(Sender: TObject);
var
  pgm : TLnchProgram;
  sCmdLine: String;
begin
  with lstPrograms do
  begin
    if (ItemIndex >= 0) and (ItemIndex < Items.Count) then
    begin
      if bSet and (oldX < bmpChkOn.Width) then
      { Lookup cmd line and Hint }
      pgm := GetCurrPgmObj( Self, ItemIndex, sCmdLine );
      if pgm <> nil then with pgm do
      begin
        Visible := ( not Visible );
        { update INI file using Program Object }
        Update( False );
        { because we're not changing anything but the visible
          property, we don't have to check for invalid command
          line ( ie. Update = kIconError ) or report it
          or check for duplicates. }
      end;
      Invalidate;
    end;
  end;
end;

procedure TfrmConfig.lstProgramsDrawItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
var
  bmp: TBitMap;
  sCmdLine: String;
  pgm: TLnchProgram;
begin
  bmp := bmpChkOff;
  pgm := GetCurrPgmObj( Self, Index, sCmdLine );
  if (nil <> pgm) and (pgm.Visible) then
    bmp := bmpChkOn;

  with lstPrograms.Canvas do
  begin
       Draw( Rect.Left + 1, Rect.Top + 0, bmp ); { draw bitmap }
    TextOut( Rect.Left + 3 + bmp.Width,          { position text and draw it }
             Rect.Top  + 0, sCmdLine );          { to the right of the bitmap }
  end;
end;

procedure TfrmConfig.lstProgramsMeasureItem(Control: TWinControl;
  Index: Integer; var Height: Integer);
begin
  if Height <  (bmpChkOn.Height + 2) then
     Height := (bmpChkOn.Height + 2);
end;

procedure TfrmConfig.lstProgramsKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = ' ' then
  begin
    bSet := True;
    lstProgramsClick(Sender);
    bSet := False;
  end;
end;

procedure TfrmConfig.lstProgramsMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  bSet := True;
end;

procedure TfrmConfig.edtKeyPress(var Key: Char);
begin
  case Key of
  Char(vk_Return):
    begin
      Key := #0;
      FlushPgmBox;
    end;
  Char(vk_Escape):
    begin
      Key := #0;
      ClearPgmBox;
      lstPrograms.ItemIndex := -1;
    end;
  Char(vk_Up), Char(vk_Down):
    begin
      SendMessage( lstPrograms.Handle, WM_CHAR, Word(Key), 0 );
    end;
  end;
end;

procedure TfrmConfig.edtNewKeyPress(Sender: TObject; var Key: Char);
begin
  edtKeyPress( Key );
end;
procedure TfrmConfig.edtHintKeyPress(Sender: TObject; var Key: Char);
begin
  edtKeyPress( Key );
end;

procedure TfrmConfig.edtNewExit(Sender: TObject);
var
  hDummyIcon: hIcon;
begin
  if edtNew.Text <> EmptyStr then
  begin
    if GetFileIcon( edtNew.Text, hDummyIcon ) then
    begin
      RemoveCurrent;
      btnSaveClick(Sender);
    end;
  end;
end;
procedure TfrmConfig.edtHintExit(Sender: TObject);
begin
  FlushPgmBox;
end;

{
=====================================================================
                              Screen Tab
=====================================================================
}
procedure TfrmConfig.ModelLocation;
var
  bSideways: Boolean;
  pnl: TPanel;
begin
  bSideways := (frmLauncher.iOrientation = kSideways);
  pnlSideways.Visible := bSideways;
  pnlUpAndDown.Visible := not bSideways;
  if bSideways then pnl := pnlSideways else pnl := pnlUpAndDown;

  with pnl do
  begin
    case frmLauncher.iCorner of
     kNone:
      Top := 15;
     kTopLeft, kTopRight:
      Top := 0;
     kBottomLeft, kBottomRight:
      Top := pnlScreen.Height - Height;
    end;
    case frmLauncher.iCorner of
    kNone:
        Left := 15;
    kTopLeft,  kBottomLeft:
        Left := 0;
    kTopRight, kBottomRight:
        Left := pnlScreen.Width - Width;
    end;
  end;
end;

procedure TfrmConfig.rgbCornerClick(Sender: TObject);
var
  bBottom, bRight: Boolean;
  sCorner: String;
begin
  if rgbCorner.ItemIndex = 0 then
    sCorner := ksNone
  else { Send to closest corner }
  begin
    bBottom := ( frmLauncher.Top  > (Screen.Height div 2) );
    bRight  := ( frmLauncher.Left > (Screen.Width  div 2) );
    sCorner := kasCorners[ bBottom, bRight ];
  end;
  iniLch.WriteString( ksLaunchWndSect, ksCorner, sCorner );
  frmLauncher.iCorner := kaiCorners[ bBottom, bRight ];
  ModelLocation;
  frmLauncher.SavePositionINI;
  frmLauncher.SetButtonPositions;
end;

procedure TfrmConfig.rgbOrientationClick(Sender: TObject);
var
  sOrientation: String;
begin
  case rgbOrientation.ItemIndex of
  0:
    begin
                  sOrientation := ksSideways;
      frmLauncher.iOrientation :=  kSideways;
    end;
  1:
    begin
                  sOrientation := ksUpAndDown;
      frmLauncher.iOrientation :=  kUpAndDown;
    end;
  end;
  iniLch.WriteString( ksLaunchWndSect, ksOrientation, sOrientation );
  ModelLocation;
  frmLauncher.SetButtonPositions
end;

{
=====================================================================
                         Who/How to Call Tabs
=====================================================================
}
procedure TfrmConfig.btnForget( const sErasableThing, sIdent: String );
var
  iRes: Integer;
  ini: TIniFile;
begin
  iRes := MessageDlg(
         'This causes your current ' + sErasableThing + ' to be erased'#10#13
        +'so that you can enter a new one next time you log in.'#10#13
        +#10#13
        +'Are you sure you want to erase your current ' + sErasableThing + '?',
         mtConfirmation, mbYesNoCancel, 0);

  if iRes = mrYes then
  begin
    iniWsk.WriteString( ksWVarSect, sIdent, EmptyStr );
  end;
end;

procedure TfrmConfig.btnForgetUseridClick(Sender: TObject);
begin
  btnForget( 'Userid', ksUserid );
end;

procedure TfrmConfig.btnForgetPasswordClick(Sender: TObject);
begin
  btnForget( 'password', ksPassword );
end;

procedure TfrmConfig.mskAreaCodeExit(Sender: TObject);
begin
  iniLch.WriteString( ksDialerSect, ksAreaCode, mskAreaCode.Text );
  SetPhoneNo;
end;

procedure TfrmConfig.mskPhoneExit(Sender: TObject);
begin
  iniLch.WriteString( ksDialerSect, ksPhone, mskPhone.Text );
  SetPhoneNo;
end;

procedure TfrmConfig.mskGatewayExit(Sender: TObject);
begin
  iniWsk.WriteString( ksWMainSect, ksGateway, mskGateway.Text );
end;

procedure TfrmConfig.chkDialOneClick(Sender: TObject);
begin
  iniLch.WriteBool( ksDialerSect, ksDialOne, chkDialOne.Checked );
  SetPhoneNo;
end;

procedure TfrmConfig.chkBlockCallWaitClick(Sender: TObject);
begin
  iniLch.WriteBool( ksDialerSect, ksBlockCallWait, chkBlockCallWait.Checked );
  SetPhoneNo;
end;

procedure TfrmConfig.edtPrefixChange(Sender: TObject);
begin
  iniLch.WriteString( ksDialerSect, ksPrefix, edtPrefix.Text );
  SetPhoneNo;
end;

procedure TfrmConfig.rgbComPortClick(Sender: TObject);
var
  iComPort: Integer;
begin
  iComPort := kiComPortDefault;
  if rgbComPort.ItemIndex >= 0 then
    iComPort := rgbComPort.ItemIndex;

  iniWsk.WriteInteger( ksWMainSect, ksPort, iComPort + 1 );
end;


procedure TfrmConfig.rgbBaudRateClick(Sender: TObject);
var
  iBaudIdx: Integer;
  lBaudRate: LongInt;
begin
  iBaudIdx := kiBaudDefault;
  if rgbBaudRate.ItemIndex >= 0 then
    iBaudIdx := rgbBaudRate.ItemIndex;

  lBaudRate := StrToInt( rgbBaudRate.Items[ iBaudIdx ] );
  iniWsk.WriteInteger( ksWMainSect, ksBaudRate, lBaudRate );
end;

procedure TfrmConfig.fLstBkgdChange(Sender: TObject);
begin
  with fLstBkgd do
    if Enabled and (ItemIndex >= 0) and (ItemIndex < Items.Count) then
    begin
      iniLch.WriteString( ksLaunchWndSect, kssBkgdBmpFile, Items[ ItemIndex ] );
      frmLauncher.imgBkgd.Picture.LoadFromFile( Items[ ItemIndex ] );
      frmLauncher.invalidate;
    end;
end;

procedure TfrmConfig.chkBkgdClick(Sender: TObject);
begin
  fLstBkgd.Enabled := chkBkgd.Checked;
  frmLauncher.bBitmap := chkBkgd.Checked;
  iniLch.WriteBool( ksLaunchWndSect, ksbBkgdBitmap, chkBkgd.Checked );
  if chkBkgd.Checked = True then
    fLstBkgdChange(Sender)
  else
    frmLauncher.invalidate;
end;

end.
