unit LDropOp;

interface

uses
  SysUtils, WinTypes, {WinProcs, Messages,} Classes,{ Graphics,} Controls,
{  Forms, Dialogs, IniFiles, Buttons, WinCRT, ExtCtrls,} ShellAPI;

{$DEFINE DEBUG}

type
  TDropOperation = class(TObject)
  private
    hDrop : THandle;
    iNumDroppedFiles : Integer;
    pDroppedFileName : PChar;   { Buffer for filename }
    DropFileList : TStringList;
    function GetNumDroppedFiles : Integer;
    function GetDroppedFileName( iFileNum : Integer ):String;
  public
    constructor Create( hNewDrop :THandle );
    destructor Destroy; override;
    property DroppedFileNames : TStringList read DropFileList;
  end;

implementation

uses
  LGeneral;

{ -------------- Drop Operation Class --------------  }
constructor TDropOperation.Create( hNewDrop :THandle );
var
  ii : Integer;
begin
  inherited Create;
  hDrop := hNewDrop;
  iNumDroppedFiles := GetNumDroppedFiles;
  if iNumDroppedFiles > 0 then
  begin
    pDroppedFileName := StrAlloc( kMaxCommandBufSize );
    try
      DropFileList := TStringList.Create;
      for ii := 0 to iNumDroppedFiles-1 do
      begin
        DropFileList.Add( '=' + GetDroppedFileName( ii ) );
      end;
    finally
      StrDispose( pDroppedFileName );
    end;
  end;
  DragFinish( hNewDrop );
end;

destructor TDropOperation.Destroy;
var
  ii : Integer;
begin
  for ii := 0 to DropFileList.Count-1 do
  begin
    if DropFileList.Objects[ ii ] <> nil then
    begin
      TPString(DropFileList.Objects[ ii ]).Destroy;
    end;
  end;
  DropFileList.Free;
  inherited Destroy;
end;

function TDropOperation.GetNumDroppedFiles : Integer;
var
  pFileName : PChar;
  cb : Word;
begin
  pFileName := nil;
  Result := DragQueryFile( hDrop, Word($ffff), PChar(0), 0 );
end;

function TDropOperation.GetDroppedFileName( iFileNum : Integer ):String;
var
  iNumBytes : Integer;
  hNewIcon: HIcon;
begin
  iNumBytes := DragQueryFile( hDrop, Word(iFileNum),
                              pDroppedFileName, kMaxCommandBufSize );
  Result := StrPas( pDroppedFileName );
end;

end.
