unit Lpgmlist;

interface

uses
  SysUtils, WinTypes, WinProcs, Dialogs, Buttons,
  Classes,  { for TStringList }
  Lprogram, { for TLnchProgram }
  Lgeneral; { for TLchIniFile }

type
  TPgmList = class(TStringList)
  private
    function    GetProgramCount: Integer;
    function    GetProgram( ii : Integer ):TLnchProgram;
    function LookupProgram( sCmdLine: String ) : TLnchProgram;
  public
    constructor Create( iniLch: TLchIniFile; btnConfig: TSpeedButton );
    destructor DestroyList;
    procedure AddList( NewPgmList: TStringList; bDupCheck: Boolean );
    procedure Delete( iPgm: Integer ); override;  { 0-based index into list }
    property ProgramCount: Integer read GetProgramCount;
    property ProgramObjects[ Index : Integer ] : TLnchProgram
                             read GetProgram;
    property Programs[ sCmdLine: String ] : TLnchProgram
                       read LookupProgram;
  end;

implementation

uses
  Launcher;

constructor TPgmList.Create( iniLch: TLchIniFile; btnConfig: TSpeedButton );
var
  sIniPgmList: TStringList;
  CfgBtnPgm: TLnchProgram;
begin
  inherited Create;
  try
    { Move and Add static items }
    CfgBtnPgm := TLnchProgram.Init( EmptyStr, { no Identifying name given for INI line }
                                    'DummyCmd', { given Cmd Line }
                                    'DummyHint',{ given Hint }
                                     False      { make visible button  }
                                  );
    AddObject( ksLaunchConfig, CfgBtnPgm );
    try
      sIniPgmList := TStringList.Create;
      iniLch.ReadSectionValues( ksLaunchPgmSect, sIniPgmList );
      iniLch.EraseSection( ksLaunchPgmSect );
      AddList( sIniPgmList, False );
    finally
      sIniPgmList.Free;
    end;
  except
    inherited Free;
    raise;
  end;
end;

destructor TPgmList.DestroyList;
var
  ii: Integer;
begin
  for ii := 0 to ProgramCount - 1 do
  begin
    Objects[ii].Free;
  end;
end;

{ Delete from INI file and program list }
procedure TPgmList.Delete( iPgm: Integer );
var
  pgm: TLnchProgram;
begin
  pgm := ProgramObjects[ iPgm ];
  { Remove INI line }
  pgm.RemoveProgramFromToolbarINI;
  { Destroy program object (which contains button object) }
  pgm.Destroy;
  { Release the element in the list }
  inherited Delete( iPgm );
end;

procedure TPgmList.AddList( NewPgmList: TStringList; bDupCheck: Boolean );
var
  ii: Integer;
  NewProgram : TLnchProgram;
begin
  for ii := 0 to NewPgmList.Count-1 do
  begin
    NewProgram := TLnchProgram.CreateLine( NewPgmList.Strings[ ii ] );
    { Add program, create new button - no old one to replace.
      bNew tells whether to add new INI file line }
    if NewProgram.Add( Self, bDupCheck ) then
      { Add to config screen - "Programs" tab, if visible }
      frmLauncher.UpdateConfigPgmList( NewProgram.CmdLine );
  end;
end;

function TPgmList.GetProgramCount: Integer;
begin
  Result := GetCount - 1;
end;

function TPgmList.GetProgram( ii : Integer ) : TLnchProgram;
begin
  Result := TLnchProgram( Objects[ ii ] );
end;

function TPgmList.LookupProgram( sCmdLine: String ) : TLnchProgram;
var
  ii: Integer;
  sTmp: String;
begin
  Result := nil;
{  ii := IndexOf( UpperCase( sCmdLine ) );
  if ii >= 0 then
    Result := TLnchProgram( Objects[ ii ] ); }
  for ii:=0 to ProgramCount - 1 do
  begin
    sTmp := UpperCase( Strings[ ii ] );
    if sTmp = UpperCase( sCmdLine ) then
    begin
      Result := TLnchProgram( Objects[ ii ] );
      break;
    end;
  end;
end;

end.
