{---------------------------------------------------------------------------

       PROJECT: DataControl extensions
         TITLE: TTableKeyMover
      SUBTITLE:

       VERSION: 1.00

  DATE STARTED: 1st June 1995
  DATE UPDATED:

        AUTHOR: (c) UK 1995 Matthew Page.
                All Rights Reserved

		This code is released as FREEWARE, and if it goes wrong,
		don't blame me!
                        ** Enjoy! **

                "Keep those Delphi components coming and let's
                 smash VB into the ground!"

         NOTES: This object was designed for forms created with the
                database form expert. It allows keyboard naviagtion
                of the table requested with the PgUp and PgDn keys.
                Shift key combinations will move by MoveBy records,
                and Ctrl key combinations will take you to the first
                and the last records of the table.

                Ensure that the Forms KeyPreview is True to use.
                Simply slap this non-visual component on the form
                and hook up the DataSet value, and that's it!!

     TECHNICAL: You will notice that only the Form can have a KeyPreview
                property, so you need to 'hack' it in with messages.
                To do this, this object assigns its own OnKeyDown event
                to whatever the form had. It then hooks in HandleKeyDown
                into the Forms OnKeyDown event. Hey presto! That's it.
                The HandleKeyDown checks the keys, and responds appropriately,
                navigating the table, even if the current focus is on a
                field.

                One slight piece of interest: The Destroy event must
                unhook the event, otherwise deleting the visual component
                will cause a GPF because the Form's OnKeyDown would point
                into the wild blue yonder of the unitialised heap!
                (It caught me out on the first attempt!!!!)

----------------------------------------------------------------------------}
unit Keymover;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DBTables, DB;

type
  TTableKeyMover = class(TComponent)
  private
    { Private declarations }
    VNoMove : INTEGER;
    VTable : TTable;
    FOnKeyDown : TKeyEvent;
    TheForm    : TForm;
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
    procedure HandleKeyDown(Sender : TObject;
                            var Key : WORD; Shift : TShiftState);
  published
    { Published declarations }
    property DataSet : TTable read VTable write VTable;
    property OnKeyDown : TKeyEvent read FOnKeyDown write FOnKeyDown;
    property MoveBy : INTEGER read VNoMove write VNoMove default 5;
  end;

procedure Register;

implementation

constructor TTableKeyMover.Create(AOwner : TComponent);
begin
 inherited Create(AOwner);
 IF AOwner is TForm                          {Just checking....}
 THEN BEGIN
       TheForm := AOwner as TForm;           {Keep this for later}
       OnKeyDown := TheForm.OnKeyDown;       {Store the old}
       TheForm.OnKeyDown := HandleKeyDown;   {Activate the new}
      END;
 MoveBy := 5;                                {To correspond to the default
                                              setting in the methods}
end;

destructor TTableKeyMover.Destroy;
begin
 TheForm.OnKeyDown := FOnKeyDown;            {Unhook the key handler}
 inherited Destroy;                          {Carry on with the original}
end;

procedure TTableKeyMover.HandleKeyDown(Sender : TObject;
                            var Key : WORD; Shift : TShiftState);
begin
 IF Assigned(VTable)                         {Just checking...}
 THEN BEGIN
       CASE Key OF                           {Check key stroke and act}
        vk_next  : BEGIN
                    IF Shift = [ssShift]
                    THEN VTable.MoveBy(MoveBy)
                    ELSE
                    IF Shift = [ssCtrl]
                    THEN VTable.Last
                    ELSE VTable.MoveBy(1);
                    Key := 0;                 {Clear the key stroke}
                   END;
        vk_prior : BEGIN
                    IF Shift = [ssShift]
                    THEN VTable.MoveBy(-MoveBy)
                    ELSE
                    IF Shift = [ssCtrl]
                    THEN VTable.First
                    ELSE VTable.MoveBy(-1);
                    Key := 0;
                   END;
        END;
      END;                                     {Finally, do the old...}
 IF Assigned(FOnKeyDown) THEN FOnKeyDown(Sender, Key, Shift);
end;

procedure Register;
begin
  RegisterComponents('Data Controls', [TTableKeyMover]);
end;

end.
