unit Unit1;

{ Doubly linked list demo form for TList object }
{ by Jeff Atwood, JAtwood159@AOL.COM. }
{ }
{ See comments in the TLink unit. }

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Tlink, StdCtrls;

type
  TForm1 = class(TForm)
    ListBox1: TListBox;
    GroupBox1: TGroupBox;
    Edit1: TEdit;
    radTop: TRadioButton;
    radMiddle: TRadioButton;
    radBottom: TRadioButton;
    btnDel: TButton;
    Label1: TLabel;
    Label2: TLabel;
    btnAdd: TButton;
    btnFind: TButton;
    Label4: TLabel;
    Label5: TLabel;
    btnCancel: TButton;
    Label3: TLabel;
    lblCount: TLabel;
    Label6: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnAddClick(Sender: TObject);
    procedure btnFindClick(Sender: TObject);
    procedure btnDelClick(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
  private
    procedure FillList(listbox: TListBox; list: TList);
    function SyncList(listbox: TListBox; list: TList): Boolean;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  List1: TList;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  List1 := TList.Create;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  List1.Free;
end;

procedure TForm1.btnAddClick(Sender: TObject);
var
  temp: integer;
begin
  temp := StrtoInt(Edit1.Text);

  { add the item }
  if radTop.Checked then
    List1.InsertTop(temp);
  if radBottom.Checked then
    List1.InsertBottom(temp);
  if radMiddle.Checked then begin
    SyncList(ListBox1, List1);
    List1.InsertCurrent(temp);
  end;

  { refresh display }
  FillList(ListBox1, List1);
  lblCount.Caption := inttostr(List1.GetSize);

  { increment data }
  Edit1.Text := IntToStr(temp + 1);
end;

procedure TForm1.btnFindClick(Sender: TObject);
var
  retval: Integer;
  loc: longint;
begin
  if List1.FindFirst(StrToInt(Edit1.Text), loc) then
    showmessage('Item ' + Edit1.Text + ' is at position ' + intToStr(loc))
  else
    showmessage('Item ' + Edit1.Text + ' not in list.');
end;

procedure TForm1.btnDelClick(Sender: TObject);
begin
  if SyncList(ListBox1, List1) then begin
    List1.Delete;
    { refresh display }
    FillList(ListBox1, List1);
    lblCount.Caption := inttostr(List1.GetSize);
  end;
end;

procedure TForm1.btnCancelClick(Sender: TObject);
begin
  Close;
end;

{ seeks the same item in the TList as in the TListbox }
{ Absolute position in the listbox = absolute         }
{ position in the list. If that isn't so, this will   }
{ fail miserably. }
function TForm1.SyncList(listbox: TListBox; list: TList): Boolean;
var
  curItem: Integer;
begin
  result := False;
  curItem := listbox.ItemIndex;
  if curItem < 0 then
    exit;
  if not list.Seek(curItem + 1) then
    exit;
  result := True;
end;

{ fill a list box with TList entries }
procedure TForm1.FillList(listbox: TListBox; list: TList);
var
  temp: Integer;
  olditem: Integer;
begin
  { save old position so we don't lose it }
  olditem := listbox.ItemIndex;
  { clear the list box }
  listbox.Clear;

  { get the last item in list if any }
  if not list.MoveFirst then begin
    exit
    end
  else begin
    if list.GetData(temp) then begin
      listbox.Items.Add(IntToStr(temp));
    end;
  end;

  { get subsequent list items if any }
  while list.MoveNext do begin
    if list.GetData(temp) then begin
      listbox.Items.Add(IntToStr(temp));
    end;
  end;

  { reset position }
  if olditem < listbox.Items.Count then
    listbox.ItemIndex := olditem
  else
    listbox.ItemIndex := listbox.Items.Count - 1;

end;

end.
