unit Scroller;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, wincrt;

type
  TScroller = class(TGraphicControl)
  private
    { Private-Deklarationen }
    FScrollPos:Byte;
    FScrollPixelPos:Byte;
    FScrollPixelWay:Byte;
    FScrollField:String;
    FScrollText:String;
    constructor create(aowner:TComponent); override;
    procedure paint; override;
  protected
    { Protected-Deklarationen }
  public
    { Public-Deklarationen }
    procedure DoScroll; virtual;
    procedure Redraw; virtual;
  published
    { Published-Deklarationen }
    property Align;
    property Font;
    property OnClick;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property ScrollText:String read FScrollText write FScrollText;
    property ShowHint;
  end;

procedure Register;

implementation

constructor tscroller.create;
begin
  inherited create(aowner);
  fscrollpos:=1;
  fscrollpixelpos:=0;
  fscrollpixelway:=3;
  fscrollfield:='';
end;

procedure tscroller.paint;
var
  bitmap:tbitmap;
  y:word;
begin
  bitmap:=tbitmap.create;
  try
    bitmap.height:=height;
    bitmap.width:=width;
    bitmap.canvas.pen.color:=clBlack;
    bitmap.canvas.brush.color:=clBlack;
    bitmap.canvas.rectangle(0,0,width,height);
    bitmap.canvas.font.assign(font);
    y:=(height-canvas.textheight(fscrollfield)) div 2;
    bitmap.canvas.textout(-integer(fscrollpixelpos),y,fscrollfield);
    canvas.draw(0,0,bitmap);
  finally
    bitmap.free;
  end;
end;

procedure tscroller.doscroll;
var
  ch:char;
begin
  if fscrollfield='' then begin
    canvas.font.assign(font);
    fscrollfield:='';
    while canvas.textwidth(fscrollfield)<width do fscrollfield:=fscrollfield+' ';
  end;
  inc(fscrollpixelpos);
  if fscrollpixelpos=fscrollpixelway then begin
    if length(fscrolltext)=0 then ch:=' ' else begin
      ch:=fscrolltext[fscrollpos];
      inc(fscrollpos);
      if fscrollpos>length(fscrolltext) then fscrollpos:=1;
    end;
    fscrollfield:=copy(fscrollfield,2,255)+ch;
    fscrollpixelpos:=0;
    canvas.font.assign(font);
    fscrollpixelway:=canvas.textwidth(fscrollfield[1]);
  end;
end;

procedure tscroller.redraw;
begin
  paint;
end;

procedure Register;
begin
  RegisterComponents('Laschat', [TScroller]);
end;

end.
