unit Starfld;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs;

const
  maxStars=1000;
  augenabstand:longint=200;

type
  TStarField = class(TGraphicControl)
  private
    { Private-Deklarationen }
    FNumStars:Word;
    FZoomFactor:Integer;
    FStarfield:array[1..maxStars] of record
      x,y,z:single;
    end;
    FStarfieldGenerated:Boolean;
    FStarsNeedWrap:Boolean;
    constructor create(aowner:tcomponent); override;
    destructor destroy; override;
    procedure paint; override;
    procedure wrapstars; virtual;
  protected
    { Protected-Deklarationen }
  public
    { Public-Deklarationen }
    procedure movestars(mx,my,mz:integer); virtual;
    procedure turnstars(wx,wy,wz:integer); virtual;
    procedure redraw; virtual;
  published
    { Published-Deklarationen }
    property NumStars:Word read FNumStars write FNumStars default 100;
    property OnClick;
    property ZoomFactor:Integer read FZoomFactor write FZoomFactor default 100;
  end;

procedure Register;

implementation

constructor tstarfield.create;
begin
  inherited create(aowner);
  fnumstars:=100;
  fzoomfactor:=100;
  fstarfieldgenerated:=false;
  fstarsneedwrap:=true;
end;

destructor tstarfield.destroy;
begin
  inherited destroy;
end;

procedure tstarfield.paint;
const
  grays:array[0..15] of longint=(
    $ffffff,$ffffff,$ffffff,$ffffff,
    $eeeeee,$dddddd,$cccccc,$bbbbbb,
    $aaaaaa,$999999,$888888,$777777,
    $555555,$333333,$111111,$000000
  );
var
  bitmap:tbitmap;
  i:integer;
  rx,ry:integer;
  xmid,ymid:integer;
  azoomfactor:single;
begin
  if not fstarfieldgenerated then begin
    if fnumstars>maxstars then fnumstars:=maxstars;
    for i:=1 to fnumstars do with fstarfield[i] do begin
      x:=integer(random(2000))-1000;
      y:=integer(random(2000))-1000;
      z:=integer(random(2000));
    end;
    fstarfieldgenerated:=true;
  end;
  if fstarsneedwrap then wrapstars;
  bitmap:=tbitmap.create;
  try
    bitmap.width:=width;
    bitmap.height:=height;
    azoomfactor:=fzoomfactor/100;
    if fstarfieldgenerated then begin
      xmid:=width div 2;
      ymid:=height div 2;
      bitmap.canvas.brush.color:=$000000;
      bitmap.canvas.rectangle(0,0,width,height);
      for i:=1 to fnumstars do with fstarfield[i] do begin
        if z>0 then begin
          rx:=round(xmid+(augenabstand*x/z)*azoomfactor);
          ry:=round(ymid+(augenabstand*y/z)*azoomfactor);
          setpixel(bitmap.canvas.handle,rx,ry,grays[round(z*15/2000)]);
        end;
      end;
    end;
    canvas.draw(0,0,bitmap);
  finally
    bitmap.free;
  end;
end;

procedure tstarfield.wrapstars;
var
  i:integer;
begin
  if fstarfieldgenerated then begin
    for i:=1 to fnumstars do with fstarfield[i] do begin
      while x<-1000 do x:=x+2000;
      while x>1000 do x:=x-2000;
      while y<-1000 do y:=y+2000;
      while y>1000 do y:=y-2000;
      while z<=0 do z:=z+2000;
      while z>2000 do z:=z-2000;
    end;
    fstarsneedwrap:=false;
  end;
end;

procedure tstarfield.movestars;
var
  i:integer;
begin
  if fstarfieldgenerated then begin
    for i:=1 to fnumstars do with fstarfield[i] do begin
      x:=x+mx;
      y:=y+my;
      z:=z+mz;
    end;
    fstarsneedwrap:=true;
  end;
end;

procedure tstarfield.turnstars;
var
  i:integer;
  h,
  sinx,cosx,
  siny,cosy,
  sinz,cosz:single;
begin
  if fstarfieldgenerated then begin
    sinx:=sin(wx*pi/180);
    cosx:=cos(wx*pi/180);
    siny:=sin(wy*pi/180);
    cosy:=cos(wy*pi/180);
    sinz:=sin(wz*pi/180);
    cosz:=cos(wz*pi/180);
    for i:=1 to fnumstars do with fstarfield[i] do begin
      z:=z-1000;
      h:=cosx*y-sinx*z;
      z:=sinx*y+cosx*z;
      y:=h;

      h:=cosy*x-siny*z;
      z:=siny*x+cosy*z;
      x:=h;

      h:=cosz*x-sinz*y;
      y:=sinz*x+cosz*y;
      x:=h;
      z:=z+1000;
    end;
    fstarsneedwrap:=true;
  end;
end;

procedure tstarfield.redraw;
begin
  paint;
end;

procedure Register;
begin
  RegisterComponents('Laschat', [TStarField]);
end;

end.
