{$X+}
unit Threads;

interface

Uses classes, wintypes, winprocs;

var
  MasterSerialNumber : Word;
  Count, Current : Word;

Type
  TThread=Procedure;

  PThreadRecord = ^TThreadRecord;
  TThreadRecord = Class(TPersistent)
  public
    StackHandle : THandle;
    StackBottom, StackOrigin, StackTop : Pointer;
    SerialNumber : word;
    Thread : TThread;
    MinSlice : longint;
    Constructor create(StackSize : Word; NewThread : TThread; Slice : Longint);
    Destructor destroy; Virtual;
  end;

Procedure NewThread(NThread : TThread; StackSize : Word; Slice : longint);
Procedure SwitchThread;
Procedure SwitchThreadNow;
Procedure Sleep(t : longint);

implementation
var
    FreshThreadRecord : TThreadRecord; { The stack being spawned }
    FreshThread : TThread; { The thread being spawned }
    CurrentThread : TThreadRecord;
    StartTicks : longint; { time current thread switched in }
    OSS : Word;
    OSP : Word;
    NSS : Word;
    NSP : Word;
    CCS : Word; { Temp storage for RET address }
    CIP : Word;
    TBP : Word; { Temp BP }
    SSeg : Word; { Self }
    SOfs : Word;
    Threads : TList; { array of stacks? }
    RootTask : TThreadRecord;
    KillThread : Boolean;

Procedure InitFork(NThreadRecord : TThreadRecord); forward;

Constructor TThreadRecord.create;
begin
  Inherited create;
  MinSlice:=Slice;
  If StackSize<>0 then
    begin
      StackHandle:=GlobalAlloc(GPTR,StackSize);
      StackBottom:=GlobalLock(StackHandle);
      StackOrigin:=ptr(seg(StackBottom^),ofs(StackBottom^)+StackSize);
      {  Ptr(StackSelector,StackSize);}
      StackTop:=StackOrigin;
      Thread:=NewThread;
      { Both point to end of stack... }
    end;
  SerialNumber:=MasterSerialNumber; Inc(MasterSerialNumber);
end;

Destructor TThreadRecord.destroy;
begin
  GlobalUnlock(StackHandle);
  GlobalFree(StackHandle);
  Inherited destroy;
end;

Procedure KillTask; forward;

Procedure InitFork;
begin
  NSS:=Seg(NThreadRecord.StackTop^);
  NSP:=Ofs(NThreadRecord.StackTop^);
  FreshThread:=NThreadRecord.Thread;
end;

{ $S-}{$F+}
Function Fork : Boolean; assembler;
asm
    { Grab the return Address }
    Pop CIP
    Pop CCS

    Push CCS
    Push CIP

    { Setup current stack for return... }
    Mov AX,0 { False }
    Push AX
    Push BX
    Push CX
    Push DX
    Push DI
    Push SI
    Push DS
    Push ES
    Push BP
    PushF
    { Make a note of SS and SP }
    Mov OSS,SS
    Mov OSP,SP
    { Now Switch Stack }
    CLI
    Mov SS,NSS
    Mov SP,NSP
    STI
    { Now prepare Return address }
    Push CCS
    Push CIP
    { Now prepare result = we ARE the new thread }
    Mov AX,1 { True }
    { Now OSx NSx Cxx are free again... }
    { We should have our fake BP on the stack... but as we are a new stack.. }
    { Make up BP }
end;

Procedure NewThread;
begin
  FreshThreadRecord:=TThreadRecord.create(StackSize,NThread,Slice);
  Threads.Add(FreshThreadRecord);
  Count:=Threads.Count;
  { Prepeare for switch }
  InitFork(FreshThreadRecord);
  If Fork then
    begin
      { We are now running under a different stack }
      { BTW our BP is now nonsense - luckily we don't return anywhere! }
      { We always switch in first, fix the other task to be switched out }
      { CURRENT is the number of our parent task who we have switched out }

      { Save out parents data as we switch him out }
      CurrentThread.StackTop:=Ptr(OSS,OSP);

      { Switch ourselves in }
      Current:=Threads.Count-1;
      CurrentThread:=Threads.Items[Current];
      StartTicks:=GetTickCount;

      { Run the code }
      FreshThread;

      { and die }
      KillTask;
    end;
end;

{ $S-}{$F+}
Procedure KillTask;
begin
  KillThread:=True;
  SwitchThreadNow;
end;

Procedure SwitchThread;
begin
  If GetTickCount>=StartTicks+CurrentThread.MinSlice then
    SwitchThreadNow;
end;

Procedure SwitchThreadNow;
begin
  asm
    { First grab back our BP }
    Mov SP,BP
    Pop BP
    Push AX
    Push BX
    Push CX
    Push DX
    Push DI
    Push SI
    Push DS
    Push ES
    Push BP
    PushF
    Mov OSS,SS
    Mov OSP,SP
  end;
  { Now switch... }

  { Save current stack details }
  CurrentThread.StackTop:=Ptr(OSS,OSP);
  { Check if we kill this task... }
  If KillThread then
    begin
      If Current<>0 then { never kill root task }
        begin
          Threads.Delete(Current);
          CurrentThread.Free;
          Threads.Pack;
        end;
      KillThread:=False;
    end;
  Count:=Threads.Count;

  { change task records }
  Inc(Current); If Current>=Count then Current:=0;
  CurrentThread:=Threads.Items[Current];

  { prepare stack details of next stack }
  NSS:=Seg(CurrentThread.StackTop^);
  NSP:=Ofs(CurrentThread.StackTop^);

  StartTicks:=GetTickCount;

  { and switch in }
  asm
    CLI
    Mov SP,NSP
    Mov SS,NSS
    STI
    PopF
    Pop BP
    Pop ES
    Pop DS
    Pop SI
    Pop DI
    Pop DX
    Pop CX
    Pop BX
    Pop AX
    { Re-make the mess for pascal to undo }
    Push BP
    Mov BP,SP
  end;
end;

Procedure Sleep;
var
  s : longint;

begin
  s:=GetTickCount+t;
  while GetTickCount<s do
    switchthreadnow;
end;

begin
  RootTask:=TThreadRecord.Create(0,nil,0);
  Threads:=TList.create;
  MasterSerialNumber:=1;
  Current:=0;
  Count:=Threads.Count;
  KillThread:=False;
  RootTask.StackOrigin:=nil;
  RootTask.StackTop:=Nil; { this will get filled in when se fisrt switch out }
  RootTask.SerialNumber:=0;
  RootTask.Thread:=nil;
  Threads.Add(RootTask);
  CurrentThread:=RootTask;
  StartTicks:=Gettickcount;
end.