unit Unit1;
{Example app can task switch using OnIdle or a timer}
{Undefine USETIMER to use OnIdle}
{$DEFINE USETIMER}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Dialogs, mtbase, StdCtrls, Spin, forms, unit2, ExtCtrls;

type
  TForm1 = class(TForm)
    L1: TLabel;
    Et1: TCheckBox;
    Button1: TButton;
    l2: TLabel;
    et2: TCheckBox;
    Button2: TButton;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    TS: TLabel;
    TC: TLabel;
    MinSlice: TLabel;
    SpinButton1: TSpinButton;
    Button3: TButton;
    RadioButton1: TRadioButton;
    Button4: TButton;
    Label3: TLabel;
    Timer1: TTimer;
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure AppIdle(Sender: TObject; var Done: Boolean);
    procedure Button1Click(Sender: TObject);
    procedure SpinButton1DownClick(Sender: TObject);
    procedure SpinButton1UpClick(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

  TTask2 = Class(TThread)
    Procedure Run; override;
  end;

var
  Form1: TForm1;
  Task2 : TTask2;

implementation

{$R *.DFM}

Procedure TTask1Run; far;
var
  t : integer;
  EE : Exception;
begin
  try
    repeat
      If CurrentId<>0 then
        SwitchThread
      else
        Application.ProcessMessages;
      sleep(20);
      Form1.l1.caption:=IntToStr(StrToInt(Form1.l1.caption)+1);
      form1.radiobutton1.checked:=not form1.radiobutton1.checked;
      If Form1.l1.caption='200' then
        raise exception.create('200 error');
    until Form1.et1.checked;
  except
    On E: Exception do
      begin
        ee:=e;
        t:=1;
      end;
  end;
end;

Procedure TTask2.Run;
var
  t : longint;
begin
  repeat
    SwitchThread;
{    sleep(500);}
    t:=GetTickCount;
    While GetTickCount<t+500 do SwitchThread;
    Form1.l2.caption:=IntToStr(StrToInt(Form1.l2.caption)+1);
    Form1.MinSlice.Caption:=IntToStr(MinSlice);
  until Form1.et2.checked;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  r : longint;
begin
  r:=NewThread(Task2);
  If r<0 then showmessage('Error: '+teError(R));
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Application.OnIdle := AppIdle;
  Task2:=TTask2.Create(50,16384,tsPrivate);
end;

procedure TForm1.AppIdle(Sender: TObject; var Done: Boolean);
begin
  UpDateThreadMonitor;
  {$IFNDEF USETIMER}
  SwitchThreadNow;
  {$ENDIF}
  TC.Caption:=IntToStr(ThreadCount);
  TS.Caption:=IntToStr(LastSerialNumber);
  Done:=False;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  r : longint;
begin
  r:=ThreadProcedure(TTask1Run,{StackTop-}8192,100,tsPrivate);
  if r<0 then ShowMessage('Error: '+teError(r));
end;

procedure TForm1.SpinButton1DownClick(Sender: TObject);
begin
  If task2.MinSlice>10 then
    Task2.MinSlice:=Task2.MinSlice-10
  else
    Task2.Minslice:=0;
end;

procedure TForm1.SpinButton1UpClick(Sender: TObject);
begin
  Task2.MinSlice:=Task2.MinSlice+10;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  Raise Exception.Create('BAD ERROR');
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  TTask1Run;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  {$IFDEF USETIMER}
  If CurrentId=0 then
    SwitchThreadNow;
  {$ENDIF}
end;

end.
