unit Unit2;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, mtbase;

type
  TThreadMonitor = class(TForm)
    GroupBox1: TGroupBox;
    ThreadList: TListBox;
    Label1: TLabel;
    vThreadCount: TLabel;
    Label3: TLabel;
    vLastSerialNumber: TLabel;
    Label5: TLabel;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ThreadMonitor: TThreadMonitor;

Procedure UpDateThreadMonitor;

implementation

{$R *.DFM}

Procedure UpDateThreadMonitor;
const
  oThreadCount : longint=-1;
  oLastSerialNumber : longint=-1;
  oTicks :longint=0;
var
  nThreadCount, nLastSerialNumber, nTicks : longint;
  ctid : longint;
  ct : TThread;
  cts : string;
begin
  nThreadCount:=ThreadCount;
  nLastSerialNumber:=LastSerialNumber;
  nTicks:=GetTickCount;
  if (oThreadCount<>nThreadCount) or
     (oLastSerialNumber<>nLastSerialNumber) or
     (oTicks<(nTicks-500)) then
     begin
       oThreadCount:=nThreadCount;
       oLastSerialNumber:=nLastSerialNumber;
       oTicks:=nTicks;
       { updatedisplay on this count }
       ThreadMonitor.vThreadCount.Caption:=IntToStr(nThreadCount);
       ThreadMonitor.vLastSerialNumber.Caption:=IntToStr(nLastSerialNumber);
       { now blank listbox }
       while ThreadMonitor.ThreadList.Items.Count<>0 do
         ThreadMonitor.ThreadList.Items.Delete(0);
       { now get thread info and add it }
       for ctid:=0 to nThreadCount-1 do
         begin
           ct:=GetThreadByCount(ctid);
           cts:=(ct as TObject).ClassName;
           cts:=copy(cts+'               ',1,25);
           cts:=cts+IntToStr(ct.SerialNumber)+' '+IntToStr(ct.MinSlice);
           cts:=cts+' '+IntToStr(ct.LastSlice);
           ThreadMonitor.ThreadList.Items.Add(cts);
         end;

     end;
end;

end.
