{A small program to extract GIF's etc from the Netscape
  cache directory}

{Released into the public domain by Scott May:
scottmay@gil.ipswichcity.qld.gov.au}

{If it doesn't work for you, let me know...}

{Known Bugs:

- Can't handle long file names.

}

unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, FileCtrl, Gauges, ExtCtrls;

type
  TForm1 = class(TForm)
    SrcDirList: TDirectoryListBox;
    SrcDrive: TDriveComboBox;
    SrcDir: TEdit;
    Label1: TLabel;
    DestDrive: TDriveComboBox;
    DestDirList: TDirectoryListBox;
    DestDir: TEdit;
    Label2: TLabel;
    RunBtn: TButton;
    ExitBtn: TButton;
    CancelBtn: TButton;
    Gauge1: TGauge;
    Memo1: TMemo;
    Panel1: TPanel;
    procedure FormCreate(Sender: TObject);
    procedure SrcDirListChange(Sender: TObject);
    procedure DestDirListChange(Sender: TObject);
    procedure ExitBtnClick(Sender: TObject);
    procedure RunBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure Panel1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  stop: boolean;

implementation

{$R *.DFM}

{Misc utility type functions}

function FileCopy(source,dest: String): Boolean;
var
  fSrc,fDst,len: Integer;
  size: Longint;
  buffer: packed array [0..2047] of Byte;
begin
  Result := False; { Assume that it WONT work }
  if source <> dest then begin
    fSrc := FileOpen(source,fmOpenRead);
    if fSrc >= 0 then begin
      size := FileSeek(fSrc,0,2);
      FileSeek(fSrc,0,0);
      fDst := FileCreate(dest);
      if fDst >= 0 then begin
        while size > 0 do begin
          len := FileRead(fSrc,buffer,sizeof(buffer));
          FileWrite(fDst,buffer,len);
          size := size - len;
        end;
        FileSetDate(fDst,FileGetDate(fSrc));
        FileClose(fDst);
        FileSetAttr(dest,FileGetAttr(source));
        Result := True;
      end;
      FileClose(fSrc);
    end;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  SrcDir.Text := SrcDirList.Directory;
  DestDir.Text := DestDirList.Directory;
  CancelBtn.Visible := False;
  Gauge1.Visible  := False;
  stop := false;
end;

procedure TForm1.SrcDirListChange(Sender: TObject);
begin
  SrcDir.Text := SrcDirList.Directory;
end;

procedure TForm1.DestDirListChange(Sender: TObject);
begin
  DestDir.Text := DestDirList.Directory;
end;

procedure TForm1.ExitBtnClick(Sender: TObject);
begin
  close;
end;

procedure TForm1.RunBtnClick(Sender: TObject);
var myList: TStringList;
    i: longint;
    str: string;
    src,dest: string;
    numfiles: longint;
    b,b1: byte;
begin
  if NOT FileExists(SrcDir.Text+'\fat') then begin
    showmessage('No FAT found in src dir');
    exit;
  end;
  numfiles := 0;
  myList := TStringList.Create;
  myList.LoadFromFile(SrcDir.Text+'\fat');
  CancelBtn.Visible := True;
  Gauge1.Visible  := True;
  Update;
  for i:=1 to myList.Count-1 do begin
    {strip out the real filename}
    str := myList[i];
    delete(str,1,22);
    b := pos(#9,str);
    src := copy(str,1,b-1);
    delete(str,1,b);
    b := pos(#9,str);
    dest := copy(str,6,b-6);
    for b1 := 1 to length(dest) do
      if dest[b1] = '/' then dest[b1] := '\';
    {look to see if it is a picture}
    b := pos('.gif',dest);
    {not gif, try another}
    if b=0 then b := pos('.jpg',dest);
    {keep adding more here if you want...}
    if b=0 then b := pos('.pcx',dest);
    if b<>0 then begin  {found something}
      b1 := b;
      while (dest[b1] <> '\') do
        dec(b1);
      dest := DestDir.Text+'\'+ExtractFileName(dest);
      if NOT FileExists(dest) then begin
        if NOT FileCopy(src,dest) then begin
          Memo1.Lines.Add('Error copying '+ExtractFileName(dest));
        end
        else Inc(NumFiles);
        Application.ProcessMessages; {give everyone else a go}
      end;
      Gauge1.Progress := (100 * i) div myList.Count-1;
      if stop then begin
        myList.Free;
        CancelBtn.Visible := False;
        Gauge1.Visible  := False;
        stop := false;
        Memo1.Lines.Add('Copied '+IntToStr(NumFiles)+' new files.');
        exit;
      end;
    end;
  end;
  myList.Free;
  CancelBtn.Visible := False;
  Gauge1.Visible  := False;
  stop := false;
  Memo1.Lines.Add('Copied '+IntToStr(NumFiles)+' new files.');
end;

procedure TForm1.CancelBtnClick(Sender: TObject);
begin
  stop := true;
end;

{this next bit just for fun}
procedure TForm1.Panel1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  if ssLeft in Shift then
    Memo1.Height := Memo1.Height - Y;
end;

end.
