{$A+,B-,D-,F-,G+,I-,K+,L-,N+,P+,Q-,R-,S-,T-,V-,W-,X+,Y-}
{ $IFDEF DEBUG_ALL}
  {$D+,L+,Y+}
{ $ENDIF}
UNIT ExtObjects;

{ ExtObjects unit V1.0 Copyright by Fink Guy

  Purpose	: Extend the TObject-Class

  This unit is freeware.

  USE AT YOUR OWN RISK! No garantees expressed or implied.

  The autor is not responsible for any damages resulting from the use
  of the routines in this unit.

  You are free to distribute this unit in an unmodified form and without any
  charges other than those necessary for the needed media and the copy costs.
  Please do not distribute modified versions.

  THIS UNIT IS NOT PUBLIC DOMAIN!!! }

{$C Moveable, PreLoad, Permanent}

INTERFACE

TYPE
  TExtendedObject	= CLASS(TObject)
  PUBLIC

{ Destroy calls ClearData before it destroys the object. So it is not necessary to
  overide this destructor in derived classes. Only ClearData must be implemented. }
    DESTRUCTOR Destroy; OVERRIDE;

{ ClearData clears the object's data space. Any dynamic fields must be disposed
  BEFORE the inherited method is called !!!. It is possible that the instance has been
  already cleared when this procedure is called, so carefully check all pointers !
  This procedure has only to be overritten if the child class uses dynamic fields. }
    PROCEDURE ClearData; VIRTUAL;

{ CloneFrom creates an object, and initializes it with the data from Source. Source has
  not to be from same type, but may be one of the object's anchestors. If DupDynamicData
  is true CloneFrom uses Source.DupData2(Self) to duplicate any dynamic fields in the
  object, else it uses Source.CopyData2(Self) and pointers will point to the same location
  in both objects. }
    CONSTRUCTOR CloneFrom(	Source		: TExtendedObject;
				DupDynamicData	: BOOLEAN);

{ Duplicate creates a new object of same type and initializes it with the data from Self.
  If DupDynamicData is true Duplicate uses DupData2 to duplicate any dynamic fields in
  the object, else it uses CopyData2 and dynamic fields will point to the same location
  in both objects. }
    FUNCTION Duplicate(DupDynamicData : BOOLEAN) : TExtendedObject;

{ CopyData2 simply copies the dataspace from Self to Destination. Destination has not to
  be from same type, but may be a derived class. In this case only the known dataspace
  is copied. It is the callers responsibility to garantee that no dynamic fields in
  Destination are overritten !!! }
    FUNCTION CopyData2(Destination	: TExtendedObject) : BOOLEAN;

{ DupData2 duplicates the data from Self to Destination. Dynamic fields must be duplicated.
  If DupData2 is overitten it must FIRST call the inherited method !!! The DupData2 method
  from TExtendedObject uses CopyData2 to produce a copy of all pointers in the object.
  These pointers can be used to create a new instances of the dynamic fields.
  This procedure has only to be overritten if the child class uses dynamic fields. }
    FUNCTION DupData2(Destination	: TExtendedObject) : BOOLEAN; VIRTUAL;

{ MoveData2 uses CopyData2 to copy the data from Self to Destination. Thereafter it calls
  InitInstance to clear the object's dataspace and ClearData to make the object know that
  it has been cleared. }
    FUNCTION MoveData2(Destination	: TExtendedObject) : BOOLEAN;
  END;


IMPLEMENTATION

DESTRUCTOR TExtendedObject.Destroy;

BEGIN
  ClearData;
  INHERITED Destroy;
END;

CONSTRUCTOR TExtendedObject.CloneFrom(	Source		: TExtendedObject;
					DupDynamicData	: BOOLEAN);

VAR
  Result : BOOLEAN;

BEGIN
  IF Source = NIL THEN
    FAIL;
  IF DupDynamicData THEN
    Result	:= Source.DupData2(Self)
  ELSE
    Result	:= Source.CopyData2(Self);
  IF NOT Result THEN
    FAIL;
END;

FUNCTION TExtendedObject.Duplicate(DupDynamicData : BOOLEAN) : TExtendedObject;

BEGIN
  Result := TExtendedObject(Self.NewInstance);
  IF DupDynamicData THEN
  BEGIN
    IF NOT DupData2(Result) THEN
    BEGIN
      Result.Free;
      Result	:= NIL;
    END;
  END ELSE
    CopyData2(Result);
END;

FUNCTION TExtendedObject.CopyData2(Destination	: TExtendedObject) : BOOLEAN; ASSEMBLER;

ASM
	LES	DI,Destination
	MOV	AX, ES
	OR	AX, DI
	JZ	@@1			{ Destination = NIL }
	LES	DI, ES:[DI]		{ Call a class function later }
	MOV	DX, ES                  { Save the pointer to Destination.ClassType }
	MOV	AX, DI
	LES	DI, Self
	LES	DI, ES:[DI]		{ ES:DI = Self.ClassType }
	PUSH	ES
	PUSH	DI
	PUSH	DX
	PUSH	AX
	CALL	TObject.InheritsFrom
	OR	AX,AX
	JZ	@@1			{ Destination isn't derived from Self }
	LES	DI, Self
	LES	DI, ES:[DI]		{ Call a class function }
	PUSH	ES
	PUSH	DI
	CALL	TObject.InstanceSize
	SUB	AX, 4			{ We do not touch the VMT }
	MOV	CX, AX			{ This is our byte counter }
	MOV	BX, DS			{ Save Data segment }
	LDS	SI, Self
	ADD	SI, 4			{ because of the far pointer to the VMT }
	LES	DI, Destination
	ADD	DI, 4			{ because of the far pointer to the VMT }
	CLD
	SHR	CX, 1			{ We will use MOVSW }
	REP	MOVSW
	JNC	@@2			{ Ok, the size is even }
	MOVSB				{ else we have to move one last byte }
@@2:	XOR	AX,AX
	INC	AX
	MOV	DS, BX			{ Restore data segment }
@@1:
END;

FUNCTION TExtendedObject.DupData2(Destination	: TExtendedObject) : BOOLEAN;

BEGIN
  Result	:= CopyData2(Destination);
END;

FUNCTION TExtendedObject.MoveData2(Destination	: TExtendedObject) : BOOLEAN;

BEGIN
  Result := CopyData2(Destination);
  IF Result THEN
  BEGIN
    InitInstance(Self);	{ Clear object first to reset all pointers to NIL. Dynamic }
    ClearData;		{ variables must not be deallocated !!!! Call ClearData }
  END;			{ so that the object knows it is cleared }
END;

PROCEDURE TExtendedObject.ClearData;

BEGIN
  InitInstance(Self);
END;

END.
