{
// OLEDEMO1.PAS (C) 1995 W. Raike
//              ALL RIGHTS RESERVED.
}
{*******************************************************************}
{
  User interface for demonstration driver for the OLE Automation server functions
  in Microsoft Word for Windows 6.0, using the TOLEAutomationClient component.

  Contact sraike@iconz.co.nz or CompuServe 100236,1656 for additional
  information on how to order the TOLEAutomation component.
}
{*******************************************************************}
unit Oledemo1;

interface

uses
  SysUtils, WinTypes, WinProcs, Forms, Dialogs, StdCtrls, Classes, Controls,
  OleAuto, WordCls;

type
  TfrmOLEDemo1 = class(TForm)
    btnSave: TButton;
    OleAutoClient1: TOleAutoClient;
    SaveDialog1: TSaveDialog;
    Memo1: TMemo;
    Label1: TLabel;
    btnInsert: TButton;
    btnExit: TButton;
    btnAllCaps: TButton;
    procedure btnSaveClick(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnInsertClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnAllCapsClick(Sender: TObject);
  public
    procedure DestroyObject;
  end;

var
  frmOLEDemo1: TfrmOLEDemo1;
  ooWord : TWordObj;
  bObExists : Boolean;

implementation

{$R *.DFM}

procedure TfrmOLEDemo1.DestroyObject;
begin
    { Release the OLE Automation object. }
    ooWord.Release;
    bObExists := False;
end;

procedure TfrmOLEDemo1.btnSaveClick(Sender: TObject);
begin
  if bObExists then
    if SaveDialog1.Execute then
      { Tell Word to save the document with the given file name. }
      ooWord.FileSaveAs(SaveDialog1.FileName);
end;

procedure TfrmOLEDemo1.btnExitClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmOLEDemo1.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
    if bObExists then
    begin
      { Tell Word to close the current document without saving it. }
      ooWord.FileClose(2);
      DestroyObject;
    end;
end;

procedure TfrmOLEDemo1.btnInsertClick(Sender: TObject);
var
   szText : array[0..4096] of char;
   psz : PChar;
begin
  if bObExists then
  begin
    psz := @szText[0];
    StrPLCopy(psz, Memo1.Text, 4096);
    { Insert contents of the Memo1 control at the insertion point in the Word document. }
    ooWord.Insert(psz);
  end;
end;

procedure TfrmOLEDemo1.FormCreate(Sender: TObject);
begin
  Application.HintPause := 100;
  Application.ShowHint := True;
  try
    { Activate Microsoft Word 6.0 for OLE Automation. }
    ooWord := TWordObj.CreateObject('word.basic');
    bObExists := True;
    { Have Word create a new document based on the NORMAL.DOT template. }
    ooWord.FileNew('normal.dot');
    { Move this window to the top of the z-order. }
    SetWindowPos(Handle, HWND_NOTOPMOST, 0,0,0,0, SWP_NOMOVE Or SWP_NOSIZE);
  except
    on EOLEAutoNoCreate do
      begin
        Application.MessageBox('Can''t start up Microsoft Word 6.0 .', 'TOLEAutomation Demo', MB_OK);
        Application.Terminate;
      end;
  end;
end;

procedure TfrmOLEDemo1.btnAllCapsClick(Sender: TObject);
begin
  if bObExists then
  begin
    ooWord.EditSelectAll;
    { Toggle upper/lower case of selection. }
    ooWord.AllCaps;
    { Cancel selection. }
    ooWord.Cancel;
  end;
end;

end.
