{
// WORDCLS.PAS (C) 1995 W. Raike
//              ALL RIGHTS RESERVED.
//   NOTICE:    This file consists of trade secrets that are the property
//              of William Raike.  The contents may not be used or disclosed
//              without express written permission of the owner.
}
unit WordCls;
{*******************************************************************}
{
  Class TWordObj that "mirrors" (some of) the properties and methods
  exposed by the Microsoft Word for Windows 6.0 OLE Automation server.
  This class inherits the protected methods of the TOleObject class,
  defined in OLEAUTO.DCU and distributed with the TOLEAutomationClient
  component.

  Contact sraike@iconz.co.nz or CompuServe 100236,1656 for additional
  information on how to order the TOLEAutomation component.
}
{*******************************************************************}

interface

uses
    SysUtils, OleAuto;

type
  TWordObj = class(TOleObject)
  public
    procedure FileNew(TemplateName : String);
    procedure ToolsMacro(MacroName : String);
    procedure FileClose(CloseMode : Integer);
    procedure ToolsOptionsEdit;
    procedure Insert(pszText : PChar);
    procedure FileSaveAs(FileName : String);
    procedure EditSelectAll;
    procedure AllCaps;
    procedure Cancel;
  end;

implementation
procedure TWordObj.ToolsOptionsEdit;
const
    pszMSW : PChar = 'Microsoft Word';
var
    x : Integer;
begin
    { It's necessary to supply ALL the arguments to ToolsOptionsEdit. }
    {  We always set the arguments in reverse order: i.e., right to left. }
    {
        For this WordBasic command, all the options indicate check-box status
        values (0 = unchecked) in the Word 6 Tools|Options\Edit dialog.
    }
    SetOleMethodArg('PChar', pszMSW); { .PictureEditor }

    x := 0; { Unchecked. }
    SetOleMethodArg('Integer', x);  { .AllowAccentedUppercase }
    SetOleMethodArg('Integer', x);  { .SmartCutPaste }
    SetOleMethodArg('Integer', x);  { .Overtype }
    SetOleMethodArg('Integer', x);  { .InsForPaste }
    SetOleMethodArg('Integer', x);  { .AutoWordSelection }

    x := 1; { Checked. }
    SetOleMethodArg('Integer', x);  { .DragAndDrop }
    SetOleMethodArg('Integer', x);  { .ReplaceSelection }
    CallOleProc('ToolsOptionsEdit');
end;

procedure TWordObj.FileNew(TemplateName : String);
const
    pszName : PChar = 'paaaaaaaaaaaaaaaaaaaaattttttthhhhhhhhhhhhhhhhhhhhhhhhhhhhhfilename.ext';
begin
    StrPLCopy(pszName, TemplateName, 40);
    SetOleMethodArg('PChar', pszName);
    CallOleProc('FileNew');
end;

procedure TWordObj.ToolsMacro(MacroName : String);
const
    pszName : PChar = 'paaaaaaaaaaaaaaaaaaaaattttttthhhhhhhhhhhhhhhhhhhhhhhhhhhhhfilename.ext';
var
    mode : Integer;
begin
    mode := 1;
    SetOleMethodArg('Integer', mode); { This arg *MUST* be present, even if its type is '' }
    StrPLCopy(pszName, MacroName, 40);
    SetOleMethodArg('PChar', pszName);
    CallOleProc('ToolsMacro');
end;

procedure TWordObj.FileClose(CloseMode : Integer);
begin
    SetOleMethodArg('Integer', CloseMode);
    CallOleProc('FileClose');
end;

procedure TWordObj.Insert(pszText : PChar);
begin
    SetOleMethodArg('PChar', pszText);
    CallOleProc('Insert');
end;

procedure TWordObj.FileSaveAs(FileName : String);
const
    pszName : PChar = 'paaaaaaaaaaaaaaaaaaaaattttttthhhhhhhhhhhhhhhhhhhhhhhhhhhhhfilename.ext';
begin
    StrPLCopy(pszName, FileName, 64);
    SetOleMethodArg('PChar', pszName);
    CallOleProc('FileSaveAs');
end;

procedure TWordObj.EditSelectAll;
begin
    CallOleProc('EditSelectAll');
end;

procedure TWordObj.AllCaps;
begin
    CallOleProc('AllCaps');
end;

procedure TWordObj.Cancel;
begin
    CallOleProc('Cancel');
end;

end.
