{This program is a sample of how to use the RegTest Unit.
 RegTest has two functions you can use for copy protecting your programs:

 The first function is TestReg. TestReg has two parameters:
 1) the input field text string, and 2) the eight digit integer that you
 want to use for the basis of the incryption. ie.
 TestReg(field text string, eight digit integer)
 TestReg will return one of two strings; either 'Valid' or 'Invalid'
 The RegMaster program can be used with this Unit to produce valid
 registration numbers.  Any eight digits can be used so long as the one used in
 RegMaster is the same as the one used in your program.
 There are 99,999,999 posssible combinations for the basis of the algorithm
 used in the RegTest unit.

 The second function is CountDays. CountDays has only one parameter:
 the path and name of a file or directory. ie.
 CountDays('c:\test\test.exe')
 CountDays will return an integer between 0 and 90.  CountDays will not count
 more than 90 days.
 CountDays compares the present date to the date of a file or directory.}

unit demo;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, RegTest;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    Edit2: TEdit;
    Label1: TLabel;
    Memo1: TMemo;
    Memo2: TMemo;
    procedure Edit1Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{both the form event OnActive, and the edit field event OnChange, should call this procedure }
procedure TForm1.Edit1Change(Sender: TObject);
var
Days : integer;
Valid: string;
begin
Valid:=TestReg(Edit1.Text, 87654321);
if Valid = 'Valid' then
 begin
  Edit1.Visible:=False;   {if Valid remove nag screens, or activate hidden options}
  Edit2.Visible:=False;
  Label1.Visible:=False;
 end;
Days:=CountDays((ExtractFilePath(ParamStr(0)))+'.');
{the above line uses the date of the directory the program was installed in.
If your program does not use an installation routine, you could date stamp a
file and use it.  But remember to replace the '.' above, to the name of the
file ie. 'test.exe'.}
Edit2.Text:=IntToStr(Days);
if (Valid = 'Invalid') and (Days > 15) then     {whatever number of days you want}
 begin
 Memo1.Visible:=True;      {and whatever else you want to do}
 end;
if (Valid ='Invalid') and (Days > 30) then      {whatever number of days you want}
 begin
 Memo2.Visible:=True;       {You could also stop the program from functioning}
 end;
end;

end.
